\name{rotation}
\alias{rotation}
\title{
Rotates Events to View Plate Boundary
}
\description{
Plots a cross section of depth for the selected events. Depth is on the vertical axis, and the view is theta degrees west of north.
}
\usage{
rotation(events, theta=0, km=TRUE, criteria=TRUE)
}
\arguments{
\item{events}{
defines the events to be plotted. It is an object of class \code{"subset"}, generally created by \code{\link[ssBase]{subsetcircle}}, \code{\link[ssBase]{subsetpolygon}}, \code{\link[ssBase]{subsetrect}} or \code{\link[ssBase]{subsetsphere}}.
}
\item{theta}{
number of degrees of the direction of view from north, positive to the west. For example, \code{theta=0} is viewing to the north (default) and for \code{theta=-45} one would be viewing towards the NE.
}
\item{km}{
if \code{TRUE} units of kilometres are used on the horizontal scale, if \code{FALSE} units of degrees are used.
}
\item{criteria}{
boolean variable. If \code{TRUE} (default) the subsetting parameters are printed below the graph.
}}
\seealso{
\code{\link{depth.hist}}, \code{\link{epicentres}}, \code{\link{freq.cusum}},
\code{\link{freq.magnitude}}, \code{\link{magnitude.cusum}},
\code{\link{magnitude.time}}, \code{\link{threeD}}, \code{\link{timeplot}},
\code{\link{multigraph}}
}
\examples{
#    These examples require the NZ catalogue

require(ssNZ)
b <- subsetrect(NZ, minlong=170, maxlong=180, minlat=-43,
                 maxlat=-35, minmag=3, minday=julian(1,1,1970),
                 maxday=julian(1,1,1993))


rotation(b, theta=-47)
title(main="NZ Plate Boundary")

#--------------------------------------------------------------------

#   Make the Wellington Catalogue
require(ssNZ)
as.catalogue(subsetrect(NZ, minlat=-42.2, maxlat=-40.5,
             minlong=173.6, maxlong=176.0, minday=julian(1,1,1978)),
             catname="Wellington")
    
b <- subsetrect(Wellington, minlong=173.6, maxlong=176.1, minlat=-42.0,
                maxlat=-40.3, minmag=2, minday=julian(1,1,1978),
                maxday=julian(1,1,1992), maxdepth=200)

rotation(b, theta=-40, km=FALSE)
title(main="Wellington Plate Boundary")
}

\keyword{hplot}

