\name{threeD}
\alias{threeD}
\title{
Dynamic 3D Plot of Earthquake Hypocentres
}
\description{
Dynamic three dimensional plot of earthquake hypocentres (longitude,
latitude and depth) locations.
}
\usage{
threeD(events)
}
\arguments{
\item{events}{
defines the events to be plotted. It is an object of class \code{"subset"}, generally created by \code{\link[ssBase]{subsetcircle}}, \code{\link[ssBase]{subsetpolygon}}, \code{\link[ssBase]{subsetrect}} or \code{\link[ssBase]{subsetsphere}}.
}}

\section{Installing the rggobi Package}{
This function uses the \code{ggobi} \R\ function to display the data and provide a dynamical graphics interface. The \code{ggobi} function is contained in the \pkg{rggobi} package, which is available from CRAN (\url{http://www.r-project.org}). 

The \pkg{rggobi} package in turn uses the ggobi system software, which is external to \R. The ggobi system software can be downloaded from \url{http://www.ggobi.org}. Installation instructions are included on that site.

One needs to install the same version of the \pkg{rggobi} package as that of the ggobi system software. Older versions of \pkg{rggobi} can be found by clicking on \dQuote{Archive} at the bottom of the contributed packages page on CRAN.
}

\seealso{
\code{\link{rotation}}
}
\examples{
#    This example requires the NZ catalogue

require(ssNZ)

#   Make the Wellington Catalogue
as.catalogue(subsetrect(NZ, minlat=-42.2, maxlat=-40.5,
             minlong=173.6, maxlong=176.0, minday=julian(1,1,1978)),
             catname="Wellington")

#   Cape Palliser Sequence
b <- subsetcircle(Wellington, centrelong=175.5, centrelat=-41.65,
                   maxradius=20, minday=julian(1,1,1990),
                   maxday=julian(1,1,1993), maxdepth=40)

threeD(b)
}

\keyword{dynamic}

