\name{timeplot}
\alias{timeplot}
\title{
Plots Event Frequencies by Time
}
\description{
Plots a histogram of the number of selected events by time interval, either months or years.
}
\usage{
timeplot(events, yearly=TRUE, smoothline=FALSE, ymax=NA)
}
\arguments{
\item{events}{
defines the events to be plotted. It is an object of class \code{"subset"}, generally created by \code{\link[ssBase]{subsetcircle}}, \code{\link[ssBase]{subsetpolygon}}, \code{\link[ssBase]{subsetrect}} or \code{\link[ssBase]{subsetsphere}}.
}

\item{yearly}{
boolean. Should each bar represent annual \code{TRUE} or monthly \code{FALSE} counts. Default is \code{TRUE}.
}
\item{smoothline}{
boolean. Plot a smoothed line over the counts. Default is \code{FALSE}. The smoothing is done using the function \code{\link[modreg]{supsmu}} which is contained in the package modreg.
}
\item{ymax}{
numeric, default is \code{NA}. Sets the upper limit of the \eqn{y} axis for the bar plot.
}}

\seealso{
\code{\link{depth.hist}}, \code{\link{freq.cusum}},
\code{\link{freq.magnitude}}, \code{\link{magnitude.cusum}},
\code{\link{magnitude.time}}, \code{\link{epicentres}}, \code{\link{threeD}},
\code{\link{rotation}}, \code{\link{multigraph}}
}
\examples{
#    This example requires the NZ catalogue

require(ssNZ)

b <- subsetrect(NZ, minday=julian(1,1,1961), minmag=4,
                 minlat=-50, maxlat=-33.5, minlong=165, maxlong=180)
timeplot(b)
title(main=expression(paste("Events in NZ With ", M[L] >= 4)))
}

\keyword{hplot}

