require(ssEDA, quietly = TRUE)
testregion <- matrix(scan("testregion.txt"), ncol=2)
colnames(testregion) <- c("lat", "lon")
polylong <- testregion[, "lon"]
polylat <- testregion[, "lat"]
lons <- round(range(polylong), digits=1)
minlon <- lons[1]; maxlon <- lons[2]
lats <- round(range(polylat), digits=1)
minlat <- lats[1]; maxlat <- lats[2]
n <- length(polylong)
m <- 4
for (lat in seq(minlat, maxlat, 0.1))
  for (lon in seq(minlon, maxlon, 0.1)) {
    event.long <- lon + c(-1, 1, 1, -1)*0.05
    event.lat <- lat + c(-1, -1, 1, 1)*0.05
    flag <- .Fortran("polyse", polylong = as.double(c(polylong, polylong[1])),
      polylat = as.double(c(polylat, polylat[1])), n = as.integer(n),
      eventx = as.double(event.long), eventy = as.double(event.lat),
      m = as.integer(m), flag = as.integer(rep(0, m)), PACKAGE = "ssBase")$flag
    if (sum(flag) == 4) cat(paste(format(lon, sci=T), ",", format(lat, sci=T), "\n", sep=""))
  }
