`readcat` <-
function(datafile) {
  require(ssBase, quietly = TRUE)
  NZraw <- matrix(scan(datafile, quiet=TRUE), ncol=15, byrow=TRUE)
  colnames(NZraw) <- c("Longitude", "Latitude", "year", "Month",
    "Day", "Magnitude", "Depth", "Hour", "Minute", "Second",
    "Horizontal_error", "Depth_error", "Magnitude_error", "Dummy1", "Dummy2")
  NZraw[, "year"] <- trunc(NZraw[, "year"])
  NZlist <- as.list(data.frame(NZraw[, c("Latitude", "Longitude", "year",
    "Month", "Day", "Hour", "Minute", "Second", "Magnitude", "Depth")]))
  names(NZlist) <- c("latitude", "longitude", "year", "month", "day",
    "hour", "minute", "second", "magnitude", "depth")
  as.catalogue(NZlist, catname="NZ", dp.second=2)
}
