`readcat` <-
function(csvfile) {
  require(ssBase, quietly = TRUE)
  raw.colnames <- read.csv(csvfile, header=F,  nrows=1, as.is=T)
  NZraw <- read.csv(csvfile, header=F, skip=1)
  colnames(NZraw) <- as.character(raw.colnames)
  NZlist <- as.list(NZraw[, c("LAT", "LONG", "ORI_YEAR", "ORI_MONTH",
    "ORI_DAY", "ORI_HOUR", "ORI_MINUTE", "ORI_SECOND", "MAG", "DEPTH")])
  names(NZlist) <- c("latitude", "longitude", "year", "month", "day",
    "hour", "minute", "second", "magnitude", "depth")
  as.catalogue(NZlist, catname="NZ", dp.second=2)
}
