/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.calc;

import java.text.DecimalFormat;

public final class GaussianDistCalc {
    static double d1 = 0.049867347;
    static double d2 = 0.0211410061;
    static double d3 = 0.0032776263;
    static double d4 = 3.80036E-5;
    static double d5 = 4.88906E-5;
    static double d6 = 5.383E-6;

    public static double getExceedProb(double standRandVariable) {
        return 1.0 - GaussianDistCalc.getCDF(standRandVariable);
    }

    public static double getExceedProb(double standRandVariable, int truncType, double truncLevel) {
        if (truncType == 2) {
            if (truncLevel <= 0.0) {
                throw new RuntimeException("GaussianDistCalc.getExceedProb(): truncLevel must be greater than zero for truncType=2");
            }
        } else if (truncLevel < 0.0) {
            throw new RuntimeException("GaussianDistCalc.getExceedProb(): truncLevel cannot be negative");
        }
        double prob = GaussianDistCalc.getCDF(standRandVariable);
        if (truncType == 1) {
            if (standRandVariable > truncLevel) {
                return 0.0;
            }
            double pUp = GaussianDistCalc.getCDF(truncLevel);
            return 1.0 - prob / pUp;
        }
        if (truncType == 2) {
            if (standRandVariable > truncLevel) {
                return 0.0;
            }
            if (standRandVariable < -truncLevel) {
                return 1.0;
            }
            double pUp = GaussianDistCalc.getCDF(truncLevel);
            double pLow = GaussianDistCalc.getCDF(-truncLevel);
            return (pUp - prob) / (pUp - pLow);
        }
        if (truncType == 0) {
            return 1.0 - prob;
        }
        throw new RuntimeException("GaussianDistCalc.getExceedProb(): truncType must be 0, 1, or 2");
    }

    public static double getExceedProb(double standRandVariable, double lowerTruncLevel, double upperTruncLevel) {
        if (lowerTruncLevel >= upperTruncLevel) {
            throw new RuntimeException("GaussianDistCalc.getExceedProb(): lowerTruncLevel should be less than upperTruncLevel");
        }
        double prob = GaussianDistCalc.getCDF(standRandVariable);
        if (standRandVariable > upperTruncLevel) {
            return 0.0;
        }
        if (standRandVariable < lowerTruncLevel) {
            return 1.0;
        }
        double pUp = GaussianDistCalc.getCDF(upperTruncLevel);
        double pLow = GaussianDistCalc.getCDF(lowerTruncLevel);
        return (pUp - prob) / (pUp - pLow);
    }

    public static double getCDF(double standRandVariable) {
        double val = Math.abs(standRandVariable);
        double result = 0.5 * Math.pow((((((d6 * val + d5) * val + d4) * val + d3) * val + d2) * val + d1) * val + 1.0, -16.0);
        if (standRandVariable < 0.0) {
            return result;
        }
        return 1.0 - result;
    }

    public static double getStandRandVar(double exceedProb, int truncType, double truncLevel, double tolerance) {
        float delta = 1.0f;
        double testNum = 100.0;
        double oldNum = 0.0;
        double prob = 100.0;
        if (tolerance < 1.0E-6 || tolerance > 0.1) {
            throw new RuntimeException("GaussianDistCalc.getStandRandVar(): tolerance is not within the allowed range");
        }
        if (exceedProb <= 0.5 && exceedProb > 0.0) {
            oldNum = -3.0;
            do {
                testNum = oldNum;
                while ((prob = GaussianDistCalc.getExceedProb(testNum += (double)delta, truncType, truncLevel)) >= exceedProb + tolerance * exceedProb) {
                }
                oldNum = testNum - (double)delta;
                delta /= 10.0f;
            } while (testNum - oldNum > tolerance);
            return testNum;
        }
        if (exceedProb > 0.5 && exceedProb < 1.0) {
            oldNum = 1.0;
            do {
                testNum = oldNum;
                while ((prob = GaussianDistCalc.getExceedProb(testNum -= (double)delta, truncType, truncLevel)) <= exceedProb - tolerance * exceedProb) {
                }
                oldNum = testNum + (double)delta;
                delta /= 10.0f;
            } while (oldNum - testNum > tolerance);
            return testNum;
        }
        if (exceedProb == 0.0) {
            if (truncType == 0) {
                return Double.POSITIVE_INFINITY;
            }
            return truncLevel;
        }
        if (exceedProb == 1.0) {
            if (truncType != 2) {
                return Double.NEGATIVE_INFINITY;
            }
            return -truncLevel;
        }
        throw new RuntimeException("invalid exceed probability (prob=" + exceedProb + ")");
    }

    public static double getStandRandVar(double exceedProb, double lowerTruncLevel, double upperTruncLevel, double tolerance) {
        if (lowerTruncLevel >= 0.0) {
            throw new RuntimeException("GaussianDistCalc.getStandRandVar(): lowerTruncLevel should be < 0");
        }
        if (upperTruncLevel < 0.0) {
            throw new RuntimeException("GaussianDistCalc.getStandRandVar(): upperTruncLevel should be \u00ef\u00bf\u00bd 0");
        }
        float delta = 1.0f;
        double testNum = 100.0;
        double oldNum = 0.0;
        double prob = 100.0;
        if (tolerance < 1.0E-6 || tolerance > 0.1) {
            throw new RuntimeException("GaussianDistCalc.getStandRandVar(): tolerance is not within the allowed range");
        }
        if (exceedProb <= 0.5 && exceedProb > 0.0) {
            oldNum = -3.0;
            do {
                testNum = oldNum;
                while ((prob = GaussianDistCalc.getExceedProb(testNum += (double)delta, lowerTruncLevel, upperTruncLevel)) >= exceedProb + tolerance * exceedProb) {
                }
                oldNum = testNum - (double)delta;
                delta /= 10.0f;
            } while (testNum - oldNum > tolerance);
            return testNum;
        }
        if (exceedProb > 0.5 && exceedProb < 1.0) {
            oldNum = 1.0;
            do {
                testNum = oldNum;
                while ((prob = GaussianDistCalc.getExceedProb(testNum -= (double)delta, lowerTruncLevel, upperTruncLevel)) <= exceedProb - tolerance * exceedProb) {
                }
                oldNum = testNum + (double)delta;
                delta /= 10.0f;
            } while (oldNum - testNum > tolerance);
            return testNum;
        }
        if (exceedProb == 0.0) {
            return upperTruncLevel;
        }
        if (exceedProb == 1.0) {
            return lowerTruncLevel;
        }
        throw new RuntimeException("invalid exceed probability (prob=" + exceedProb + ")");
    }

    public static boolean test1_getStandRandVar(double tol, int trTyp, double trLev) {
        double val_incr = 0.1;
        boolean success = true;
        DecimalFormat df2 = new DecimalFormat("#.0000");
        for (double val = -7.5; val <= 7.5; val += val_incr) {
            boolean testB;
            double p3;
            boolean testA;
            double n1 = (double)((int)(val * 10.0)) / 10.0;
            double p = GaussianDistCalc.getExceedProb(n1, trTyp, trLev);
            double n2 = GaussianDistCalc.getStandRandVar(p, trTyp, trLev, tol);
            double p2 = GaussianDistCalc.getExceedProb(n2, trTyp, trLev);
            if (p != 0.0) {
                testA = Math.abs((p - p2) / p) < tol;
            } else {
                boolean bl = testA = p2 == 0.0;
            }
            if (p > 0.5) {
                p3 = GaussianDistCalc.getExceedProb(n2 + tol, trTyp, trLev);
                testB = (p - p3) / p > tol;
            } else {
                p3 = GaussianDistCalc.getExceedProb(n2 - tol, trTyp, trLev);
                boolean bl = testB = (p3 - p) / p > tol;
            }
            if (p == 1.0 && trTyp == 2) {
                testB = true;
            }
            if (testA && testB) continue;
            success = false;
            System.out.println("n1=" + n1 + ";  p=" + p + ";  n2=" + n2 + ";  p2=" + p2 + ";  p3=" + p3 + ";  testA=" + testA + ";  testB=" + testB);
        }
        System.out.println("Success=" + success + " with tol=" + tol + " trTyp=" + trTyp + " & trLev=" + trLev);
        return success;
    }

    public static void test2_getStandRandVar() {
        GaussianDistCalc.test1_getStandRandVar(0.1, 0, 2.0);
        GaussianDistCalc.test1_getStandRandVar(0.1, 1, 0.0);
        GaussianDistCalc.test1_getStandRandVar(0.1, 1, 0.5);
        GaussianDistCalc.test1_getStandRandVar(0.1, 1, 1.5);
        GaussianDistCalc.test1_getStandRandVar(0.1, 1, 2.5);
        GaussianDistCalc.test1_getStandRandVar(0.1, 1, 3.5);
        GaussianDistCalc.test1_getStandRandVar(0.1, 2, 0.5);
        GaussianDistCalc.test1_getStandRandVar(0.1, 2, 1.5);
        GaussianDistCalc.test1_getStandRandVar(0.1, 2, 2.5);
        GaussianDistCalc.test1_getStandRandVar(0.1, 2, 3.5);
        GaussianDistCalc.test1_getStandRandVar(0.01, 0, 2.0);
        GaussianDistCalc.test1_getStandRandVar(0.01, 1, 0.0);
        GaussianDistCalc.test1_getStandRandVar(0.01, 1, 0.5);
        GaussianDistCalc.test1_getStandRandVar(0.01, 1, 1.5);
        GaussianDistCalc.test1_getStandRandVar(0.01, 1, 2.5);
        GaussianDistCalc.test1_getStandRandVar(0.01, 1, 3.5);
        GaussianDistCalc.test1_getStandRandVar(0.01, 2, 0.5);
        GaussianDistCalc.test1_getStandRandVar(0.01, 2, 1.5);
        GaussianDistCalc.test1_getStandRandVar(0.01, 2, 2.5);
        GaussianDistCalc.test1_getStandRandVar(0.01, 2, 3.5);
        GaussianDistCalc.test1_getStandRandVar(0.001, 0, 2.0);
        GaussianDistCalc.test1_getStandRandVar(0.001, 1, 0.0);
        GaussianDistCalc.test1_getStandRandVar(0.001, 1, 0.5);
        GaussianDistCalc.test1_getStandRandVar(0.001, 1, 1.5);
        GaussianDistCalc.test1_getStandRandVar(0.001, 1, 2.5);
        GaussianDistCalc.test1_getStandRandVar(0.001, 1, 3.5);
        GaussianDistCalc.test1_getStandRandVar(0.001, 2, 0.5);
        GaussianDistCalc.test1_getStandRandVar(0.001, 2, 1.5);
        GaussianDistCalc.test1_getStandRandVar(0.001, 2, 2.5);
        GaussianDistCalc.test1_getStandRandVar(0.001, 2, 3.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-4, 0, 2.0);
        GaussianDistCalc.test1_getStandRandVar(1.0E-4, 1, 0.0);
        GaussianDistCalc.test1_getStandRandVar(1.0E-4, 1, 0.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-4, 1, 1.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-4, 1, 2.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-4, 1, 3.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-4, 2, 0.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-4, 2, 1.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-4, 2, 2.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-4, 2, 3.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-5, 0, 2.0);
        GaussianDistCalc.test1_getStandRandVar(1.0E-5, 1, 0.0);
        GaussianDistCalc.test1_getStandRandVar(1.0E-5, 1, 0.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-5, 1, 1.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-5, 1, 2.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-5, 1, 3.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-5, 2, 0.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-5, 2, 1.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-5, 2, 2.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-5, 2, 3.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-6, 0, 2.0);
        GaussianDistCalc.test1_getStandRandVar(1.0E-6, 1, 0.0);
        GaussianDistCalc.test1_getStandRandVar(1.0E-6, 1, 0.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-6, 1, 1.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-6, 1, 2.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-6, 1, 3.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-6, 2, 0.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-6, 2, 1.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-6, 2, 2.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-6, 2, 3.5);
    }

    public static void testSpeed_getStandRandVar() {
        System.out.println("starting tol=1e-1");
        int i = 0;
        while ((double)i < 100000.0) {
            GaussianDistCalc.getStandRandVar(0.2, 0, 2.0, 0.1);
            ++i;
        }
        System.out.println("done");
        System.out.println("starting tol=1e-2");
        i = 0;
        while ((double)i < 100000.0) {
            GaussianDistCalc.getStandRandVar(0.2, 0, 2.0, 0.01);
            ++i;
        }
        System.out.println("done");
        System.out.println("starting tol=1e-3");
        i = 0;
        while ((double)i < 100000.0) {
            GaussianDistCalc.getStandRandVar(0.2, 0, 2.0, 0.001);
            ++i;
        }
        System.out.println("done");
        System.out.println("starting tol=1e-4");
        i = 0;
        while ((double)i < 100000.0) {
            GaussianDistCalc.getStandRandVar(0.2, 0, 2.0, 1.0E-4);
            ++i;
        }
        System.out.println("done");
        System.out.println("starting tol=1e-5");
        i = 0;
        while ((double)i < 100000.0) {
            GaussianDistCalc.getStandRandVar(0.2, 0, 2.0, 1.0E-5);
            ++i;
        }
        System.out.println("done");
        System.out.println("starting tol=1e-6");
        i = 0;
        while ((double)i < 100000.0) {
            GaussianDistCalc.getStandRandVar(0.2, 0, 2.0, 1.0E-6);
            ++i;
        }
        System.out.println("done");
    }

    public static void test_symmetry_getStandRandVar() {
        DecimalFormat df2 = new DecimalFormat("#.00");
        for (double prob = 0.1; prob >= 1.0E-7; prob /= 10.0) {
            for (double t = 0.1; t >= 1.0E-6; t /= 10.0) {
                System.out.println("getStandRandVar(" + (float)prob + ",0,2," + (float)t + ") = " + df2.format(GaussianDistCalc.getStandRandVar(prob, 0, 2.0, t)));
                System.out.println("getStandRandVar(" + (float)(1.0 - prob) + ",0,2," + (float)t + ") = " + df2.format(GaussianDistCalc.getStandRandVar(1.0 - prob, 0, 2.0, t)));
            }
            System.out.println("  ");
        }
    }

    public static void main(String[] args) {
        System.out.println(GaussianDistCalc.getCDF(Double.NEGATIVE_INFINITY));
        System.out.println(GaussianDistCalc.getCDF(Double.POSITIVE_INFINITY));
    }
}

