/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.calc;

import java.text.DecimalFormat;
import org.opensha.commons.data.Direction;
import org.opensha.commons.data.Location;

public final class RelativeLocation {
    public static final double TO_RAD = Math.toRadians(1.0);
    public static final double TO_DEG = Math.toDegrees(1.0);
    public static final double TWOPI = Math.PI * 2;
    public static final double PI_BY_2 = 1.5707963267948966;
    public static final double EARTH_RADIUS_MEAN = 6371.0072;
    public static final double EARTH_RADIUS_EQUATORIAL = 6378.137;
    public static final double EARTH_RADIUS_POLAR = 6356.7523;
    public static final int LL_PRECISION = 5;
    public static final DecimalFormat LL_FORMAT = new DecimalFormat("0.0####");
    public static final int R = 6367;
    public static final double RADIANS_CONVERSION = Math.PI / 180;
    public static final double D_COEFF = 111.11;

    private RelativeLocation() {
    }

    public static double angle(Location p1, Location p2) {
        double lat1 = p1.getLatRad();
        double lat2 = p2.getLatRad();
        double sinDlatBy2 = Math.sin((lat2 - lat1) / 2.0);
        double sinDlonBy2 = Math.sin((p2.getLonRad() - p1.getLonRad()) / 2.0);
        double c = sinDlatBy2 * sinDlatBy2 + Math.cos(lat1) * Math.cos(lat2) * sinDlonBy2 * sinDlonBy2;
        return 2.0 * Math.atan2(Math.sqrt(c), Math.sqrt(1.0 - c));
    }

    public static double surfaceDistance(Location p1, Location p2) {
        return 6371.0072 * RelativeLocation.angle(p1, p2);
    }

    public static double surfaceDistanceFast(Location p1, Location p2) {
        double lat1 = p1.getLatRad();
        double lat2 = p2.getLatRad();
        double dLat = lat1 - lat2;
        double dLon = (p1.getLonRad() - p2.getLonRad()) * Math.cos((lat1 + lat2) * 0.5);
        return 6371.0072 * Math.sqrt(dLat * dLat + dLon * dLon);
    }

    public static double linearDistance(Location p1, Location p2) {
        double alpha = RelativeLocation.angle(p1, p2);
        double R1 = 6371.0072 - p1.getDepth();
        double R2 = 6371.0072 - p2.getDepth();
        double B = R1 * Math.sin(alpha);
        double C = R2 - R1 * Math.cos(alpha);
        return Math.sqrt(B * B + C * C);
    }

    public static double linearDistanceFast(Location p1, Location p2) {
        double h = RelativeLocation.surfaceDistanceFast(p1, p2);
        double v = RelativeLocation.getVertDistance(p1, p2);
        return Math.sqrt(h * h + v * v);
    }

    public static double azimuthRad(Location p1, Location p2) {
        double lat1 = p1.getLatRad();
        double lat2 = p2.getLatRad();
        if (RelativeLocation.isPole(p1)) {
            return lat1 > 0.0 ? Math.PI : 0.0;
        }
        double dLon = p2.getLonRad() - p1.getLonRad();
        double cosLat2 = Math.cos(lat2);
        double azRad = Math.atan2(Math.sin(dLon) * cosLat2, Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * cosLat2 * Math.cos(dLon));
        return (azRad + Math.PI * 2) % (Math.PI * 2);
    }

    public static double azimuth(Location p1, Location p2) {
        return RelativeLocation.azimuthRad(p1, p2) * TO_DEG;
    }

    public static Location location(Location origin, double bearing, double distance) {
        double lat1 = origin.getLatRad();
        double lon1 = origin.getLonRad();
        double sinLat1 = Math.sin(lat1);
        double cosLat1 = Math.cos(lat1);
        double d = distance / 6371.0072;
        double sinD = Math.sin(d);
        double cosD = Math.cos(d);
        double lat2 = Math.asin(sinLat1 * cosD + cosLat1 * sinD * Math.cos(bearing));
        double lon2 = lon1 + Math.atan2(Math.sin(bearing) * sinD * cosLat1, cosD - sinLat1 * Math.sin(lat2));
        return new Location(lat2 * TO_DEG, lon2 * TO_DEG);
    }

    public static Direction getDirection(Location location1, Location location2) throws UnsupportedOperationException {
        Direction dir = new Direction();
        double lat1 = location1.getLatitude();
        double lon1 = location1.getLongitude();
        double lat2 = location2.getLatitude();
        double lon2 = location2.getLongitude();
        double horzDistance = RelativeLocation.getHorzDistance(lat1, lon1, lat2, lon2);
        double azimuth = RelativeLocation.getAzimuth(lat1, lon1, lat2, lon2);
        double backAzimuth = RelativeLocation.getBackAzimuth(lat1, lon1, lat2, lon2);
        double vertDistance = location2.getDepth() - location1.getDepth();
        dir.setHorzDistance(horzDistance);
        dir.setAzimuth(azimuth);
        dir.setBackAzimuth(backAzimuth);
        dir.setVertDistance(vertDistance);
        return dir;
    }

    public static double getTotalDistance(Location loc1, Location loc2) {
        double hDist = RelativeLocation.getHorzDistance(loc1, loc2);
        double vDist = RelativeLocation.getVertDistance(loc1, loc2);
        return Math.sqrt(hDist * hDist + vDist * vDist);
    }

    public static double getVertDistance(Location p1, Location p2) {
        return p2.getDepth() - p1.getDepth();
    }

    public static Location getLocation(Location location, Direction direction) throws UnsupportedOperationException {
        double lat1 = location.getLatitude();
        double lon1 = location.getLongitude();
        double depth = location.getDepth();
        double azimuth = direction.getAzimuth();
        double horzDistance = direction.getHorzDistance();
        double vertDistance = direction.getVertDistance();
        double newLat = RelativeLocation.getLatitude(horzDistance, azimuth, lat1, lon1);
        double newLon = RelativeLocation.getLongitude(horzDistance, azimuth, lat1, lon1);
        double newDepth = depth + vertDistance;
        Location newLoc = new Location(newLat, newLon, newDepth);
        return newLoc;
    }

    private static double getLatitude(double delta, double azimuth, double lat, double lon) {
        delta = delta / 111.11 * (Math.PI / 180);
        double sdelt = Math.sin(delta);
        double cdelt = Math.cos(delta);
        double xlat = lat * (Math.PI / 180);
        double az2 = azimuth * (Math.PI / 180);
        double st0 = Math.cos(xlat);
        double ct0 = Math.sin(xlat);
        double cz0 = Math.cos(az2);
        double ct1 = st0 * sdelt * cz0 + ct0 * cdelt;
        double x = st0 * cdelt - ct0 * sdelt * cz0;
        double y = sdelt * Math.sin(az2);
        double st1 = Math.pow(x * x + y * y, 0.5);
        double newLat = Math.atan2(ct1, st1) / (Math.PI / 180);
        return newLat;
    }

    private static double getLongitude(double delta, double azimuth, double lat, double lon) {
        delta = delta / 111.11 * (Math.PI / 180);
        double sdelt = Math.sin(delta);
        double cdelt = Math.cos(delta);
        double xlat = lat * (Math.PI / 180);
        double xlon = lon * (Math.PI / 180);
        double az2 = azimuth * (Math.PI / 180);
        double st0 = Math.cos(xlat);
        double ct0 = Math.sin(xlat);
        double phi0 = xlon;
        double cz0 = Math.cos(az2);
        double x = st0 * cdelt - ct0 * sdelt * cz0;
        double y = sdelt * Math.sin(az2);
        double dlon = Math.atan2(y, x);
        double newLon = (phi0 + dlon) / (Math.PI / 180);
        return newLon;
    }

    private static double getApproxHorzDistance(double lat1, double lon1, double lat2, double lon2) {
        double d1 = (lat1 - lat2) * 111.111;
        double d2 = (lon1 - lon2) * 111.111 * Math.cos((lat1 + lat2) / 2.0 * Math.PI / 180.0);
        return Math.sqrt(d1 * d1 + d2 * d2);
    }

    private static double getHorzDistance(double lat1, double lon1, double lat2, double lon2) {
        double xlat = lat1 * (Math.PI / 180);
        double xlon = lon1 * (Math.PI / 180);
        double st0 = Math.cos(xlat);
        double ct0 = Math.sin(xlat);
        double phi0 = xlon;
        xlat = lat2 * (Math.PI / 180);
        xlon = lon2 * (Math.PI / 180);
        double st1 = Math.cos(xlat);
        double ct1 = Math.sin(xlat);
        double sdlon = Math.sin(xlon - phi0);
        double cdlon = Math.cos(xlon - phi0);
        double cdelt = st0 * st1 * cdlon + ct0 * ct1;
        double x = st0 * ct1 - st1 * ct0 * cdlon;
        double y = st1 * sdlon;
        double sdelt = Math.pow(x * x + y * y, 0.5);
        double delta = Math.atan2(sdelt, cdelt) / (Math.PI / 180);
        return delta *= 111.11;
    }

    public static double getApproxHorzDistance(Location loc1, Location loc2) {
        return RelativeLocation.getApproxHorzDistance(loc1.getLatitude(), loc1.getLongitude(), loc2.getLatitude(), loc2.getLongitude());
    }

    public static double getHorzDistance(Location loc1, Location loc2) {
        return RelativeLocation.getHorzDistance(loc1.getLatitude(), loc1.getLongitude(), loc2.getLatitude(), loc2.getLongitude());
    }

    private static double getAzimuth(double lat1, double lon1, double lat2, double lon2) {
        double xlat = lat1 * (Math.PI / 180);
        double xlon = lon1 * (Math.PI / 180);
        double st0 = Math.cos(xlat);
        double ct0 = Math.sin(xlat);
        double phi0 = xlon;
        xlat = lat2 * (Math.PI / 180);
        xlon = lon2 * (Math.PI / 180);
        double st1 = Math.cos(xlat);
        double ct1 = Math.sin(xlat);
        double sdlon = Math.sin(xlon - phi0);
        double cdlon = Math.cos(xlon - phi0);
        double x = st0 * ct1 - st1 * ct0 * cdlon;
        double y = st1 * sdlon;
        double az = Math.atan2(y, x) / (Math.PI / 180);
        return az;
    }

    public static double getAzimuth(Location loc1, Location loc2) {
        return RelativeLocation.getAzimuth(loc1.getLatitude(), loc1.getLongitude(), loc2.getLatitude(), loc2.getLongitude());
    }

    private static double getBackAzimuth(double lat1, double lon1, double lat2, double lon2) {
        double xlat = lat1 * (Math.PI / 180);
        double xlon = lon1 * (Math.PI / 180);
        double st0 = Math.cos(xlat);
        double ct0 = Math.sin(xlat);
        double phi0 = xlon;
        xlat = lat2 * (Math.PI / 180);
        xlon = lon2 * (Math.PI / 180);
        double st1 = Math.cos(xlat);
        double ct1 = Math.sin(xlat);
        double sdlon = Math.sin(xlon - phi0);
        double cdlon = Math.cos(xlon - phi0);
        double x = st1 * ct0 - st0 * ct1 * cdlon;
        double y = -sdlon * st0;
        double baz = Math.atan2(y, x) / (Math.PI / 180);
        return baz;
    }

    public static double distanceToLine(Location p1, Location p2, Location p3) {
        double ad13 = RelativeLocation.angle(p1, p3);
        double Daz13az12 = RelativeLocation.azimuthRad(p1, p3) - RelativeLocation.azimuthRad(p1, p2);
        double xtdRad = Math.asin(Math.sin(ad13) * Math.sin(Daz13az12));
        double atd = Math.acos(Math.cos(ad13) / Math.cos(xtdRad)) * 6371.0072;
        if (atd > RelativeLocation.surfaceDistance(p1, p2)) {
            return RelativeLocation.surfaceDistance(p2, p3);
        }
        if (Math.cos(Daz13az12) < 0.0) {
            return RelativeLocation.surfaceDistance(p1, p3);
        }
        return xtdRad * 6371.0072;
    }

    public static double getApproxHorzDistToLine(Location p1, Location p2, Location p3) {
        double dist;
        double lat1 = p1.getLatRad();
        double lat2 = p2.getLatRad();
        double lat3 = p3.getLatRad();
        double lon1 = p1.getLonRad();
        double lon2 = p2.getLonRad();
        double lon3 = p3.getLonRad();
        double lonScale = Math.cos(0.5 * lat3 + 0.25 * lat1 + 0.25 * lat2);
        double x1 = (lon1 - lon3) * lonScale;
        double x2 = (lon2 - lon3) * lonScale;
        double y1 = lat1 - lat3;
        double y2 = lat2 - lat3;
        if (Math.abs(x1 - x2) > 1.0E-6) {
            double m = (y2 - y1) / (x2 - x1);
            double b = y2 - m * x2;
            double xT = -m * b / (1.0 + m * m);
            double yT = m * xT + b;
            boolean betweenPts = false;
            if (x2 > x1) {
                if (xT <= x2 && xT >= x1) {
                    betweenPts = true;
                }
            } else if (xT <= x1 && xT >= x2) {
                betweenPts = true;
            }
            if (betweenPts) {
                dist = Math.sqrt(xT * xT + yT * yT);
            } else {
                double d1 = Math.sqrt(x1 * x1 + y1 * y1);
                double d2 = Math.sqrt(x2 * x2 + y2 * y2);
                dist = Math.min(d1, d2);
            }
        } else {
            dist = y2 > y1 ? (y2 <= 0.0 ? Math.sqrt(x2 * x2 + y2 * y2) : (y1 >= 0.0 ? Math.sqrt(x1 * x1 + y1 * y1) : Math.abs(x1))) : (y1 <= 0.0 ? Math.sqrt(x1 * x1 + y1 * y1) : (y2 >= 0.0 ? Math.sqrt(x2 * x2 + y2 * y2) : Math.abs(x1)));
        }
        return dist * 6371.0072;
    }

    public static double radiusAtLocation(Location p) {
        double cosL = Math.cos(p.getLatRad());
        double sinL = Math.sin(p.getLatRad());
        double C1 = cosL * 6378.137;
        double C2 = C1 * 6378.137;
        double C3 = sinL * 6356.7523;
        double C4 = C3 * 6356.7523;
        return Math.sqrt((C2 * C2 + C4 * C4) / (C1 * C1 + C3 * C3));
    }

    public static double degreesLatPerKm(Location p) {
        return TO_DEG / RelativeLocation.radiusAtLocation(p);
    }

    public static double degreesLonPerKm(Location p) {
        return TO_DEG / (6378.137 * Math.cos(p.getLatRad()));
    }

    public static double getDeltaLatFromKm(double km) {
        return km / 111.14;
    }

    public static double getDeltaLonFromKm(double lat, double km) {
        double radius = 6367.0 * Math.cos(Math.toRadians(lat));
        double longDistVal = Math.PI * 2 * radius / 360.0;
        return km / longDistVal;
    }

    public static boolean isPole(Location loc) {
        return Math.cos(loc.getLatRad()) < 1.0E-12;
    }

    public static void main(String[] args) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Side {
        RIGHT,
        LEFT,
        ON;

    }
}

