/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import org.opensha.commons.data.DataPoint2D;
import org.opensha.commons.data.DataPoint2DComparatorAPI;
import org.opensha.commons.data.DataPoint2DToleranceComparator;
import org.opensha.commons.data.TreeMap;
import org.opensha.commons.exceptions.InvalidRangeException;

public class DataPoint2DTreeMap
extends TreeMap {
    private static final long serialVersionUID = 216179579L;
    protected static final Object PRESENT = new Object();
    protected boolean first = true;
    public DataPoint2DComparatorAPI comparator = new DataPoint2DToleranceComparator();

    public DataPoint2DTreeMap() {
        this.comparator = new DataPoint2DToleranceComparator();
    }

    public DataPoint2DTreeMap(Comparator c) {
        super(c);
        this.first = true;
    }

    public void setTolerance(double newTolerance) throws InvalidRangeException {
        if (newTolerance < 0.0) {
            throw new InvalidRangeException("Tolerance must be larger or equal to 0");
        }
        this.comparator.setTolerance(newTolerance);
    }

    public DataPoint2DTreeMap setComparator(DataPoint2DComparatorAPI comparator) {
        DataPoint2DTreeMap map = new DataPoint2DTreeMap(comparator);
        Set set = this.keySet();
        for (DataPoint2D d2 : set) {
            map.put(d2);
        }
        map.comparator = comparator;
        return map;
    }

    public DataPoint2D get(int index) {
        if (index >= this.size()) {
            return null;
        }
        Set set = this.keySet();
        Iterator it = set.iterator();
        DataPoint2D point = null;
        for (int counter = 0; counter <= index; ++counter) {
            point = (DataPoint2D)it.next();
        }
        return point;
    }

    public DataPoint2D get(double x) {
        Set set = this.keySet();
        Iterator it = set.iterator();
        DataPoint2D point = null;
        DataPoint2D findPoint = new DataPoint2D(x, 0.0);
        while (it.hasNext()) {
            point = (DataPoint2D)it.next();
            if (this.comparator.compare(point, findPoint) != 0) continue;
            return point;
        }
        return null;
    }

    public int getIndex(DataPoint2D point) {
        Set set = this.keySet();
        Iterator it = set.iterator();
        DataPoint2D point2 = null;
        int counter = 0;
        while (it.hasNext()) {
            point2 = (DataPoint2D)it.next();
            if (this.comparator.compare(point, point2) == 0) {
                return counter;
            }
            ++counter;
        }
        return -1;
    }

    public double getMinY() {
        double minY = Double.NaN;
        Set set = this.keySet();
        Iterator it = set.iterator();
        if (it.hasNext()) {
            minY = ((DataPoint2D)it.next()).getY();
        }
        DataPoint2D point2 = null;
        while (it.hasNext()) {
            point2 = (DataPoint2D)it.next();
            if (!(point2.getY() < minY)) continue;
            minY = point2.getY();
        }
        return minY;
    }

    public double getMaxY() {
        double maxY = Double.NaN;
        Set set = this.keySet();
        Iterator it = set.iterator();
        if (it.hasNext()) {
            maxY = ((DataPoint2D)it.next()).getY();
        }
        DataPoint2D point2 = null;
        while (it.hasNext()) {
            point2 = (DataPoint2D)it.next();
            if (!(point2.getY() > maxY)) continue;
            maxY = point2.getY();
        }
        return maxY;
    }

    public double getTolerance() {
        return this.comparator.getTolerance();
    }

    public Object put(Object key, Object value) {
        if (key instanceof DataPoint2D) {
            return this.put((DataPoint2D)key);
        }
        throw new ClassCastException("This treemap accepts only DataPoint2Ds");
    }

    public Object put(DataPoint2D key) {
        Object value = PRESENT;
        TreeMap.Entry t = this.root;
        if (t == null) {
            this.incrementSize();
            this.root = new TreeMap.Entry(key, value, null);
            return null;
        }
        while (true) {
            int cmp;
            if ((cmp = this.compare(key, t.key)) == 0) {
                t.key = key;
                return t.setValue(value);
            }
            if (cmp < 0) {
                if (t.left != null) {
                    t = t.left;
                    continue;
                }
                this.incrementSize();
                t.left = new TreeMap.Entry(key, value, t);
                this.fixAfterInsertion(t.left);
                return null;
            }
            if (t.right == null) break;
            t = t.right;
        }
        this.incrementSize();
        t.right = new TreeMap.Entry(key, value, t);
        this.fixAfterInsertion(t.right);
        return null;
    }

    public void clear() {
        super.clear();
        this.first = true;
    }
}

