/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Element;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.NamedObjectAPI;
import org.opensha.commons.metadata.XMLSaveable;
import org.opensha.commons.param.ParameterAPI;
import org.opensha.commons.param.ParameterList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Site
extends ParameterList
implements NamedObjectAPI,
Serializable,
XMLSaveable {
    protected static final String C = "Site";
    public static String XML_METADATA_NAME = "Site";
    public static String XML_PARAMS_NAME = "SiteParams";
    public static String XML_METADATA_LIST_NAME = "Sites";
    protected static final boolean D = false;
    public String name;
    protected Location location;

    public Site() {
    }

    public Site(Location location) {
        this.location = location;
    }

    public Site(Location location, String name) {
        this.location = location;
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Location getLocation() {
        return this.location;
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(C);
        b.append(" : ");
        b.append("Name = ");
        b.append(this.name);
        b.append(" : ");
        b.append("Location = ");
        b.append(this.location.toString());
        b.append(" : ");
        b.append("Parameters = ");
        b.append(super.toString());
        return b.toString();
    }

    public boolean equalsSite(Site site) {
        if (!this.name.equals(site.name)) {
            return false;
        }
        if (!this.location.equalsLocation(site.location)) {
            return false;
        }
        if (this.size() != site.size()) {
            return false;
        }
        ListIterator<ParameterAPI> it = this.getParametersIterator();
        while (it.hasNext()) {
            ParameterAPI param1 = it.next();
            if (!site.containsParameter(param1.getName())) {
                return false;
            }
            ParameterAPI param2 = site.getParameter(param1.getName());
            if (!((Object)param1).equals(param2)) {
                return false;
            }
            try {
                if (param1.compareTo(param2) == 0) continue;
                return false;
            }
            catch (ClassCastException ee) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Site) {
            return this.equalsSite((Site)obj);
        }
        return false;
    }

    @Override
    public Object clone() {
        String S = "Site: clone(): ";
        Site site = new Site();
        site.setName(this.getName());
        site.setLocation(this.location.copy());
        if (this.size() < 1) {
            return site;
        }
        int size = this.params.size();
        for (int i = 0; i < size; ++i) {
            ParameterAPI param = (ParameterAPI)this.params.get(i);
            site.addParameter((ParameterAPI)param.clone());
        }
        return site;
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element siteEl = root.addElement(XML_METADATA_NAME);
        siteEl = this.getLocation().toXMLMetadata(siteEl);
        Element paramsEl = siteEl.addElement(XML_PARAMS_NAME);
        ListIterator<ParameterAPI> paramIt = this.getParametersIterator();
        while (paramIt.hasNext()) {
            ParameterAPI param = paramIt.next();
            paramsEl = param.toXMLMetadata(paramsEl);
        }
        return root;
    }

    public static Site fromXMLMetadata(Element siteEl, ArrayList<ParameterAPI> paramsToAdd) {
        Element locEl = siteEl.element("Location");
        Location loc = Location.fromXMLMetadata(locEl);
        Site site = new Site(loc);
        for (ParameterAPI param : paramsToAdd) {
            site.addParameter(param);
        }
        Element paramsEl = siteEl.element(XML_PARAMS_NAME);
        ParameterList.setParamsInListFromXML(site, paramsEl);
        return site;
    }

    public static Element writeSitesToXML(List<Site> sites, Element root) {
        Element sitesEl = root.addElement(XML_METADATA_LIST_NAME);
        for (Site site : sites) {
            sitesEl = site.toXMLMetadata(sitesEl);
        }
        return root;
    }

    public static ArrayList<Site> loadSitesFromXML(Element sitesEl, ArrayList<ParameterAPI> paramsToAdd) {
        Iterator it = sitesEl.elementIterator(XML_METADATA_NAME);
        ArrayList<Site> sites = new ArrayList<Site>();
        while (it.hasNext()) {
            Element siteEl = (Element)it.next();
            sites.add(Site.fromXMLMetadata(siteEl, paramsToAdd));
        }
        return sites;
    }
}

