/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.estimate;

import org.opensha.commons.calc.GaussianDistCalc;
import org.opensha.commons.data.estimate.Estimate;
import org.opensha.commons.data.estimate.InvalidParamValException;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;

public class LogNormalEstimate
extends Estimate {
    public static final String NAME = "Log Normal";
    private double linearMedian;
    private double stdDev;
    private boolean isBase10 = true;
    private static final String MSG_INVALID_MEDIAN = "Error: linear-median must be positive.";
    private static final String MSG_INVALID_MINMAX = "Error: the minimum and maximum X-axis values can only be 0.0 and  Infinity, respectively.";
    private static final double LOG10_VAL = Math.log(10.0);

    public LogNormalEstimate(double linearMedian, double stdDev) {
        this.setLinearMedian(linearMedian);
        this.setStdDev(stdDev);
        this.min = 0.0;
        this.max = Double.POSITIVE_INFINITY;
    }

    public String toString() {
        String logBase = "E";
        if (this.isBase10) {
            logBase = "10";
        }
        return "Estimate Type=" + this.getName() + "\n" + "Linear Median=" + this.getLinearMedian() + "\n" + "Standard Deviation=" + this.getStdDev() + "\n" + "Log Base=" + logBase + "\n" + "Left Truncation Sigma=" + this.getMinSigma() + "\n" + "Right Truncation Sigma=" + this.getMaxSigma();
    }

    public void setLinearMedian(double median) {
        if (median < 0.0) {
            throw new InvalidParamValException(MSG_INVALID_MEDIAN);
        }
        this.linearMedian = median;
    }

    public double getLinearMedian() {
        return this.linearMedian;
    }

    public void setStdDev(double stdDev) {
        if (stdDev < 0.0) {
            throw new InvalidParamValException("Error: Standard deviation must be positive.");
        }
        this.stdDev = stdDev;
    }

    public double getStdDev() {
        return this.stdDev;
    }

    public boolean getIsBase10() {
        return this.isBase10;
    }

    public void setIsBase10(boolean isBase10) {
        this.isBase10 = isBase10;
    }

    public double getMean() {
        throw new UnsupportedOperationException("Method getMean() not yet implemented.");
    }

    public double getFractile(double prob) {
        double stdRndVar = GaussianDistCalc.getStandRandVar(1.0 - prob, this.getStandRandVar(this.min), this.getStandRandVar(this.max), 1.0E-6);
        return this.getUnLogVal(this.getLogVal(this.linearMedian) + stdRndVar * this.stdDev);
    }

    private double getLogVal(double val) {
        double logVal = Math.log(val);
        if (this.isBase10) {
            return logVal / LOG10_VAL;
        }
        return logVal;
    }

    private double getUnLogVal(double logVal) {
        if (this.isBase10) {
            return Math.pow(10.0, logVal);
        }
        return Math.exp(logVal);
    }

    private double getStandRandVar(double val) {
        if (val == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (val == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        return this.getLogVal(val / this.linearMedian) / this.stdDev;
    }

    public double getMode() {
        throw new UnsupportedOperationException("Method getMode() not yet implemented.");
    }

    public double getMedian() {
        return 0.0;
    }

    public String getName() {
        return NAME;
    }

    public void setMinMax(double min, double max) {
        if (max < min) {
            throw new InvalidParamValException("Error: Minimum must be less than Maximum");
        }
        if (min < 0.0 || max < 0.0) {
            throw new InvalidParamValException(MSG_INVALID_MINMAX);
        }
        this.max = max;
        this.min = min;
    }

    public void setMinMaxSigmas(double minSigma, double maxSigma) {
        if (maxSigma < minSigma) {
            throw new InvalidParamValException("Error: Minimum must be less than Maximum");
        }
        double min = this.getUnLogVal(this.getLogVal(this.linearMedian) + this.getLogVal(minSigma * this.stdDev));
        double max = this.getUnLogVal(this.getLogVal(this.linearMedian) + this.getLogVal(maxSigma * this.stdDev));
        if (min < 0.0 || max < 0.0) {
            throw new InvalidParamValException(MSG_INVALID_MINMAX);
        }
        this.min = min;
        this.max = max;
    }

    public double getMinSigma() {
        return this.getUnLogVal(this.getLogVal(this.min) - this.getLogVal(this.linearMedian)) / this.stdDev;
    }

    public double getMaxSigma() {
        return this.getUnLogVal(this.getLogVal(this.max) - this.getLogVal(this.linearMedian)) / this.stdDev;
    }

    public DiscretizedFunc getPDF_Test() {
        EvenlyDiscretizedFunc func = this.getEvenlyDiscretizedFunc();
        double deltaX = func.getDelta();
        int numPoints = func.getNum();
        for (int i = 0; i < numPoints; ++i) {
            double x = func.getX(i);
            if (x - deltaX / 2.0 <= 0.0) {
                func.set(i, this.getProbLessThanEqual(x + deltaX / 2.0));
                continue;
            }
            func.set(i, this.getProbLessThanEqual(x + deltaX / 2.0) - this.getProbLessThanEqual(x - deltaX / 2.0));
        }
        func.setInfo("PDF from LogNormal Distribution");
        return func;
    }

    public DiscretizedFunc getCDF_Test() {
        EvenlyDiscretizedFunc func = this.getEvenlyDiscretizedFunc();
        int numPoints = func.getNum();
        for (int i = 0; i < numPoints; ++i) {
            func.set(i, this.getProbLessThanEqual(func.getX(i)));
        }
        func.setInfo("CDF from LogNormal Distribution using getProbLessThanEqual() method");
        return func;
    }

    private EvenlyDiscretizedFunc getEvenlyDiscretizedFunc() {
        double minX = 0.0;
        double maxX = this.linearMedian * this.getUnLogVal(3.0 * this.stdDev);
        int numPoints = 320;
        EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc(minX, maxX, numPoints);
        return func;
    }

    public double getProbLessThanEqual(double val) {
        return 1.0 - GaussianDistCalc.getExceedProb(this.getStandRandVar(val), this.getStandRandVar(this.min), this.getStandRandVar(this.max));
    }

    public static void main(String[] args) {
        LogNormalEstimate estimate = new LogNormalEstimate(5.0, 0.5);
        estimate.setMinMaxSigmas(2.0, 2.0);
        System.out.println(estimate.getMinSigma());
        System.out.println(estimate.getMaxSigma());
    }
}

