/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.function;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.dom4j.Element;
import org.opensha.commons.data.NamedObjectAPI;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFuncAPI;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.util.FileUtils;

public abstract class DiscretizedFunc
implements DiscretizedFuncAPI,
NamedObjectAPI,
Serializable {
    private static final long serialVersionUID = 2798699443929196424L;
    protected static final String C = "DiscretizedFunc";
    protected static final boolean D = false;
    public static final String XML_METADATA_NAME = "discretizedFunction";
    public static final String XML_METADATA_POINTS_NAME = "Points";
    public static final String XML_METADATA_POINT_NAME = "Point";
    protected double tolerance = 0.0;
    protected String info = "";
    protected String name = "";
    private String xAxisName;
    private String yAxisName;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double newTolerance) throws InvalidRangeException {
        if (newTolerance < 0.0) {
            throw new InvalidRangeException("Tolerance must be larger or equal to 0");
        }
        this.tolerance = newTolerance;
    }

    public void setXAxisName(String xName) {
        this.xAxisName = xName;
    }

    public String getXAxisName() {
        return this.xAxisName;
    }

    public void setYAxisName(String yName) {
        this.yAxisName = yName;
    }

    public String getYAxisName() {
        return this.yAxisName;
    }

    public boolean equals(DiscretizedFuncAPI function) {
        if (!this.getName().equals(function.getName())) {
            return false;
        }
        return this.getInfo().equals(function.getInfo());
    }

    public double getClosestX(double y) {
        double x = Double.NaN;
        double dist = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.getNum(); ++i) {
            double newY = this.getY(i);
            double newDist = Math.abs(newY - y);
            if (!(newDist < dist)) continue;
            dist = newDist;
            x = this.getX(i);
        }
        return x;
    }

    public double getClosestY(double x) {
        double y = Double.NaN;
        double dist = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.getNum(); ++i) {
            double newX = this.getX(i);
            double newDist = Math.abs(newX - x);
            if (!(newDist < dist)) continue;
            dist = newDist;
            y = this.getY(i);
        }
        return y;
    }

    public Element toXMLMetadata(Element root) {
        Element xml = root.addElement(XML_METADATA_NAME);
        xml.addAttribute("info", this.getInfo());
        xml.addAttribute("name", this.getName());
        xml.addAttribute("tolerance", this.getTolerance() + "");
        xml.addAttribute("xAxisName", this.getXAxisName());
        xml.addAttribute("yAxisName", this.getYAxisName());
        xml.addAttribute("num", this.getNum() + "");
        Element points = xml.addElement(XML_METADATA_POINTS_NAME);
        for (int i = 0; i < this.getNum(); ++i) {
            Element point = points.addElement(XML_METADATA_POINT_NAME);
            point.addAttribute("x", this.getX(i) + "");
            point.addAttribute("y", this.getY(i) + "");
        }
        return root;
    }

    public static ArbitrarilyDiscretizedFunc fromXMLMetadata(Element funcElem) {
        ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
        String info = funcElem.attributeValue("info");
        String name = funcElem.attributeValue("name");
        String xAxisName = funcElem.attributeValue("xAxisName");
        String yAxisName = funcElem.attributeValue("yAxisName");
        double tolerance = Double.parseDouble(funcElem.attributeValue("tolerance"));
        func.setInfo(info);
        func.setName(name);
        func.setXAxisName(xAxisName);
        func.setYAxisName(yAxisName);
        func.setTolerance(tolerance);
        Element points = funcElem.element(XML_METADATA_POINTS_NAME);
        Iterator it = points.elementIterator();
        while (it.hasNext()) {
            Element point = (Element)it.next();
            double x = Double.parseDouble(point.attributeValue("x"));
            double y = Double.parseDouble(point.attributeValue("y"));
            func.set(x, y);
        }
        return func;
    }

    public static void writeSimpleFuncFile(DiscretizedFuncAPI func, String fileName) throws IOException {
        File outFile = new File(fileName);
        FileWriter fr = new FileWriter(outFile);
        for (int i = 0; i < func.getNum(); ++i) {
            fr.write(func.getX(i) + " " + func.getY(i) + "\n");
        }
        fr.close();
    }

    public static ArbitrarilyDiscretizedFunc loadFuncFromSimpleFile(String fileName) throws FileNotFoundException, IOException {
        ArrayList<String> fileLines = FileUtils.loadFile(fileName);
        ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
        for (int i = 0; i < fileLines.size(); ++i) {
            String dataLine = fileLines.get(i);
            StringTokenizer st = new StringTokenizer(dataLine);
            double x = Double.parseDouble(st.nextToken());
            double y = Double.parseDouble(st.nextToken());
            func.set(x, y);
        }
        return func;
    }
}

