/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.region;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.region.BorderType;
import org.opensha.commons.data.region.GriddedRegion;
import org.opensha.commons.data.region.Region;

public class CaliforniaRegions {
    private CaliforniaRegions() {
    }

    private static LocationList readCoords(String filename) {
        try {
            String s;
            InputStream is = CaliforniaRegions.class.getResourceAsStream("/resources/data/region/" + filename);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            LocationList ll = new LocationList();
            while ((s = br.readLine()) != null) {
                String[] vals = s.trim().split(",");
                double lat = Double.valueOf(vals[0]);
                double lon = Double.valueOf(vals[1]);
                Location loc = new Location(lat, lon);
                ll.addLocation(loc);
            }
            br.close();
            return ll;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final class WG07_GRIDDED
    extends GriddedRegion {
        public WG07_GRIDDED() {
            super(CaliforniaRegions.readCoords("WG07.coords"), BorderType.MERCATOR_LINEAR, 0.1, new Location(34.0, -118.0));
        }
    }

    public static final class WG02_GRIDDED
    extends GriddedRegion {
        public WG02_GRIDDED() {
            super(CaliforniaRegions.readCoords("WG02.coords"), BorderType.MERCATOR_LINEAR, 0.1, ANCHOR_0_0);
        }
    }

    public static final class RELM_SOCAL_GRIDDED
    extends GriddedRegion {
        public RELM_SOCAL_GRIDDED() {
            super(CaliforniaRegions.readCoords("RELM_SoCal.coords"), BorderType.MERCATOR_LINEAR, 0.1, ANCHOR_0_0);
        }
    }

    public static final class RELM_SOCAL
    extends Region {
        public RELM_SOCAL() {
            super(CaliforniaRegions.readCoords("RELM_SoCal.coords"), BorderType.MERCATOR_LINEAR);
        }
    }

    public static final class RELM_NOCAL_GRIDDED
    extends GriddedRegion {
        public RELM_NOCAL_GRIDDED() {
            super(CaliforniaRegions.readCoords("RELM_NoCal.coords"), BorderType.MERCATOR_LINEAR, 0.1, ANCHOR_0_0);
        }
    }

    public static final class RELM_NOCAL
    extends Region {
        public RELM_NOCAL() {
            super(CaliforniaRegions.readCoords("RELM_NoCal.coords"), BorderType.MERCATOR_LINEAR);
        }
    }

    public static final class RELM_COLLECTION_GRIDDED
    extends GriddedRegion {
        public RELM_COLLECTION_GRIDDED() {
            super(CaliforniaRegions.readCoords("RELM_collection.coords"), BorderType.MERCATOR_LINEAR, 0.1, ANCHOR_0_0);
        }
    }

    public static final class RELM_COLLECTION
    extends Region {
        public RELM_COLLECTION() {
            super(CaliforniaRegions.readCoords("RELM_collection.coords"), BorderType.MERCATOR_LINEAR);
        }
    }

    public static final class RELM_TESTING_GRIDDED
    extends GriddedRegion {
        public RELM_TESTING_GRIDDED() {
            this(0.1);
        }

        public RELM_TESTING_GRIDDED(double spacing) {
            super(CaliforniaRegions.readCoords("RELM_testing.coords"), BorderType.MERCATOR_LINEAR, spacing, ANCHOR_0_0);
        }
    }

    public static final class RELM_TESTING
    extends Region {
        public RELM_TESTING() {
            super(CaliforniaRegions.readCoords("RELM_testing.coords"), BorderType.MERCATOR_LINEAR);
        }
    }

    public static final class RELM_GRIDDED
    extends GriddedRegion {
        public RELM_GRIDDED() {
            super(CaliforniaRegions.readCoords("RELM.coords"), BorderType.MERCATOR_LINEAR, 0.1, ANCHOR_0_0);
        }
    }
}

