/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData;

import org.dom4j.Attribute;
import org.dom4j.Element;
import org.opensha.commons.metadata.XMLSaveable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteDataValue<Element>
implements XMLSaveable {
    public static final String XML_METADATA_NAME = "SiteDataValue";
    private String dataType;
    private String dataMeasurementType;
    private Element value;
    private String sourceName = null;

    public SiteDataValue(String dataType, String dataMeasurementType, Element value) {
        this(dataType, dataMeasurementType, value, null);
    }

    public SiteDataValue(String dataType, String dataMeasurementType, Element value, String sourceName) {
        this.dataType = dataType;
        this.dataMeasurementType = dataMeasurementType;
        this.value = value;
        this.sourceName = sourceName;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getDataMeasurementType() {
        return this.dataMeasurementType;
    }

    public Element getValue() {
        return this.value;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String toString() {
        String str = "Type: " + this.dataType + ", Measurement Type: " + this.dataMeasurementType + ", Value: " + this.value;
        if (this.sourceName != null) {
            str = str + ", Source: " + this.sourceName;
        }
        return str;
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element elem = root.addElement(XML_METADATA_NAME);
        elem.addAttribute("type", this.dataType);
        elem.addAttribute("measurementType", this.dataMeasurementType);
        Element valEl = elem.addElement("Value");
        if (this.value instanceof String) {
            valEl.addAttribute("stringValue", this.value.toString());
        } else if (this.value instanceof Double) {
            valEl.addAttribute("doubleValue", this.value.toString());
        } else {
            throw new RuntimeException("Type '" + this.dataType + "' cannot be saved to XML!");
        }
        return root;
    }

    public static SiteDataValue<?> fromXMLMetadata(Element dataElem) {
        Object val;
        String dataType = dataElem.attributeValue("type");
        String measurementType = dataElem.attributeValue("measurementType");
        Element valEl = dataElem.element("Value");
        Attribute strAtt = valEl.attribute("stringValue");
        Attribute doubAtt = valEl.attribute("doubleValue");
        if (strAtt != null) {
            val = strAtt.getValue();
        } else if (doubAtt != null) {
            val = Double.parseDouble(doubAtt.getValue());
        } else {
            throw new RuntimeException("Type '" + dataType + "' unknown, cannot load from XML!");
        }
        return new SiteDataValue<Object>(dataType, measurementType, val);
    }
}

