/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.opensha.commons.calc.ArcsecondConverter;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.region.GriddedRegion;
import org.opensha.commons.data.region.Region;
import org.opensha.commons.data.siteData.AbstractSiteData;
import org.opensha.commons.data.siteData.SiteDataToXYZ;
import org.opensha.commons.data.siteData.servlet.SiteDataServletAccessor;
import org.opensha.commons.exceptions.RegionConstraintException;
import org.opensha.commons.util.binFile.GeolocatedRectangularBinaryMesh2DCalculator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SRTM30TopoSlope
extends AbstractSiteData<Double> {
    public static final String NAME = "SRTM30 Topographic Slope";
    public static final String SHORT_NAME = "SRTM30_Slope";
    public static final double arcSecondSpacing = 30.0;
    public static final double spacing = ArcsecondConverter.getDegrees(30.0);
    public static final int nx = 43200;
    public static final int ny = 18000;
    public static final double minLon = -180.0 + spacing / 2.0;
    public static final double minLat = -60.0 + spacing / 2.0;
    public static final String SERVLET_URL = "http://opensha.usc.edu:8080/OpenSHA_dev/SiteData/SRTM30_Slope";
    private boolean useServlet;
    private Region region;
    private RandomAccessFile file = null;
    private byte[] recordBuffer = null;
    private FloatBuffer floatBuff = null;
    private GeolocatedRectangularBinaryMesh2DCalculator calc = null;
    private SiteDataServletAccessor<Double> servlet = null;

    public SRTM30TopoSlope() throws IOException {
        this(null, true);
    }

    public SRTM30TopoSlope(String fileName) throws IOException {
        this(fileName, false);
    }

    private SRTM30TopoSlope(String fileName, boolean useServlet) throws IOException {
        this.useServlet = useServlet;
        if (useServlet) {
            this.servlet = new SiteDataServletAccessor(SERVLET_URL);
        } else {
            this.file = new RandomAccessFile(new File(fileName), "r");
            this.recordBuffer = new byte[4];
            ByteBuffer record = ByteBuffer.wrap(this.recordBuffer);
            record.order(ByteOrder.LITTLE_ENDIAN);
            this.floatBuff = record.asFloatBuffer();
        }
        this.calc = new GeolocatedRectangularBinaryMesh2DCalculator(3, 43200, 18000, minLat, minLon, spacing);
        this.calc.setStartBottom(true);
        this.calc.setStartLeft(true);
        this.region = new Region(new Location(-60.0, -180.0), new Location(90.0, 180.0));
    }

    @Override
    public Region getApplicableRegion() {
        return this.region;
    }

    @Override
    public Location getClosestDataLocation(Location loc) throws IOException {
        return this.calc.calcClosestLocation(loc);
    }

    @Override
    public String getMetadata() {
        return "Topographic slope derived from version 2 of STRM30 30 Arcsecond DigitalElevation Model.";
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public double getResolution() {
        return spacing;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getDataType() {
        return "Topographic Slope (m/m)";
    }

    @Override
    public String getDataMeasurementType() {
        return "Measured";
    }

    @Override
    public Double getValue(Location loc) throws IOException {
        if (this.useServlet) {
            return this.servlet.getValue(loc);
        }
        long pos = this.calc.calcClosestLocationFileIndex(loc);
        if (pos < 0L || pos > this.calc.getMaxFilePos()) {
            return Double.NaN;
        }
        this.file.seek(pos);
        this.file.read(this.recordBuffer);
        double val = this.floatBuff.get(0);
        return val;
    }

    @Override
    public ArrayList<Double> getValues(LocationList locs) throws IOException {
        if (this.useServlet) {
            return this.servlet.getValues(locs);
        }
        return super.getValues(locs);
    }

    @Override
    public boolean isValueValid(Double val) {
        return val != null && !Double.isNaN(val);
    }

    public static void main(String[] args) throws IOException, RegionConstraintException {
        SRTM30TopoSlope data = new SRTM30TopoSlope();
        System.out.println(data.getValue(new Location(34.0, -118.0)));
        System.out.println(data.getValue(new Location(32.0, -118.0)));
        GriddedRegion region = new GriddedRegion(new Location(32.0, -121.0), new Location(25.0, 115.0), 0.02, new Location(0.0, 0.0));
        SiteDataToXYZ.writeXYZ(data, region, "/tmp/topo_slope.txt");
    }
}

