/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.impl;

import java.io.IOException;
import java.util.ArrayList;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.region.Region;
import org.opensha.commons.data.siteData.AbstractSiteData;
import org.opensha.commons.data.siteData.impl.WillsMap2000;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.sha.util.SiteTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WillsMap2000TranslatedVs30
extends AbstractSiteData<Double> {
    public static final String NAME = "CGS/Wills Preliminary Site Classification Map (2000) - Translated to Vs30";
    public static final String SHORT_NAME = "Wills2000_Vs30";
    WillsMap2000 map;

    public WillsMap2000TranslatedVs30() {
        this(null, true);
    }

    public WillsMap2000TranslatedVs30(String fileName) {
        this(fileName, false);
    }

    private WillsMap2000TranslatedVs30(String fileName, boolean useServlet) {
        this.map = useServlet ? new WillsMap2000(useServlet) : new WillsMap2000(fileName);
        this.initDefaultVS30Params();
        this.paramList.addParameter(this.minVs30Param);
        this.paramList.addParameter(this.maxVs30Param);
    }

    @Override
    public Region getApplicableRegion() {
        return this.map.getApplicableRegion();
    }

    @Override
    public Location getClosestDataLocation(Location loc) throws IOException {
        return this.map.getClosestDataLocation(loc);
    }

    @Override
    public String getMetadata() {
        String meta = this.map.getMetadata();
        meta = meta + "\n\nTranslated to Vs30 values with the following table:\n" + SiteTranslator.getWillsVs30TranslationString();
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public double getResolution() {
        return this.map.getResolution();
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getDataType() {
        return "Vs30";
    }

    @Override
    public String getDataMeasurementType() {
        return this.map.getDataMeasurementType();
    }

    private Double getValueFromWillsClass(String wills) {
        Double val = SiteTranslator.getVS30FromWillsClass(wills);
        return this.certifyMinMaxVs30(val);
    }

    @Override
    public Double getValue(Location loc) throws IOException {
        String wills = this.map.getValue(loc);
        return this.getValueFromWillsClass(wills);
    }

    @Override
    public ArrayList<Double> getValues(LocationList locs) throws IOException {
        ArrayList<String> willsVals = this.map.getValues(locs);
        ArrayList<Double> vsVals = new ArrayList<Double>();
        for (String wills : willsVals) {
            vsVals.add(this.getValueFromWillsClass(wills));
        }
        return vsVals;
    }

    @Override
    public boolean isValueValid(Double val) {
        return val != null && !val.isNaN() && val > 0.0;
    }

    public static void main(String[] args) throws InvalidRangeException, IOException {
        WillsMap2000TranslatedVs30 data = new WillsMap2000TranslatedVs30();
        System.out.println(data.getValue(new Location(34.0, -118.0)));
    }
}

