/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import org.dom4j.Element;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.region.GriddedRegion;
import org.opensha.commons.data.region.Region;
import org.opensha.commons.data.siteData.AbstractSiteData;
import org.opensha.commons.data.siteData.servlet.SiteDataServletAccessor;
import org.opensha.commons.exceptions.RegionConstraintException;
import org.opensha.commons.util.binFile.GeolocatedRectangularBinaryMesh2DCalculator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WillsMap2006
extends AbstractSiteData<Double> {
    public static final int nx = 49867;
    public static final int ny = 44016;
    public static final double spacing = 2.1967246502752E-4;
    public static final double minLon = -124.52997177169;
    public static final double minLat = 32.441345502265;
    public static final String NAME = "CGS/Wills Site Classification Map (2006)";
    public static final String SHORT_NAME = "Wills2006";
    public static final String SERVER_BIN_FILE = "/export/opensha/data/siteData/wills2006.bin";
    public static final String DEBUG_BIN_FILE = "/home/kevin/OpenSHA/siteClass/out.bin";
    public static final String SERVLET_URL = "http://opensha.usc.edu:8080/OpenSHA_dev/SiteData/Wills2006";
    private Region applicableRegion;
    private RandomAccessFile file = null;
    private String fileName = null;
    private byte[] recordBuffer = null;
    private ShortBuffer shortBuff = null;
    private GeolocatedRectangularBinaryMesh2DCalculator calc = null;
    private boolean useServlet;
    private SiteDataServletAccessor<Double> servlet = null;

    public WillsMap2006() throws IOException {
        this(true, null);
    }

    public WillsMap2006(String dataFile) throws IOException {
        this(false, dataFile);
    }

    private WillsMap2006(boolean useServlet, String dataFile) throws IOException {
        this.useServlet = useServlet;
        this.fileName = dataFile;
        this.calc = new GeolocatedRectangularBinaryMesh2DCalculator(0, 49867, 44016, 32.441345502265, -124.52997177169, 2.1967246502752E-4);
        this.calc.setStartBottom(false);
        this.calc.setStartLeft(true);
        this.applicableRegion = this.calc.getApplicableRegion();
        if (useServlet) {
            this.servlet = new SiteDataServletAccessor(SERVLET_URL);
        } else {
            this.file = new RandomAccessFile(new File(dataFile), "r");
            this.recordBuffer = new byte[2];
            ByteBuffer record = ByteBuffer.wrap(this.recordBuffer);
            record.order(ByteOrder.LITTLE_ENDIAN);
            this.shortBuff = record.asShortBuffer();
        }
        this.initDefaultVS30Params();
        this.paramList.addParameter(this.minVs30Param);
        this.paramList.addParameter(this.maxVs30Param);
    }

    @Override
    public Region getApplicableRegion() {
        return this.applicableRegion;
    }

    @Override
    public Location getClosestDataLocation(Location loc) {
        return this.calc.calcClosestLocation(loc);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getMetadata() {
        return "Vs30 values from Wills site classifications as described in:\n\nDeveloping a Map of Geologically Defined Site-Condition Categories for California\nby C. J. Wills and K. B. Clahan\nBulletin of the Seismological Society of America; August 2006; v. 96; no. 4A; p. 1483-1501;\n\nThe dataset contains Vs values translated from Wills site classifications, and was tranferred electronically from Chris Wills to Kevin Milner January, 2009 and subsequently converted to binary data for fast I/O. It has a grid spacing of 2.1967246502752E-4 degrees";
    }

    @Override
    public double getResolution() {
        return 2.1967246502752E-4;
    }

    @Override
    public String getDataType() {
        return "Vs30";
    }

    @Override
    public String getDataMeasurementType() {
        return "Inferred";
    }

    @Override
    public Double getValue(Location loc) throws IOException {
        if (this.useServlet) {
            return this.certifyMinMaxVs30(this.servlet.getValue(loc));
        }
        long pos = this.calc.calcClosestLocationFileIndex(loc);
        if (pos < 0L || pos > this.calc.getMaxFilePos()) {
            return Double.NaN;
        }
        this.file.seek(pos);
        this.file.read(this.recordBuffer);
        short val = this.shortBuff.get(0);
        if (val <= 0) {
            return Double.NaN;
        }
        return this.certifyMinMaxVs30(Double.valueOf(val));
    }

    @Override
    public ArrayList<Double> getValues(LocationList locs) throws IOException {
        if (this.useServlet) {
            ArrayList<Double> vals = this.servlet.getValues(locs);
            for (int i = 0; i < vals.size(); ++i) {
                vals.set(i, this.certifyMinMaxVs30(vals.get(i)));
            }
            return vals;
        }
        return super.getValues(locs);
    }

    @Override
    public boolean isValueValid(Double val) {
        return val != null && !Double.isNaN(val);
    }

    @Override
    protected Element addXMLParameters(Element paramsEl) {
        paramsEl.addAttribute("useServlet", this.useServlet + "");
        paramsEl.addAttribute("fileName", this.fileName);
        return super.addXMLParameters(paramsEl);
    }

    public static WillsMap2006 fromXMLParams(Element paramsElem) throws IOException {
        boolean useServlet = Boolean.parseBoolean(paramsElem.attributeValue("useServlet"));
        String fileName = paramsElem.attributeValue("fileName");
        return new WillsMap2006(useServlet, fileName);
    }

    public static void main(String[] args) throws IOException, RegionConstraintException {
        WillsMap2006 map = new WillsMap2006();
        GriddedRegion region = new GriddedRegion(new Location(37.0, -122.75), new Location(38.5, -121.5), 0.01, new Location(0.0, 0.0));
        LocationList locs = new LocationList();
        locs.addLocation(new Location(34.0192, -118.288));
        locs.addLocation(new Location(34.9192, -118.32));
        locs.addLocation(new Location(34.78192, -118.886));
        locs.addLocation(new Location(34.2192, -118.386));
        locs.addLocation(new Location(34.6192, -118.186));
        ArrayList<Double> vals = map.getValues(locs);
        for (double val : vals) {
            System.out.println(val);
        }
    }
}

