/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.siteData.SiteDataAPI;
import org.opensha.commons.util.ServletPrefs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSiteDataServlet<Element>
extends HttpServlet {
    public static String OP_GET_CLOSEST = "Get Closest Location";
    private SiteDataAPI<Element> data;
    private String debugName;

    public AbstractSiteDataServlet(SiteDataAPI<Element> data) {
        this.data = data;
        this.debugName = data.getShortName() + " servlet";
    }

    public AbstractSiteDataServlet() {
    }

    public void setData(SiteDataAPI<Element> data) {
        this.data = data;
        this.debugName = data.getShortName() + " servlet";
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private Location getLocation(double[] pt) {
        if (pt.length == 2) {
            return new Location(pt[0], pt[1]);
        }
        if (pt.length == 3) {
            return new Location(pt[0], pt[1], pt[2]);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.debug("Handling GET");
        ObjectInputStream in = new ObjectInputStream((InputStream)request.getInputStream());
        ObjectOutputStream out = new ObjectOutputStream((OutputStream)response.getOutputStream());
        try {
            Object obj = in.readObject();
            if (obj instanceof Location) {
                Location loc = (Location)obj;
                Element e = this.data.getValue(loc);
                out.writeObject(e);
            } else if (obj instanceof LocationList) {
                LocationList locs = (LocationList)obj;
                ArrayList<Element> e = this.data.getValues(locs);
                out.writeObject(e);
            } else if (obj instanceof double[]) {
                Location loc = this.getLocation((double[])obj);
                if (loc == null) {
                    this.fail(out, "Invalid location!");
                }
                Element e = this.data.getValue(loc);
                out.writeObject(e);
            } else if (obj instanceof ArrayList) {
                ArrayList pts = (ArrayList)obj;
                LocationList locs = new LocationList();
                for (double[] pt : pts) {
                    Location loc = this.getLocation(pt);
                    if (loc == null) {
                        this.fail(out, "Invalid location!");
                    }
                    locs.addLocation(loc);
                }
                ArrayList<Element> e = this.data.getValues(locs);
                out.writeObject(e);
            } else {
                if (!(obj instanceof String)) {
                    this.fail(out, "You must give either a Location or a LocationList!");
                    return;
                }
                String op = (String)obj;
                if (!op.equals(OP_GET_CLOSEST)) {
                    this.fail(out, "Unknown operation: " + op);
                    return;
                }
                obj = in.readObject();
                if (!(obj instanceof Location)) {
                    this.fail(out, "A location must be given for closest location operation");
                    return;
                }
                Location loc = (Location)obj;
                Location close = this.data.getClosestDataLocation(loc);
                out.writeObject(loc);
            }
            out.flush();
            out.close();
            return;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            this.fail(out, "Servlet Exception: " + e.getMessage());
        }
    }

    protected void fail(ObjectOutputStream out, String message) throws IOException {
        ServletPrefs.fail(out, this.debugName, message);
    }

    protected void debug(String message) {
        ServletPrefs.debug(this.debugName, message);
    }
}

