/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.util;

import java.io.IOException;
import java.util.ArrayList;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.region.GriddedRegion;
import org.opensha.commons.data.siteData.SiteDataAPI;
import org.opensha.commons.data.siteData.impl.SRTM30PlusTopoSlope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeanTopoSlopeCalculator {
    SiteDataAPI<Double> topoSlopeProvider;

    public MeanTopoSlopeCalculator(SiteDataAPI<Double> topoSlopeProvider) {
        if (!topoSlopeProvider.getDataType().equals("Topographic Slope (m/m)")) {
            throw new IllegalArgumentException("The given Site Data provider must be of type 'Topographic Slope'");
        }
        this.topoSlopeProvider = topoSlopeProvider;
    }

    private GriddedRegion createRegionAroundSite(Location loc, double radius, double gridSpacing) {
        return new GriddedRegion(loc, radius, gridSpacing, new Location(0.0, 0.0));
    }

    public double getMeanSlope(Location loc, double radius, double gridSpacing) throws IOException {
        GriddedRegion region = this.createRegionAroundSite(loc, radius, gridSpacing);
        return this.getMeanSlope(region);
    }

    public double getMeanSlope(GriddedRegion region) throws IOException {
        return this.getMeanSlope(region.getNodeList());
    }

    public double getMeanSlope(LocationList locs) throws IOException {
        ArrayList<Double> vals = this.topoSlopeProvider.getValues(locs);
        double tot = 0.0;
        for (double val : vals) {
            tot += val;
        }
        double mean = tot / (double)vals.size();
        return mean;
    }

    public static void main(String[] args) throws IOException {
        SRTM30PlusTopoSlope topoSlopeProvider = new SRTM30PlusTopoSlope();
        MeanTopoSlopeCalculator calc = new MeanTopoSlopeCalculator(topoSlopeProvider);
        System.out.println("34, -118: " + calc.getMeanSlope(new Location(34.0, -118.0), 300.0, 0.1));
    }
}

