/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gridComputing;

import org.dom4j.Element;
import org.opensha.commons.gridComputing.GridJob;
import org.opensha.commons.gridComputing.ResourceProvider;
import org.opensha.commons.gridComputing.StorageHost;
import org.opensha.commons.gridComputing.SubmitHost;
import org.opensha.commons.metadata.XMLSaveable;

public class GridResources
implements XMLSaveable {
    public static final String XML_METADATA_NAME = "GridResources";
    private SubmitHost submitHost;
    private ResourceProvider resourceProvider;
    private StorageHost storageHost;

    public GridResources(SubmitHost submitHost, ResourceProvider resourceProvider, StorageHost storageHost) {
        this.submitHost = submitHost;
        this.resourceProvider = resourceProvider;
        this.storageHost = storageHost;
    }

    public SubmitHost getSubmitHost() {
        return this.submitHost;
    }

    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    public StorageHost getStorageHost() {
        return this.storageHost;
    }

    public Element toXMLMetadata(Element root) {
        Element xml = root.addElement(XML_METADATA_NAME);
        xml = this.submitHost.toXMLMetadata(xml);
        xml = this.resourceProvider.toXMLMetadata(xml);
        xml = this.storageHost.toXMLMetadata(xml);
        return root;
    }

    public static GridResources fromXMLMetadata(Element resourcesElem) {
        SubmitHost submitHost = SubmitHost.fromXMLMetadata(resourcesElem.element("SubmitHost"));
        ResourceProvider resourceProvider = ResourceProvider.fromXMLMetadata(resourcesElem.element("ResourceProvider"));
        StorageHost storageHost = StorageHost.fromXMLMetadata(resourcesElem.element("StorageHost"));
        return new GridResources(submitHost, resourceProvider, storageHost);
    }

    public String toString() {
        String str = "";
        str = str + "Grid Resources\n";
        str = str + GridJob.indentString(this.submitHost.toString()) + "\n";
        str = str + GridJob.indentString(this.resourceProvider.toString()) + "\n";
        str = str + GridJob.indentString(this.storageHost.toString());
        return str;
    }
}

