/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.mapping.gmt;

import java.io.Serializable;
import java.util.ArrayList;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.XYZ_DataSetAPI;
import org.opensha.commons.data.region.Region;
import org.opensha.commons.mapping.gmt.elements.CoastAttributes;
import org.opensha.commons.mapping.gmt.elements.PSXYPolygon;
import org.opensha.commons.mapping.gmt.elements.PSXYSymbol;
import org.opensha.commons.mapping.gmt.elements.PSXYSymbolSet;
import org.opensha.commons.mapping.gmt.elements.TopographicSlopeFile;
import org.opensha.commons.util.cpt.CPT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMT_Map
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Region region;
    private String cptFile = null;
    private CPT cpt = null;
    private boolean rescaleCPT = true;
    private double griddedDataInc;
    private XYZ_DataSetAPI griddedData = null;
    private HighwayFile highwayFile = null;
    public static Region ca_topo_region = new Region(new Location(32.0, -126.0), new Location(43.0, -115.0));
    private TopographicSlopeFile topoResolution = null;
    private CoastAttributes coast = new CoastAttributes();
    private double imageWidth = 6.5;
    private String customLabel = null;
    private Double customScaleMin = null;
    private Double customScaleMax = null;
    private int dpi = 72;
    private boolean useGMTSmoothing = true;
    private boolean logPlot = false;
    private String xyzFileName = "map_data.txt";
    private String psFileName = "map.ps";
    private String pdfFileName = "map.pdf";
    private String pngFileName = "map.png";
    private String jpgFileName = "map.jpg";
    private String gmtScriptFileName = "map_GMT_Script.txt";
    private ArrayList<PSXYSymbol> xySymbols = new ArrayList();
    private ArrayList<PSXYPolygon> xyLines = new ArrayList();
    private PSXYSymbolSet xySymbolSet = null;

    public GMT_Map(Region region, XYZ_DataSetAPI griddedData, double griddedDataInc, String cptFile) {
        this.region = region;
        this.setGriddedData(griddedData, griddedDataInc, cptFile);
    }

    public GMT_Map(Region region, XYZ_DataSetAPI griddedData, double griddedDataInc, CPT cpt) {
        this.region = region;
        this.setGriddedData(griddedData, griddedDataInc, cpt);
    }

    public void setGriddedData(XYZ_DataSetAPI griddedData, double griddedDataInc, String cptFile) {
        this.griddedData = griddedData;
        this.griddedDataInc = griddedDataInc;
        this.cptFile = cptFile;
        this.cpt = null;
    }

    public void setGriddedData(XYZ_DataSetAPI griddedData, double griddedDataInc, CPT cpt) {
        this.griddedData = griddedData;
        this.griddedDataInc = griddedDataInc;
        this.cptFile = null;
        this.cpt = cpt;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public String getCptFile() {
        return this.cptFile;
    }

    public void setCptFile(String cptFile) {
        this.cptFile = cptFile;
    }

    public CPT getCpt() {
        return this.cpt;
    }

    public void setCpt(CPT cpt) {
        this.cpt = cpt;
    }

    public boolean isRescaleCPT() {
        return this.rescaleCPT;
    }

    public void setRescaleCPT(boolean rescaleCPT) {
        this.rescaleCPT = rescaleCPT;
    }

    public double getGriddedDataInc() {
        return this.griddedDataInc;
    }

    public void setGriddedDataInc(double griddedDataInc) {
        this.griddedDataInc = griddedDataInc;
    }

    public XYZ_DataSetAPI getGriddedData() {
        return this.griddedData;
    }

    public void setGriddedData(XYZ_DataSetAPI griddedData) {
        this.griddedData = griddedData;
    }

    public HighwayFile getHighwayFile() {
        return this.highwayFile;
    }

    public void setHighwayFile(HighwayFile highwayFile) {
        this.highwayFile = highwayFile;
    }

    public TopographicSlopeFile getTopoResolution() {
        return this.topoResolution;
    }

    public void setTopoResolution(TopographicSlopeFile topoResolution) {
        this.topoResolution = topoResolution;
    }

    public CoastAttributes getCoast() {
        return this.coast;
    }

    public void setCoast(CoastAttributes coast) {
        this.coast = coast;
    }

    public double getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(double imageWidth) {
        this.imageWidth = imageWidth;
    }

    public String getCustomLabel() {
        return this.customLabel;
    }

    public void setCustomLabel(String customLabel) {
        this.customLabel = customLabel;
    }

    public boolean isCustomScale() {
        return this.customScaleMin != null && this.customScaleMax != null && this.customScaleMin < this.customScaleMax;
    }

    public void clearCustomScale() {
        this.customScaleMin = null;
        this.customScaleMax = null;
    }

    public Double getCustomScaleMin() {
        return this.customScaleMin;
    }

    public void setCustomScaleMin(Double customScaleMin) {
        this.customScaleMin = customScaleMin;
    }

    public Double getCustomScaleMax() {
        return this.customScaleMax;
    }

    public void setCustomScaleMax(Double customScaleMax) {
        this.customScaleMax = customScaleMax;
    }

    public int getDpi() {
        return this.dpi;
    }

    public void setDpi(int dpi) {
        this.dpi = dpi;
    }

    public boolean isUseGMTSmoothing() {
        return this.useGMTSmoothing;
    }

    public void setUseGMTSmoothing(boolean useGMTSmoothing) {
        this.useGMTSmoothing = useGMTSmoothing;
    }

    public boolean isLogPlot() {
        return this.logPlot;
    }

    public void setLogPlot(boolean logPlot) {
        this.logPlot = logPlot;
    }

    public String getXyzFileName() {
        return this.xyzFileName;
    }

    public void setXyzFileName(String xyzFileName) {
        this.xyzFileName = xyzFileName;
    }

    public String getPSFileName() {
        return this.psFileName;
    }

    public void setPSFileName(String psFileName) {
        this.psFileName = psFileName;
    }

    public String getPDFFileName() {
        return this.pdfFileName;
    }

    public void setPDFFileName(String psFileName) {
        this.pdfFileName = this.pdfFileName;
    }

    public String getPNGFileName() {
        return this.pngFileName;
    }

    public void setPNGFileName(String pngFileName) {
        this.pngFileName = pngFileName;
    }

    public String getJPGFileName() {
        return this.jpgFileName;
    }

    public void setJPGFileName(String jpgFileName) {
        this.jpgFileName = jpgFileName;
    }

    public String getGmtScriptFileName() {
        return this.gmtScriptFileName;
    }

    public void setGmtScriptFileName(String gmtScriptFileName) {
        this.gmtScriptFileName = gmtScriptFileName;
    }

    public ArrayList<PSXYSymbol> getSymbols() {
        return this.xySymbols;
    }

    public void setSymbols(ArrayList<PSXYSymbol> xySymbols) {
        this.xySymbols = xySymbols;
    }

    public void addSymbol(PSXYSymbol symbol) {
        this.xySymbols.add(symbol);
    }

    public ArrayList<PSXYPolygon> getPolys() {
        return this.xyLines;
    }

    public void setPolys(ArrayList<PSXYPolygon> xyLines) {
        this.xyLines = xyLines;
    }

    public void addPolys(PSXYPolygon line) {
        this.xyLines.add(line);
    }

    public PSXYSymbolSet getSymbolSet() {
        return this.xySymbolSet;
    }

    public void setSymbolSet(PSXYSymbolSet xySymbolSet) {
        this.xySymbolSet = xySymbolSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HighwayFile {
        ALL("CA All", "ca_hiwys.all.xy"),
        MAIN("CA Main", "ca_hiwys.main.xy"),
        OTHER("CA Other", "ca_hiwys.other.xy");

        private final String name;
        private final String fileName;

        private HighwayFile(String name, String fileName) {
            this.name = name;
            this.fileName = fileName;
        }

        public String fileName() {
            return this.fileName;
        }

        public String description() {
            return this.name;
        }
    }
}

