/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.mapping.gmt.elements;

import java.awt.Color;
import org.opensha.commons.data.DataPoint2D;
import org.opensha.commons.mapping.gmt.elements.PSXYElement;

public class PSXYSymbol
extends PSXYElement {
    private static final long serialVersionUID = 1L;
    private Symbol symbol;
    private double width;
    private DataPoint2D pt;

    public PSXYSymbol() {
    }

    public PSXYSymbol(DataPoint2D pt, Symbol symbol, double width) {
        this.symbol = symbol;
        this.width = width;
        this.pt = pt;
    }

    public PSXYSymbol(DataPoint2D pt, Symbol symbol, double width, double penWidth, Color penColor, Color fillColor) {
        super(penWidth, penColor, fillColor);
        this.symbol = symbol;
        this.width = width;
        this.pt = pt;
    }

    public String getSymbolString() {
        return "-S" + this.symbol.val() + this.width + "i";
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public void setSymbol(Symbol symbol) {
        this.symbol = symbol;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public DataPoint2D getPoint() {
        return this.pt;
    }

    public void setPoint(DataPoint2D pt) {
        this.pt = pt;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Symbol {
        SQUARE("s"),
        DIAMOND("d"),
        CIRCLE("c"),
        STAR("a"),
        OCTAGON("g"),
        HEXAGON("h"),
        INVERTED_TRIANGLE("i"),
        PENTAGON("n"),
        CROSS("x"),
        Y_DASH("y");

        private String val;

        private Symbol(String val) {
            this.val = val;
        }

        public String val() {
            return this.val;
        }
    }
}

