/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param;

import java.util.ArrayList;
import org.dom4j.Element;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.EditableException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.DependentParameter;
import org.opensha.commons.param.DependentParameterAPI;
import org.opensha.commons.param.ParameterAPI;
import org.opensha.commons.param.ParameterConstraintAPI;
import org.opensha.commons.param.StringConstraint;
import org.opensha.commons.param.editor.ConstrainedStringParameterEditor;
import org.opensha.commons.param.editor.ParameterEditor;
import org.opensha.commons.param.editor.StringParameterEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringParameter
extends DependentParameter<String>
implements DependentParameterAPI<String>,
ParameterAPI<String> {
    protected static final String C = "StringParameter";
    protected static final boolean D = false;
    private transient ParameterEditor paramEdit = null;

    public StringParameter(String name) {
        this.name = name;
    }

    public StringParameter(String name, ArrayList strings) throws ConstraintException {
        this(name, new StringConstraint(strings), null, null);
    }

    public StringParameter(String name, StringConstraint constraint) throws ConstraintException {
        this(name, constraint, null, null);
    }

    public StringParameter(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public StringParameter(String name, String units, String value) throws ConstraintException {
        this(name, (StringConstraint)null, units, value);
    }

    public StringParameter(String name, ArrayList strings, String value) throws ConstraintException {
        this(name, new StringConstraint(strings), (String)null, value);
    }

    public StringParameter(String name, StringConstraint constraint, String value) throws ConstraintException {
        this(name, constraint, (String)null, value);
    }

    public StringParameter(String name, StringConstraint constraint, String units, String value) throws ConstraintException {
        super(name, constraint, units, value);
    }

    @Override
    public void setConstraint(ParameterConstraintAPI constraint) throws ParameterException, EditableException {
        String S = "StringParameter: setConstraint(): ";
        this.checkEditable(S);
        if (!(constraint instanceof StringConstraint)) {
            throw new ParameterException(S + "This parameter only accepts StringConstraints, unable to set the constraint.");
        }
        super.setConstraint(constraint);
    }

    @Override
    public String getType() {
        String type = C;
        ParameterConstraintAPI constraint = this.constraint;
        if (constraint != null) {
            type = "Constrained" + type;
        }
        return type;
    }

    public ArrayList getAllowedStrings() {
        return ((StringConstraint)this.constraint).getAllowedStrings();
    }

    @Override
    public int compareTo(Object obj) throws ClassCastException {
        String S = "StringParameter:compareTo(): ";
        if (!(obj instanceof StringParameter)) {
            throw new ClassCastException(S + "Object not a StringParameter, unable to compare");
        }
        StringParameter param = (StringParameter)obj;
        if (this.value == null && param.value == null) {
            return 0;
        }
        boolean result = false;
        String n1 = (String)this.getValue();
        String n2 = (String)param.getValue();
        return n1.compareTo(n2);
    }

    @Override
    public boolean equals(Object obj) throws ClassCastException {
        String S = "StringParameter:equals(): ";
        if (!(obj instanceof StringParameter)) {
            throw new ClassCastException(S + "Object not a StringParameter, unable to compare");
        }
        String otherName = ((StringParameter)obj).getName();
        return this.compareTo(obj) == 0 && this.getName().equals(otherName);
    }

    @Override
    public Object clone() {
        StringConstraint c1 = null;
        if (this.constraint != null) {
            c1 = (StringConstraint)this.constraint.clone();
        }
        StringParameter param = null;
        if (this.value == null) {
            param = new StringParameter(this.name, c1);
            param.setUnits(this.units);
        } else {
            param = new StringParameter(this.name, c1, this.units, ((String)this.value).toString());
        }
        if (param == null) {
            return null;
        }
        param.editable = true;
        param.info = this.info;
        return param;
    }

    @Override
    public boolean setIndividualParamValueFromXML(Element el) {
        String val = el.attributeValue("value");
        if (val.length() == 0) {
            try {
                this.setValue("");
            }
            catch (ConstraintException e) {
                System.err.println("Warning: could not set String Param to empty string from XML");
            }
            catch (ParameterException e) {
                System.err.println("Warning: could not set String Param to empty string from XML");
            }
        } else {
            this.setValue(val);
        }
        return true;
    }

    @Override
    public ParameterEditor getEditor() {
        if (this.paramEdit == null) {
            if (this.constraint == null) {
                try {
                    this.paramEdit = new StringParameterEditor(this);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                this.paramEdit = new ConstrainedStringParameterEditor(this);
            }
        }
        return this.paramEdit;
    }
}

