/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import javax.swing.border.Border;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.WarningException;
import org.opensha.commons.param.DoubleParameter;
import org.opensha.commons.param.ParameterAPI;
import org.opensha.commons.param.editor.NumericTextField;
import org.opensha.commons.param.editor.ParameterEditor;

public class DoubleParameterEditor
extends ParameterEditor {
    protected static final String C = "DoubleParameterEditor";
    protected static final boolean D = false;

    public DoubleParameterEditor() {
    }

    public DoubleParameterEditor(ParameterAPI model) throws Exception {
        super(model);
        String S = "DoubleParameterEditor: Constructor(model): ";
        this.setParameter(model);
    }

    private void verifyModel(ParameterAPI model) throws ConstraintException {
        String S = "DoubleParameterEditor: Constructor(model): ";
        if (model == null) {
            throw new NullPointerException(S + "Input Parameter model cannot be null");
        }
        if (!(model instanceof DoubleParameter)) {
            throw new ConstraintException(S + "Input model parameter must be a DoubleParameter.");
        }
    }

    public void setAsText(String string) throws IllegalArgumentException {
    }

    protected void setWidgetObject(String name, Object obj) {
        String S = "DoubleParameterEditor: setWidgetObject(): ";
        super.setWidgetObject(name, obj);
        if (obj != null && this.valueEditor != null) {
            ((NumericTextField)this.valueEditor).setText(obj.toString());
        }
    }

    public void setWidgetBorder(Border b) {
        ((NumericTextField)this.valueEditor).setBorder(b);
    }

    protected void addWidget() {
        String S = "DoubleParameterEditorDoubleParameterEditor: addWidget(): ";
        this.valueEditor = new NumericTextField();
        this.valueEditor.setMinimumSize(LABEL_DIM);
        this.valueEditor.setPreferredSize(LABEL_DIM);
        this.valueEditor.setBorder(ETCHED);
        this.valueEditor.setFont(DEFAULT_FONT);
        this.valueEditor.addFocusListener(this);
        this.valueEditor.addKeyListener(this);
        this.widgetPanel.add((Component)this.valueEditor, ParameterEditor.WIDGET_GBC);
    }

    public void keyTyped(KeyEvent e) throws NumberFormatException {
        String S = "DoubleParameterEditor: keyTyped(): ";
        super.keyTyped(e);
        this.keyTypeProcessing = false;
        if (this.focusLostProcessing) {
            return;
        }
        if (e.getKeyChar() == '\n') {
            this.keyTypeProcessing = true;
            String value = ((NumericTextField)this.valueEditor).getText();
            try {
                Double d = null;
                if (!value.equals("")) {
                    d = new Double(value);
                }
                this.setValue(d);
                this.refreshParamEditor();
                this.valueEditor.validate();
                this.valueEditor.repaint();
            }
            catch (ConstraintException ee) {
                Object obj = this.getValue();
                if (obj != null) {
                    ((NumericTextField)this.valueEditor).setText(obj.toString());
                } else {
                    ((NumericTextField)this.valueEditor).setText("");
                }
                if (!this.catchConstraint) {
                    this.unableToSetValue(value);
                }
                this.keyTypeProcessing = false;
            }
            catch (NumberFormatException ee) {
                Object obj = this.getValue();
                if (obj != null) {
                    ((NumericTextField)this.valueEditor).setText(obj.toString());
                } else {
                    ((NumericTextField)this.valueEditor).setText("");
                }
                if (!this.catchConstraint) {
                    this.unableToSetValue(value);
                }
                this.keyTypeProcessing = false;
            }
            catch (WarningException ee) {
                this.keyTypeProcessing = false;
                this.refreshParamEditor();
                this.valueEditor.validate();
                this.valueEditor.repaint();
            }
        }
        this.keyTypeProcessing = false;
    }

    public void focusLost(FocusEvent e) throws ConstraintException {
        String S = "DoubleParameterEditor: focusLost(): ";
        this.focusLostProcessing = false;
        if (this.keyTypeProcessing) {
            return;
        }
        this.focusLostProcessing = true;
        String value = ((NumericTextField)this.valueEditor).getText();
        try {
            Double d = null;
            if (!value.equals("")) {
                d = new Double(value);
            }
            this.setValue(d);
            this.refreshParamEditor();
            this.valueEditor.validate();
            this.valueEditor.repaint();
        }
        catch (ConstraintException ee) {
            Object obj = this.getValue();
            if (obj != null) {
                ((NumericTextField)this.valueEditor).setText(obj.toString());
            } else {
                ((NumericTextField)this.valueEditor).setText("");
            }
            if (!this.catchConstraint) {
                this.unableToSetValue(value);
            }
            this.focusLostProcessing = false;
        }
        catch (NumberFormatException ee) {
            Object obj = this.getValue();
            if (obj != null) {
                ((NumericTextField)this.valueEditor).setText(obj.toString());
            } else {
                ((NumericTextField)this.valueEditor).setText("");
            }
            if (!this.catchConstraint) {
                this.unableToSetValue(value);
            }
            this.keyTypeProcessing = false;
        }
        catch (WarningException ee) {
            this.focusLostProcessing = false;
            this.refreshParamEditor();
            this.valueEditor.validate();
            this.valueEditor.repaint();
        }
        this.focusLostProcessing = false;
    }

    public void setParameter(ParameterAPI model) {
        String S = "DoubleParameterEditor: setParameter(): ";
        super.setParameter(model);
        ((NumericTextField)this.valueEditor).setToolTipText("No Constraints");
        String info = model.getInfo();
        if (info != null && !info.equals("")) {
            this.nameLabel.setToolTipText(info);
        } else {
            this.nameLabel.setToolTipText(null);
        }
    }

    public void refreshParamEditor() {
        Object obj = this.model.getValue();
        if (obj != null) {
            ((NumericTextField)this.valueEditor).setText(obj.toString());
        } else {
            ((NumericTextField)this.valueEditor).setText("");
        }
    }
}

