/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import javax.swing.border.Border;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.WarningException;
import org.opensha.commons.param.IntegerParameter;
import org.opensha.commons.param.ParameterAPI;
import org.opensha.commons.param.editor.IntegerTextField;
import org.opensha.commons.param.editor.ParameterEditor;

public class IntegerParameterEditor
extends ParameterEditor {
    protected static final String C = "IntegerParameterEditor";
    protected static final boolean D = false;

    public IntegerParameterEditor() {
    }

    public IntegerParameterEditor(ParameterAPI model) throws Exception {
        super(model);
        String S = "IntegerParameterEditor: Constructor(model): ";
        if (model != null && !(model instanceof IntegerParameter)) {
            throw new Exception(S + "Input model parameter must be a IntegerParameter.");
        }
        this.updateNameLabel(model.getName());
        this.setParameter(model);
    }

    public void setAsText(String string) throws IllegalArgumentException {
    }

    protected void setWidgetObject(String name, Object obj) {
        String S = "IntegerParameterEditor: setWidgetObject(): ";
        super.setWidgetObject(name, obj);
        if (obj != null && this.valueEditor != null) {
            ((IntegerTextField)this.valueEditor).setText(obj.toString());
        } else if (this.valueEditor != null) {
            ((IntegerTextField)this.valueEditor).setText(" ");
        }
    }

    public void setWidgetBorder(Border b) {
        ((IntegerTextField)this.valueEditor).setBorder(b);
    }

    protected void addWidget() {
        String S = "IntegerParameterEditor: addWidget(): ";
        this.valueEditor = new IntegerTextField();
        this.valueEditor.setMinimumSize(LABEL_DIM);
        this.valueEditor.setPreferredSize(LABEL_DIM);
        this.valueEditor.setBorder(ETCHED);
        this.valueEditor.setFont(DEFAULT_FONT);
        this.valueEditor.addFocusListener(this);
        this.valueEditor.addKeyListener(this);
        this.widgetPanel.add((Component)this.valueEditor, ParameterEditor.WIDGET_GBC);
        this.widgetPanel.setBackground(null);
        this.widgetPanel.validate();
        this.widgetPanel.repaint();
    }

    public void keyTyped(KeyEvent e) throws NumberFormatException {
        String S = "IntegerParameterEditor: valueEditor_keyTyped(): ";
        super.keyTyped(e);
        this.keyTypeProcessing = false;
        if (this.focusLostProcessing) {
            return;
        }
        if (e.getKeyChar() == '\n') {
            this.keyTypeProcessing = true;
            String value = ((IntegerTextField)this.valueEditor).getText();
            try {
                Integer d = null;
                if (!value.trim().equals("")) {
                    d = new Integer(value);
                }
                this.setValue(d);
                this.refreshParamEditor();
                this.valueEditor.validate();
                this.valueEditor.repaint();
            }
            catch (ConstraintException ee) {
                Object obj = this.getValue();
                if (obj != null) {
                    ((IntegerTextField)this.valueEditor).setText(obj.toString());
                } else {
                    ((IntegerTextField)this.valueEditor).setText(" ");
                }
                if (!this.catchConstraint) {
                    this.unableToSetValue(value);
                }
                this.keyTypeProcessing = false;
            }
            catch (WarningException ee) {
                this.keyTypeProcessing = false;
                this.refreshParamEditor();
                this.valueEditor.validate();
                this.valueEditor.repaint();
            }
        }
    }

    public void focusLost(FocusEvent e) throws ConstraintException {
        String S = "IntegerParameterEditor: focusLost(): ";
        super.focusLost(e);
        this.focusLostProcessing = false;
        if (this.keyTypeProcessing) {
            return;
        }
        this.focusLostProcessing = true;
        String value = ((IntegerTextField)this.valueEditor).getText();
        try {
            Integer d = null;
            if (!value.trim().equals("")) {
                d = new Integer(value);
            }
            this.setValue(d);
            this.refreshParamEditor();
            this.valueEditor.validate();
            this.valueEditor.repaint();
        }
        catch (ConstraintException ee) {
            Object obj = this.getValue();
            if (obj != null) {
                ((IntegerTextField)this.valueEditor).setText(obj.toString());
            } else {
                ((IntegerTextField)this.valueEditor).setText(" ");
            }
            if (!this.catchConstraint) {
                this.unableToSetValue(value);
            }
            this.focusLostProcessing = false;
        }
        catch (WarningException ee) {
            this.focusLostProcessing = false;
            this.refreshParamEditor();
            this.valueEditor.validate();
            this.valueEditor.repaint();
        }
        this.focusLostProcessing = false;
    }

    public void setParameter(ParameterAPI model) {
        String S = "IntegerParameterEditor: setParameter(): ";
        super.setParameter(model);
        ((IntegerTextField)this.valueEditor).setToolTipText("No Constraints");
        String info = model.getInfo();
        if (info != null && !info.equals("")) {
            this.nameLabel.setToolTipText(info);
        } else {
            this.nameLabel.setToolTipText(null);
        }
    }

    public void refreshParamEditor() {
        Object obj = this.model.getValue();
        if (obj != null) {
            ((IntegerTextField)this.valueEditor).setText(obj.toString());
        } else {
            ((IntegerTextField)this.valueEditor).setText(" ");
        }
    }
}

