/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util;

import java.util.ArrayList;
import org.opensha.commons.calc.RelativeLocation;
import org.opensha.commons.data.Direction;
import org.opensha.commons.data.Location;
import org.opensha.sha.faultSurface.FaultTrace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaultTraceUtils {
    public static ArrayList<FaultTrace> getEqualLengthSubsectionTraces(FaultTrace faultTrace, double maxSubSectionLen) {
        double numSubSec = faultTrace.getTraceLength() / maxSubSectionLen;
        int numSubSections = Math.floor(numSubSec) != numSubSec ? (int)Math.floor(numSubSec) + 1 : (int)numSubSec;
        double subSecLength = faultTrace.getTraceLength() / (double)numSubSections;
        double distance = 0.0;
        double distLocs = 0.0;
        int numLocs = faultTrace.getNumLocations();
        int index = 0;
        ArrayList<FaultTrace> subSectionTraceList = new ArrayList<FaultTrace>();
        Location prevLoc = faultTrace.getLocationAt(index);
        block0: while (index < numLocs && subSectionTraceList.size() < numSubSections) {
            FaultTrace subSectionTrace = new FaultTrace(faultTrace.getName() + " " + (subSectionTraceList.size() + 1));
            subSectionTraceList.add(subSectionTrace);
            subSectionTrace.addLocation(prevLoc);
            ++index;
            distance = 0.0;
            while (index < faultTrace.getNumLocations()) {
                Location nextLoc = faultTrace.getLocationAt(index);
                distLocs = RelativeLocation.getApproxHorzDistance(prevLoc, nextLoc);
                if ((distance += distLocs) < subSecLength) {
                    prevLoc = nextLoc;
                    subSectionTrace.addLocation(prevLoc);
                    ++index;
                    continue;
                }
                Direction direction = RelativeLocation.getDirection(prevLoc, nextLoc);
                direction.setHorzDistance(subSecLength - (distance - distLocs));
                prevLoc = RelativeLocation.getLocation(prevLoc, direction);
                subSectionTrace.addLocation(prevLoc);
                --index;
                continue block0;
            }
        }
        return subSectionTraceList;
    }

    public static FaultTrace resampleTrace(FaultTrace trace, int num) {
        double resampInt = trace.getTraceLength() / (double)num;
        FaultTrace resampTrace = new FaultTrace("resampled " + trace.getName());
        resampTrace.addLocation(trace.getLocationAt(0));
        double remainingLength = resampInt;
        Location lastLoc = trace.getLocationAt(0);
        int NextLocIndex = 1;
        while (NextLocIndex < trace.size()) {
            Location nextLoc = trace.getLocationAt(NextLocIndex);
            double length = RelativeLocation.getTotalDistance(lastLoc, nextLoc);
            if (length > remainingLength) {
                Direction dir = RelativeLocation.getDirection(lastLoc, nextLoc);
                dir.setHorzDistance(dir.getHorzDistance() * remainingLength / length);
                dir.setVertDistance(dir.getVertDistance() * remainingLength / length);
                Location loc = RelativeLocation.getLocation(lastLoc, dir);
                resampTrace.addLocation(loc);
                lastLoc = loc;
                remainingLength = resampInt;
                continue;
            }
            lastLoc = nextLoc;
            ++NextLocIndex;
            remainingLength -= length;
        }
        double dist = RelativeLocation.getTotalDistance(trace.getLocationAt(trace.size() - 1), resampTrace.getLocationAt(resampTrace.size() - 1));
        if (dist > resampInt / 2.0) {
            resampTrace.addLocation(trace.getLocationAt(trace.size() - 1));
        }
        return resampTrace;
    }

    public static void plotTraces(ArrayList<FaultTrace> traces) {
        throw new RuntimeException("This doesn't work because our functions will reorder x-axis values to monotonically increase (and remove duplicates - someone should fix this)");
    }
}

