/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util;

import org.opensha.commons.exceptions.InvalidRangeException;

public final class FaultUtils {
    protected static final String C = "FaultUtils";
    protected static final boolean D = false;
    private static final String S1 = "FaultUtils: assertValidStrike(): ";
    private static final String S2 = "FaultUtils: assertValidDip(): ";
    private static final String S3 = "FaultUtils: assertValidRake(): ";

    public static void assertValidStrike(double strike) throws InvalidRangeException {
        if (strike < 0.0) {
            throw new InvalidRangeException("FaultUtils: assertValidStrike(): Strike angle cannot be less than zero (value = " + strike + ")");
        }
        if (strike > 360.0) {
            throw new InvalidRangeException("FaultUtils: assertValidStrike(): Strike angle cannot be greater than 360 (value = " + strike + ")");
        }
    }

    public static void assertValidDip(double dip) throws InvalidRangeException {
        if (dip < 0.0) {
            throw new InvalidRangeException("FaultUtils: assertValidDip(): Dip angle cannot be less than zero; the value is " + dip);
        }
        if (dip > 90.0) {
            throw new InvalidRangeException("FaultUtils: assertValidDip(): Dip angle cannot be greater than 90; the value is " + dip);
        }
    }

    public static void assertValidDepth(double depth) throws InvalidRangeException {
        if (!(depth >= 0.0)) {
            throw new InvalidRangeException("FaultUtils: assertValidDip(): Depth on fault must be positive");
        }
    }

    public static void assertValidSeisUpperAndLower(double upperSeis, double lowerSeis) throws InvalidRangeException {
        FaultUtils.assertValidDepth(upperSeis);
        FaultUtils.assertValidDepth(lowerSeis);
        if (upperSeis > lowerSeis) {
            throw new InvalidRangeException("FaultUtils: assertValidDip(): upperSeisDepth must be < lowerSeisDepth");
        }
    }

    public static void assertValidRake(double rake) throws InvalidRangeException {
        if (rake < -180.0) {
            throw new InvalidRangeException("FaultUtils: assertValidRake(): Rake angle cannot be less than -180");
        }
        if (rake > 180.0) {
            throw new InvalidRangeException("FaultUtils: assertValidRake(): Rake angle cannot be greater than 180");
        }
    }
}

