/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util.binFile;

public class BinaryMesh2DCalculator {
    public static final int FAST_XY = 0;
    public static final int FAST_YX = 1;
    public static final int TYPE_SHORT = 0;
    public static final int TYPE_INT = 1;
    public static final int TYPE_LONG = 2;
    public static final int TYPE_FLOAT = 3;
    public static final int TYPE_DOUBLE = 4;
    protected long nx;
    protected long ny;
    private int numType;
    private long maxFilePos;
    private int meshOrder = 0;
    private int numBytesPerPoint;

    public BinaryMesh2DCalculator(int numType, long nx, long ny) {
        if (numType == 0) {
            this.numBytesPerPoint = 2;
        } else if (numType == 1 || numType == 3) {
            this.numBytesPerPoint = 4;
        } else if (numType == 2 || numType == 4) {
            this.numBytesPerPoint = 8;
        }
        this.nx = nx;
        this.ny = ny;
        this.maxFilePos = this.calcMaxFilePos();
        this.numType = numType;
    }

    public long calcMeshIndex(long x, long y) {
        if (this.meshOrder == 0) {
            return this.nx * y + x;
        }
        return this.ny * x + y;
    }

    public long calcFileIndex(long x, long y) {
        return (long)this.numBytesPerPoint * this.calcMeshIndex(x, y);
    }

    public long getNX() {
        return this.nx;
    }

    public void setNX(int nx) {
        this.nx = nx;
        this.maxFilePos = this.calcMaxFilePos();
    }

    public long getNY() {
        return this.ny;
    }

    public void setNY(int ny) {
        this.ny = ny;
        this.maxFilePos = this.calcMaxFilePos();
    }

    public long getMaxFilePos() {
        return this.maxFilePos;
    }

    private long calcMaxFilePos() {
        return (this.nx - 1L) * (this.ny - 1L) * (long)this.numBytesPerPoint;
    }

    public int getMeshOrder() {
        return this.meshOrder;
    }

    public void setMeshOrder(int meshOrder) {
        this.meshOrder = meshOrder;
    }

    public int getType() {
        return this.numType;
    }
}

