/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util.binFile;

import org.opensha.commons.data.Location;
import org.opensha.commons.data.region.Region;
import org.opensha.commons.util.binFile.BinaryMesh2DCalculator;

public class GeolocatedRectangularBinaryMesh2DCalculator
extends BinaryMesh2DCalculator {
    public static final boolean D = false;
    private double minLat;
    private double maxLat;
    private double minLon;
    private double maxLon;
    private double gridSpacing;
    private boolean startBottom = true;
    private boolean startLeft = true;
    private boolean wrapX = false;
    private boolean wrapY = false;
    private boolean allLonPos = false;

    public GeolocatedRectangularBinaryMesh2DCalculator(int numType, int nx, int ny, double minLat, double minLon, double gridSpacing) {
        super(numType, nx, ny);
        this.minLat = minLat;
        this.minLon = minLon;
        this.maxLat = minLat + gridSpacing * (double)(ny - 1);
        this.maxLon = minLon + gridSpacing * (double)(nx - 1);
        this.gridSpacing = gridSpacing;
        if (minLon >= 0.0) {
            this.allLonPos = true;
        }
        if (minLat + 180.0 == this.maxLat + gridSpacing) {
            this.wrapY = true;
        }
        if (minLon + 360.0 == this.maxLon + gridSpacing) {
            this.wrapX = true;
        }
    }

    public long[] calcClosestLocationIndices(Location loc) {
        return this.calcClosestLocationIndices(loc.getLatitude(), loc.getLongitude());
    }

    public long[] calcClosestLocationIndices(double lat, double lon) {
        long x = this.calcX(lon);
        long y = this.calcY(lat);
        if (x < 0L || y < 0L) {
            return null;
        }
        if (x >= this.nx) {
            if (this.wrapX) {
                x %= this.nx;
            } else {
                return null;
            }
        }
        if (y >= this.ny) {
            if (this.wrapY) {
                y %= this.ny;
            } else {
                return null;
            }
        }
        long[] pt = new long[]{x, y};
        return pt;
    }

    public long calcClosestLocationIndex(Location loc) {
        return this.calcClosestLocationIndex(loc.getLatitude(), loc.getLongitude());
    }

    public long calcClosestLocationIndex(double lat, double lon) {
        long[] pt = this.calcClosestLocationIndices(lat, lon);
        if (pt == null) {
            return -1L;
        }
        return this.calcMeshIndex(pt[0], pt[1]);
    }

    public long calcClosestLocationFileIndex(Location loc) {
        return this.calcClosestLocationFileIndex(loc.getLatitude(), loc.getLongitude());
    }

    public long calcClosestLocationFileIndex(double lat, double lon) {
        long[] pt = this.calcClosestLocationIndices(lat, lon);
        if (pt == null) {
            return -1L;
        }
        return this.calcFileIndex(pt[0], pt[1]);
    }

    public Location getLocationForPoint(long x, long y) {
        double lat = this.maxLat - (double)y * this.gridSpacing;
        double lon = this.minLon + (double)x * this.gridSpacing;
        return new Location(lat, lon);
    }

    public Location calcClosestLocation(Location loc) {
        return this.calcClosestLocation(loc.getLatitude(), loc.getLongitude());
    }

    public Location calcClosestLocation(double lat, double lon) {
        long[] pt = this.calcClosestLocationIndices(lat, lon);
        if (pt == null) {
            return null;
        }
        return this.getLocationForPoint(pt[0], pt[1]);
    }

    private long calcX(double lon) {
        if (this.allLonPos && lon < 0.0) {
            lon += 360.0;
        }
        if (this.startLeft) {
            return (long)((lon - this.minLon) / this.gridSpacing + 0.5);
        }
        return (long)((this.maxLon - lon) / this.gridSpacing + 0.5);
    }

    private long calcY(double lat) {
        if (this.startBottom) {
            return (long)((lat - this.minLat) / this.gridSpacing + 0.5);
        }
        return (long)((this.maxLat - lat) / this.gridSpacing + 0.5);
    }

    public double getMinLat() {
        return this.minLat;
    }

    public double getMaxLat() {
        return this.maxLat;
    }

    public double getMinLon() {
        return this.minLon;
    }

    public double getMaxLon() {
        return this.maxLon;
    }

    public double getGridSpacing() {
        return this.gridSpacing;
    }

    public boolean isStartBottom() {
        return this.startBottom;
    }

    public void setStartBottom(boolean startBottom) {
        this.startBottom = startBottom;
    }

    public boolean isStartLeft() {
        return this.startLeft;
    }

    public void setStartLeft(boolean startLeft) {
        this.startLeft = startLeft;
    }

    public Region getApplicableRegion() {
        return new Region(new Location(this.minLat, this.minLon), new Location(this.maxLat, this.maxLon));
    }
}

