/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util.cpt;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.dom4j.Element;
import org.opensha.commons.util.cpt.Blender;
import org.opensha.commons.util.cpt.CPTVal;
import org.opensha.commons.util.cpt.LinearBlender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CPT
extends ArrayList<CPTVal> {
    private static final long serialVersionUID = 1L;
    private Color nanColor = Color.BLACK;
    private Color belowMinColor;
    private Color aboveMaxColor;
    private Color gapColor = Color.BLACK;
    public Blender blender;

    public CPT() {
        this.belowMinColor = Color.BLACK;
        this.aboveMaxColor = Color.BLACK;
        this.blender = new LinearBlender();
    }

    public void setNanColor(int r, int g, int b) {
        this.nanColor = new Color(r, g, b);
    }

    public void setNanColor(Color color) {
        this.nanColor = color;
    }

    public void setBelowMinColor(Color color) {
        this.belowMinColor = color;
    }

    public void setAboveMaxColor(Color color) {
        this.aboveMaxColor = color;
    }

    public void setGapColor(Color color) {
        this.gapColor = color;
    }

    public void setGapColor(int r, int g, int b) {
        this.gapColor = new Color(r, g, b);
    }

    public void setBelowMinColor(int r, int g, int b) {
        this.belowMinColor = new Color(r, g, b);
    }

    public void setAboveMaxColor(int r, int g, int b) {
        this.aboveMaxColor = new Color(r, g, b);
    }

    public Color getAboveMaxColor() {
        return this.aboveMaxColor;
    }

    public Color getBelowMinColor() {
        return this.belowMinColor;
    }

    public Color getMinColor() {
        if (this.size() > 0) {
            return ((CPTVal)this.get((int)0)).minColor;
        }
        return null;
    }

    public Color getMaxColor() {
        if (this.size() > 0) {
            return ((CPTVal)this.get((int)(this.size() - 1))).maxColor;
        }
        return null;
    }

    public Color getNaNColor() {
        return this.nanColor;
    }

    public Color getGapColor() {
        return this.gapColor;
    }

    public Color getColor(float value) {
        CPTVal cpt_val = this.getCPTVal(value);
        if (cpt_val != null) {
            if (value == cpt_val.start) {
                return cpt_val.minColor;
            }
            if (value == cpt_val.end) {
                return cpt_val.maxColor;
            }
            if (value > cpt_val.start && value < cpt_val.end) {
                float adjVal = (value - cpt_val.start) / (cpt_val.end - cpt_val.start);
                return this.blendColors(cpt_val.minColor, cpt_val.maxColor, adjVal);
            }
        }
        if (value < ((CPTVal)this.get((int)0)).start) {
            return this.getBelowMinColor();
        }
        if (value > ((CPTVal)this.get((int)(this.size() - 1))).end) {
            return this.getAboveMaxColor();
        }
        if (value == Float.NaN) {
            return this.nanColor;
        }
        return this.gapColor;
    }

    private Color blendColors(Color smallColor, Color bigColor, float bias) {
        return this.blender.blend(smallColor, bigColor, bias);
    }

    public static CPT loadFromFile(File dataFile) throws FileNotFoundException, IOException {
        BufferedReader in = new BufferedReader(new FileReader(dataFile));
        return CPT.loadFromBufferedReader(in);
    }

    public static CPT loadFromStream(InputStream is) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        return CPT.loadFromBufferedReader(in);
    }

    private static Color loadColor(StringTokenizer tok) {
        int R = Integer.parseInt(tok.nextToken());
        int G = Integer.parseInt(tok.nextToken());
        int B = Integer.parseInt(tok.nextToken());
        return new Color(R, G, B);
    }

    private static CPT loadFromBufferedReader(BufferedReader in) throws IOException {
        CPT cpt = new CPT();
        int lineNumber = 0;
        boolean hasMin = false;
        boolean hasMax = false;
        block8: while (in.ready()) {
            ++lineNumber;
            String line = in.readLine().trim();
            if (line.length() == 0) continue;
            StringTokenizer tok = new StringTokenizer(line);
            int tokens = tok.countTokens();
            char firstChar = line.charAt(0);
            try {
                switch (firstChar) {
                    case '#': {
                        continue block8;
                    }
                    case 'N': {
                        tok.nextToken();
                        cpt.setNanColor(CPT.loadColor(tok));
                        continue block8;
                    }
                    case 'B': {
                        tok.nextToken();
                        cpt.setBelowMinColor(CPT.loadColor(tok));
                        hasMin = true;
                        continue block8;
                    }
                    case 'F': {
                        tok.nextToken();
                        cpt.setAboveMaxColor(CPT.loadColor(tok));
                        hasMax = true;
                        continue block8;
                    }
                }
                if (tokens < 8) {
                    System.out.println("Skipping line: " + lineNumber + "! (Comment or not properly formatted.): " + line);
                    continue;
                }
                float start = Float.parseFloat(tok.nextToken());
                Color minColor = CPT.loadColor(tok);
                float end = Float.parseFloat(tok.nextToken());
                Color maxColor = CPT.loadColor(tok);
                CPTVal cpt_val = new CPTVal(start, minColor, end, maxColor);
                cpt.add(cpt_val);
            }
            catch (NumberFormatException e1) {
                System.out.println("Skipping line: " + lineNumber + "! (bad number parse): " + line);
                continue;
            }
            if (tokens >= 8 && line.charAt(0) != '#') continue;
            System.out.println("Skipping line: " + lineNumber + "! (Comment or not properly formatted.): " + line);
        }
        if (!hasMin) {
            cpt.setBelowMinColor(cpt.getMinColor());
        }
        if (!hasMax) {
            cpt.setAboveMaxColor(cpt.getMaxColor());
        }
        return cpt;
    }

    public static CPT fromXML(Element cptElement) {
        CPT cpt = new CPT();
        Element cptValues = cptElement.element("cptValues");
        List cptVals = cptValues.elements("cptVal");
        for (Element cptValElem : cptVals) {
            CPTVal cptVal = CPTVal.fromXML(cptValElem);
            cpt.add(cptVal);
        }
        Element nanColorElem = cptElement.element("nanColor");
        int R = Integer.parseInt(nanColorElem.attributeValue("r"));
        int G = Integer.parseInt(nanColorElem.attributeValue("g"));
        int B = Integer.parseInt(nanColorElem.attributeValue("b"));
        cpt.setNanColor(R, G, B);
        cpt.setBelowMinColor(cpt.getMinColor());
        cpt.setAboveMaxColor(cpt.getMaxColor());
        return cpt;
    }

    public Element toXML(Element cptElement) {
        Element cptValues = cptElement.addElement("cptValues");
        for (int i = 0; i < this.size(); ++i) {
            Element cptVal = cptValues.addElement("cptVal");
            cptVal = ((CPTVal)this.get(i)).toXML(cptVal);
        }
        Element nanColorElem = cptElement.addElement("nanColor");
        nanColorElem.addAttribute("r", Integer.valueOf(Math.round((float)this.nanColor.getRed() * 255.0f)).toString());
        nanColorElem.addAttribute("g", Integer.valueOf(Math.round((float)this.nanColor.getGreen() * 255.0f)).toString());
        nanColorElem.addAttribute("b", Integer.valueOf(Math.round((float)this.nanColor.getBlue() * 255.0f)).toString());
        return cptElement;
    }

    private String getCPTValStr(CPTVal val) {
        return val.start + "\t" + val.minColor.getRed() + "\t" + val.minColor + "";
    }

    public void writeCPTFile(String fileName) throws IOException {
        FileWriter fw = new FileWriter(fileName);
        fw.write(this.toString());
        fw.close();
    }

    public Blender getBlender() {
        return this.blender;
    }

    public void setBlender(Blender blender) {
        this.blender = blender;
    }

    public CPTVal getCPTVal(float value) {
        for (CPTVal val : this) {
            if (!val.contains(value)) continue;
            return val;
        }
        return null;
    }

    public void setCPTVal(CPTVal newcpt) {
        if (this.size() == 0) {
            this.add(newcpt);
        } else if (newcpt.compareTo((CPTVal)this.get(0)) < 0) {
            this.add(0, newcpt);
        } else if (newcpt.compareTo((CPTVal)this.get(this.size() - 1)) > 0) {
            this.add(newcpt);
        } else {
            boolean added = false;
            ListIterator<CPTVal> iter = this.listIterator();
            while (iter.hasNext()) {
                CPTVal cur = (CPTVal)iter.next();
                if (newcpt.start <= cur.start && cur.end <= newcpt.end) {
                    iter.remove();
                    if (added) continue;
                    iter.add(newcpt);
                    added = true;
                    continue;
                }
                if (newcpt.start <= cur.end && cur.end <= newcpt.end) {
                    cur.end = newcpt.start;
                    if (cur.start == cur.end) {
                        iter.remove();
                    }
                    iter.add(newcpt);
                    added = true;
                    continue;
                }
                if (newcpt.start <= cur.start && cur.start <= newcpt.end) {
                    cur.start = newcpt.end;
                    if (cur.start == cur.end) {
                        iter.remove();
                    }
                    if (!added) {
                        iter.add(newcpt);
                        added = true;
                    }
                    return;
                }
                if (!(cur.start <= newcpt.start) || !(newcpt.end <= cur.end)) continue;
                CPTVal newcur = new CPTVal(newcpt.end, newcpt.maxColor, cur.end, cur.maxColor);
                cur.end = newcpt.start;
                if (cur.end == cur.start) {
                    iter.remove();
                }
                if (newcur.start != newcur.end) {
                    iter.add(newcur);
                }
                iter.add(newcpt);
                return;
            }
        }
    }

    public void paintGrid(BufferedImage bi) {
        int width = bi.getWidth();
        int height = bi.getHeight();
        Graphics2D g = bi.createGraphics();
        Color color = this.getGapColor();
        g.setColor(color);
        g.fillRect(0, 0, width, height);
        if (this.size() > 0) {
            float minStart = ((CPTVal)this.get((int)0)).start;
            float maxEnd = ((CPTVal)this.get((int)(this.size() - 1))).end;
            float valsPerPixel = (maxEnd - minStart) / (float)width;
            int pixel = 0;
            float val = 0.0f;
            for (CPTVal cptval : this) {
                float start = cptval.start;
                float end = cptval.end;
                Color startC = cptval.minColor;
                Color endC = cptval.maxColor;
                val = (float)pixel * valsPerPixel + minStart;
                while (val < start) {
                    val = (float)(++pixel) * valsPerPixel + minStart;
                }
                if (start == end) {
                    g.setColor(startC);
                    g.drawLine(pixel, 0, pixel, height);
                    ++pixel;
                    continue;
                }
                while (pixel < width && start <= val && val <= end) {
                    float bias = (val - start) / (end - start);
                    Color blend = this.blender.blend(startC, endC, bias);
                    g.setColor(blend);
                    g.drawLine(pixel, 0, pixel, height);
                    val = (float)(++pixel) * valsPerPixel + minStart;
                }
            }
        }
    }

    public static String tabDelimColor(Color color) {
        return color.getRed() + "\t" + color.getGreen() + "\t" + color.getBlue();
    }

    @Override
    public String toString() {
        String out = "# CPT File generated by OpenSHA: " + this.getClass().getName() + "\n";
        out = out + "# Date: " + new Date() + "\n";
        for (CPTVal v : this) {
            out = out + v.toString() + "\n";
        }
        if (this.belowMinColor != null) {
            out = out + "B\t" + CPT.tabDelimColor(this.belowMinColor) + "\n";
        }
        if (this.aboveMaxColor != null) {
            out = out + "F\t" + CPT.tabDelimColor(this.aboveMaxColor) + "\n";
        }
        if (this.nanColor != null) {
            out = out + "N\t" + CPT.tabDelimColor(this.nanColor) + "\n";
        }
        return out;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        CPT cpt = CPT.loadFromFile(new File("/usr/share/gmt/cpt/GMT_seis.cpt"));
        System.out.println(cpt);
    }
}

