/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util.cpt;

import java.awt.Color;
import java.io.Serializable;
import org.dom4j.Element;
import org.opensha.commons.util.cpt.CPT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CPTVal
implements Comparable<CPTVal>,
Serializable {
    public Color minColor;
    public Color maxColor;
    public float start;
    public float end;

    public CPTVal() {
    }

    public CPTVal(float start, int minR, int minG, int minB, float end, int maxR, int maxG, int maxB) {
        this.minColor = new Color(minR, minG, minB);
        this.maxColor = new Color(maxR, maxG, maxB);
        this.start = start;
        this.end = end;
        if (start > end) {
            throw new IllegalArgumentException("Start value: [" + this.start + "] is greater than end value of: [" + this.end + "].");
        }
    }

    public CPTVal(float start, Color minColor, float end, Color maxColor) {
        this.minColor = minColor;
        this.maxColor = maxColor;
        this.start = start;
        this.end = end;
        if (start > end) {
            throw new IllegalArgumentException("Start value: [" + this.start + "] is greater than end value of: [" + this.end + "].");
        }
    }

    public Element toXML(Element cptVal) {
        Element min = cptVal.addElement("start");
        min.addAttribute("val", new Float(this.start).toString());
        min.addAttribute("r", this.minColor.getRed() + "");
        min.addAttribute("g", this.minColor.getGreen() + "");
        min.addAttribute("b", this.minColor.getBlue() + "");
        Element max = cptVal.addElement("end");
        max.addAttribute("val", new Float(this.end).toString());
        max.addAttribute("r", this.maxColor.getRed() + "");
        max.addAttribute("g", this.maxColor.getGreen() + "");
        max.addAttribute("b", this.maxColor.getBlue() + "");
        return cptVal;
    }

    public static CPTVal fromXML(Element cptVal) {
        Element valStart = cptVal.element("start");
        float start = Float.parseFloat(valStart.attributeValue("val"));
        int minR = Integer.parseInt(valStart.attributeValue("r"));
        int minG = Integer.parseInt(valStart.attributeValue("g"));
        int minB = Integer.parseInt(valStart.attributeValue("b"));
        Element valEnd = cptVal.element("end");
        float end = Float.parseFloat(valEnd.attributeValue("val"));
        int maxR = Integer.parseInt(valEnd.attributeValue("r"));
        int maxG = Integer.parseInt(valEnd.attributeValue("g"));
        int maxB = Integer.parseInt(valEnd.attributeValue("b"));
        return new CPTVal(start, minR, minG, minB, end, maxR, maxG, maxB);
    }

    @Override
    public int compareTo(CPTVal other) {
        if (this.end <= other.start) {
            return -1;
        }
        if (this.start >= other.end) {
            return 1;
        }
        return 0;
    }

    public boolean contains(float value) {
        return this.start <= value && value <= this.end;
    }

    public String toString() {
        return this.start + "\t" + CPT.tabDelimColor(this.minColor) + "\t" + this.end + "\t" + CPT.tabDelimColor(this.maxColor);
    }
}

