/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import org.opensha.commons.data.estimate.Estimate;
import org.opensha.commons.data.estimate.IntegerEstimate;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.refFaultParamDb.dao.EstimateDAO_API;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.XY_EstimateDB_DAO;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.dao.exception.UpdateException;

public class IntegerEstimateDB_DAO
implements EstimateDAO_API {
    public static final String EST_TYPE_NAME = "IntegerEstimate";
    private static final String ERR_MSG = "This class just deals with Integer Estimates";
    private XY_EstimateDB_DAO xyEstimateDB_DAO = new XY_EstimateDB_DAO();

    public IntegerEstimateDB_DAO(DB_AccessAPI dbAccessAPI) {
        this.setDB_Connection(dbAccessAPI);
    }

    public IntegerEstimateDB_DAO() {
    }

    public void setDB_Connection(DB_AccessAPI dbAccessAPI) {
        this.xyEstimateDB_DAO.setDB_Connection(dbAccessAPI);
    }

    public void addEstimate(int estimateInstanceId, Estimate estimate) throws InsertException {
        if (!(estimate instanceof IntegerEstimate)) {
            throw new InsertException(ERR_MSG);
        }
        IntegerEstimate integerEstimate = (IntegerEstimate)estimate;
        this.xyEstimateDB_DAO.addEstimate(estimateInstanceId, integerEstimate.getValues());
    }

    public Estimate getEstimate(int estimateInstanceId) throws QueryException {
        ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
        this.xyEstimateDB_DAO.getEstimate(estimateInstanceId, func);
        IntegerEstimate estimate = new IntegerEstimate(func, false);
        return estimate;
    }

    public boolean removeEstimate(int estimateInstanceId) throws UpdateException {
        return this.xyEstimateDB_DAO.removeEstimate(estimateInstanceId);
    }

    public String getEstimateTypeName() {
        return EST_TYPE_NAME;
    }
}

