/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.ListIterator;
import org.dom4j.Element;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.data.region.Region;
import org.opensha.commons.metadata.MetadataLoader;
import org.opensha.commons.metadata.XMLSaveable;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterAPI;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.TimeSpanChangeListener;
import org.opensha.sha.earthquake.EqkRupForecastAPI;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.util.TectonicRegionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EqkRupForecast
implements EqkRupForecastAPI,
TimeSpanChangeListener,
ParameterChangeListener,
XMLSaveable {
    protected ParameterList adjustableParams = new ParameterList();
    protected TimeSpan timeSpan;
    protected boolean parameterChangeFlag = true;
    public static final String XML_METADATA_NAME = "ERF";

    public ListIterator getAdjustableParamsIterator() {
        return this.adjustableParams.getParametersIterator();
    }

    @Override
    public boolean isLocWithinApplicableRegion(Location loc) {
        return true;
    }

    @Override
    public Region getApplicableRegion() {
        return null;
    }

    public ParameterAPI getParameter(String paramName) {
        return this.adjustableParams.getParameter(paramName);
    }

    @Override
    public void setTimeSpan(TimeSpan time) {
        if (!time.getStartTimePrecision().equalsIgnoreCase("None")) {
            this.timeSpan.setStartTime(time.getStartTimeCalendar());
        }
        this.timeSpan.setDuration(time.getDuration(), time.getDurationUnits());
    }

    @Override
    public TimeSpan getTimeSpan() {
        return this.timeSpan;
    }

    @Override
    public boolean setParameter(String name, Object value) {
        if (this.getAdjustableParameterList().containsParameter(name)) {
            this.getAdjustableParameterList().getParameter(name).setValue(value);
            return true;
        }
        if (this.timeSpan.getAdjustableParams().containsParameter(name)) {
            this.timeSpan.getAdjustableParams().getParameter(name).setValue(value);
            return true;
        }
        return false;
    }

    @Override
    public void timeSpanChange(EventObject event) {
        this.parameterChangeFlag = true;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        this.parameterChangeFlag = true;
    }

    @Override
    public abstract int getNumSources();

    @Override
    public abstract ProbEqkSource getSource(int var1);

    @Override
    public abstract ArrayList getSourceList();

    @Override
    public int getNumRuptures(int iSource) {
        return this.getSource(iSource).getNumRuptures();
    }

    public ProbEqkRupture getRuptureClone(int iSource, int nRupture) {
        return this.getSource(iSource).getRuptureClone(nRupture);
    }

    @Override
    public ProbEqkRupture getRupture(int iSource, int nRupture) {
        return this.getSource(iSource).getRupture(nRupture);
    }

    public Iterator getSourcesIterator() {
        Iterator i = this.getSourceList().iterator();
        return i;
    }

    public ProbEqkSource getSourceClone(int iSource) {
        return null;
    }

    @Override
    public ParameterList getAdjustableParameterList() {
        return this.adjustableParams;
    }

    public void setParameterChangeFlag(boolean flag) {
        this.parameterChangeFlag = flag;
    }

    @Override
    public String updateAndSaveForecast() {
        throw new UnsupportedOperationException("updateAndSaveForecast() not supported");
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element xml = root.addElement(XML_METADATA_NAME);
        xml.addAttribute("className", this.getClass().getName());
        ListIterator<ParameterAPI> paramIt = this.getAdjustableParameterList().getParametersIterator();
        Element paramsElement = xml.addElement("Parameters");
        while (paramIt.hasNext()) {
            Parameter param = (Parameter)paramIt.next();
            paramsElement = param.toXMLMetadata(paramsElement);
        }
        xml = this.timeSpan.toXMLMetadata(xml);
        return root;
    }

    public static EqkRupForecast fromXMLMetadata(Element root) throws InvocationTargetException {
        String className = root.attribute("className").getValue();
        System.out.println("Loading ERF: " + className);
        EqkRupForecast erf = (EqkRupForecast)MetadataLoader.createClassInstance(className);
        System.out.println("Setting params...");
        Element paramsElement = root.element("Parameters");
        ParameterList.setParamsInListFromXML(erf.getAdjustableParameterList(), paramsElement);
        erf.setTimeSpan(TimeSpan.fromXMLMetadata(root.element("TimeSpan")));
        return erf;
    }

    @Override
    public ArrayList<EqkRupture> drawRandomEventSet() {
        ArrayList<EqkRupture> rupList = new ArrayList<EqkRupture>();
        for (int s = 0; s < this.getNumSources(); ++s) {
            rupList.addAll(this.getSource(s).drawRandomEqkRuptures());
        }
        return rupList;
    }

    @Override
    public ArrayList<TectonicRegionType> getIncludedTectonicRegionTypes() {
        ArrayList<TectonicRegionType> list = new ArrayList<TectonicRegionType>();
        list.add(TectonicRegionType.ACTIVE_SHALLOW);
        return list;
    }
}

