/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.calc.recurInterval;

import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.param.DoubleParameter;
import org.opensha.commons.param.IntegerParameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeListener;

public abstract class EqkProbDistCalc
implements ParameterChangeListener {
    protected EvenlyDiscretizedFunc pdf;
    protected EvenlyDiscretizedFunc cdf;
    protected double mean;
    protected double aperiodicity;
    protected double deltaX;
    protected double duration;
    protected int numPoints;
    public static final double DELTA_X_DEFAULT = 0.001;
    protected boolean upToDate = false;
    protected String NAME;
    protected static final String MEAN_PARAM_NAME = "Mean";
    protected static final String APERIODICITY_PARAM_NAME = "Aperiodicity";
    protected static final String DURATION_PARAM_NAME = "Duration";
    protected static final String DELTA_X_PARAM_NAME = "Delta X";
    protected static final String NUM_POINTS_PARAM_NAME = "Num Points";
    protected static final String MEAN_PARAM_INFO = "Mean";
    protected static final String APERIODICITY_PARAM_INFO = "Aperiodicity";
    protected static final String DURATION_PARAM_INFO = "Duration";
    protected static final String DELTA_X_PARAM_INFO = "Delta X";
    protected static final String NUM_POINTS_PARAM_INFO = "Num Points";
    protected static final Double DEFAULT_MEAN_PARAM_VAL = new Double(100.0);
    protected static final Double DEFAULT_APERIODICITY_PARAM_VAL = new Double(0.5);
    protected static final Double DEFAULT_DURATION_PARAM_VAL = new Double(30.0);
    protected static final Double DEFAULT_DELTAX_PARAM_VAL = new Double(1.0);
    protected static final Integer DEFAULT_NUMPOINTS_PARAM_VAL = new Integer(500);
    protected DoubleParameter meanParam;
    protected DoubleParameter aperiodicityParam;
    protected DoubleParameter durationParam;
    protected DoubleParameter deltaX_Param;
    protected IntegerParameter numPointsParam;
    protected ParameterList adjustableParams;

    abstract void computeDistributions();

    public EvenlyDiscretizedFunc getCDF() {
        if (!this.upToDate) {
            this.computeDistributions();
        }
        return this.cdf;
    }

    public EvenlyDiscretizedFunc getPDF() {
        if (!this.upToDate) {
            this.computeDistributions();
        }
        return this.pdf;
    }

    public EvenlyDiscretizedFunc getHazFunc() {
        if (!this.upToDate) {
            this.computeDistributions();
        }
        EvenlyDiscretizedFunc hazFunc = new EvenlyDiscretizedFunc(0.0, this.pdf.getMaxX(), this.pdf.getNum());
        for (int i = 0; i < hazFunc.getNum(); ++i) {
            double haz = this.pdf.getY(i) / (1.0 - this.cdf.getY(i));
            hazFunc.set(i, haz);
        }
        return hazFunc;
    }

    public EvenlyDiscretizedFunc getCondProbFunc() {
        if (this.duration == 0.0) {
            throw new RuntimeException("duration has not been set");
        }
        if (!this.upToDate) {
            this.computeDistributions();
        }
        int numPts = this.numPoints - (int)(this.duration / this.deltaX + 1.0);
        EvenlyDiscretizedFunc condFunc = new EvenlyDiscretizedFunc(0.0, numPts, this.deltaX);
        for (int i = 0; i < condFunc.getNum(); ++i) {
            condFunc.set(i, this.getCondProb(condFunc.getX(i), this.duration));
        }
        return condFunc;
    }

    public double getCondProb(double timeSinceLast, double duration) {
        if (!this.upToDate) {
            this.computeDistributions();
        }
        double p1 = this.cdf.getInterpolatedY(timeSinceLast);
        double p2 = this.cdf.getInterpolatedY(timeSinceLast + duration);
        return (p2 - p1) / (1.0 - p1);
    }

    protected void initAdjParams() {
        this.meanParam = new DoubleParameter("Mean", Double.MIN_VALUE, Double.MAX_VALUE, DEFAULT_MEAN_PARAM_VAL);
        this.meanParam.setInfo("Mean");
        this.meanParam.addParameterChangeListener(this);
        this.aperiodicityParam = new DoubleParameter("Aperiodicity", Double.MIN_VALUE, Double.MAX_VALUE, DEFAULT_APERIODICITY_PARAM_VAL);
        this.aperiodicityParam.setInfo("Aperiodicity");
        this.aperiodicityParam.addParameterChangeListener(this);
        this.durationParam = new DoubleParameter("Duration", Double.MIN_VALUE, Double.MAX_VALUE, DEFAULT_DURATION_PARAM_VAL);
        this.durationParam.setInfo("Duration");
        this.durationParam.addParameterChangeListener(this);
        this.deltaX_Param = new DoubleParameter("Delta X", Double.MIN_VALUE, Double.MAX_VALUE, DEFAULT_DELTAX_PARAM_VAL);
        this.deltaX_Param.setInfo("Delta X");
        this.deltaX_Param.addParameterChangeListener(this);
        this.numPointsParam = new IntegerParameter("Num Points", Integer.MIN_VALUE, Integer.MAX_VALUE, DEFAULT_NUMPOINTS_PARAM_VAL);
        this.numPointsParam.setInfo("Num Points");
        this.numPointsParam.addParameterChangeListener(this);
    }

    public ParameterList getAdjParams() {
        return this.adjustableParams;
    }

    public String getName() {
        return this.NAME;
    }
}

