/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.griddedForecast;

import java.util.ArrayList;
import java.util.Arrays;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.region.GriddedRegion;
import org.opensha.sha.earthquake.griddedForecast.HypoMagFreqDistAtLoc;
import org.opensha.sha.earthquake.griddedForecast.STEP_AftershockForecast;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.faultSurface.SimpleFaultData;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.step.calc.OmoriRate_Calc;
import org.opensha.step.calc.RegionDefaults;

public class GenericAfterHypoMagFreqDistForecast
extends STEP_AftershockForecast {
    protected double a_valueGeneric = -1.6;
    protected double b_valueGeneric = 0.98;
    protected double c_valueGeneric = 0.03;
    protected double p_valueGeneric = 1.05;
    protected double genNodeCompletenessMag;
    protected SimpleFaultData mainshockFault;
    protected double[] grid_Gen_kVal;
    protected double[] grid_Gen_aVal;
    protected double[] grid_Gen_bVal;
    protected double[] grid_Gen_cVal;
    protected double[] grid_Gen_pVal;
    int numGridLocs;
    protected double[] rateForecastGrid;
    protected double[] kScaler;
    protected RegionDefaults rDefs;
    protected ArrayList gridMagForecast;
    protected HypoMagFreqDistAtLoc magDistLoc;

    public GenericAfterHypoMagFreqDistForecast(ObsEqkRupture mainshock, GriddedRegion aftershockZone, double[] kScaler) {
        if (!RegionDefaults.FORECAST_PARAM_FIXED) {
            this.set_GenReasenbergJonesParms(new double[]{RegionDefaults.FORECAST_A_VALUE, RegionDefaults.FORECAST_B_VALUE, RegionDefaults.FORECAST_C_VALUE, RegionDefaults.FORECAST_P_VALUE});
        }
        this.setMainShock(mainshock);
        this.setRegion(aftershockZone);
        this.numGridLocs = aftershockZone.getNodeCount();
        this.calc_GenNodeCompletenessMag();
        this.set_Gridded_Gen_bValue();
        this.set_Gridded_Gen_cValue();
        this.set_Gridded_Gen_pValue();
        this.set_kScaler(kScaler);
        this.set_Gridded_Gen_kValue();
    }

    public void set_GenReasenbergJonesParms(double[] rjParms) {
        this.a_valueGeneric = rjParms[0];
        this.b_valueGeneric = rjParms[1];
        this.c_valueGeneric = rjParms[2];
        this.p_valueGeneric = rjParms[3];
    }

    public int getNumGridLocs() {
        return this.numGridLocs;
    }

    public void setNumGridLocs() {
        this.numGridLocs = this.getRegion().getNodeCount();
    }

    public void set_kScaler(double[] kScaler) {
        this.kScaler = kScaler;
    }

    public void set_Gridded_Gen_kValue() {
        this.grid_Gen_kVal = new double[this.numGridLocs];
        double rightSide = this.a_valueGeneric + this.b_valueGeneric * (this.mainShock.getMag() - this.genNodeCompletenessMag);
        double generic_k = Math.pow(10.0, rightSide);
        int numInd = this.kScaler.length;
        double totK = 0.0;
        if (numInd != this.numGridLocs) {
            System.out.println("set_Gridded_Gen_kValue numInd= " + numInd + " numGridLocs =" + this.numGridLocs + " region " + this.region.getName());
        }
        for (int indLoop = 0; indLoop < numInd; ++indLoop) {
            this.grid_Gen_kVal[indLoop] = generic_k * this.kScaler[indLoop];
            totK += this.kScaler[indLoop];
        }
    }

    public void set_Gridded_Gen_aValue() {
        this.grid_Gen_aVal = new double[this.numGridLocs];
        Arrays.fill(this.grid_Gen_aVal, this.a_valueGeneric);
    }

    public void set_Gridded_Gen_bValue() {
        this.grid_Gen_bVal = new double[this.numGridLocs];
        Arrays.fill(this.grid_Gen_bVal, this.b_valueGeneric);
    }

    public void set_Gridded_Gen_pValue() {
        this.grid_Gen_pVal = new double[this.numGridLocs];
        Arrays.fill(this.grid_Gen_pVal, this.p_valueGeneric);
    }

    public void set_Gridded_Gen_cValue() {
        this.grid_Gen_cVal = new double[this.numGridLocs];
        Arrays.fill(this.grid_Gen_cVal, this.c_valueGeneric);
    }

    public void set_GriddedRateForecast(double[] rateForecastGrid) {
        this.rateForecastGrid = rateForecastGrid;
    }

    public ArrayList getGenMagForecast() {
        if (this.gridMagForecast == null) {
            this.gridMagForecast = new ArrayList();
        }
        double[] rjParms = new double[4];
        double[] forecastDays = new double[2];
        OmoriRate_Calc omoriCalc = new OmoriRate_Calc();
        forecastDays[0] = this.dayStart;
        forecastDays[1] = this.dayEnd;
        rjParms[1] = this.grid_Gen_cVal[0];
        rjParms[2] = this.grid_Gen_pVal[0];
        omoriCalc.setTimeParms(forecastDays);
        int numForecastMags = 1 + (int)((this.maxForecastMag - this.minForecastMag) / this.deltaForecastMag);
        double[] magForecast = new double[numForecastMags];
        int nodeLoop = 0;
        for (int numNodes = this.grid_Gen_kVal.length; nodeLoop < numNodes; ++numNodes) {
            rjParms[0] = this.grid_Gen_kVal[nodeLoop];
            omoriCalc.set_OmoriParms(rjParms);
            double totalForecast = omoriCalc.get_OmoriRate();
            GutenbergRichterMagFreqDist GR_Dist = new GutenbergRichterMagFreqDist(this.a_valueGeneric, totalForecast, this.minForecastMag, this.maxForecastMag, numForecastMags);
            for (int magLoop = 0; magLoop < numForecastMags; ++magLoop) {
                magForecast[magLoop] = GR_Dist.getIncrRate(magLoop);
            }
            this.gridMagForecast.add(magForecast);
        }
        return this.gridMagForecast;
    }

    public HypoMagFreqDistAtLoc calcHypoMagFreqDist(int gridIndex) {
        double[] rjParms = new double[4];
        double[] forecastDays = new double[2];
        OmoriRate_Calc omoriCalc = new OmoriRate_Calc();
        forecastDays[0] = this.dayStart;
        forecastDays[1] = this.dayEnd;
        rjParms[1] = this.grid_Gen_cVal[0];
        rjParms[2] = this.grid_Gen_pVal[0];
        omoriCalc.setTimeParms(forecastDays);
        int numForecastMags = 1 + (int)((this.maxForecastMag - this.minForecastMag) / this.deltaForecastMag);
        rjParms[0] = this.grid_Gen_kVal[gridIndex];
        omoriCalc.set_OmoriParms(rjParms);
        double totalForecast = omoriCalc.get_OmoriRate();
        GutenbergRichterMagFreqDist GR_Dist = new GutenbergRichterMagFreqDist(this.b_valueGeneric, totalForecast, this.minForecastMag, this.maxForecastMag, numForecastMags);
        IncrementalMagFreqDist[] dist = new IncrementalMagFreqDist[]{GR_Dist};
        Location gridLoc = this.getRegion().locationForIndex(gridIndex);
        this.magDistLoc = new HypoMagFreqDistAtLoc(dist, gridLoc);
        return this.magDistLoc;
    }

    public double get_a_valueGeneric() {
        return this.a_valueGeneric;
    }

    public double get_b_valueGeneric() {
        return this.b_valueGeneric;
    }

    public double get_c_valueGeneric() {
        return this.c_valueGeneric;
    }

    public double get_p_valueGeneric() {
        return this.p_valueGeneric;
    }

    public double get_k_valueGenericAtLoc(int ithLocation) {
        return this.grid_Gen_kVal[ithLocation];
    }

    public double[] getGridded_k_value_generic() {
        return this.grid_Gen_kVal;
    }

    public double get_genNodeCompletenessMag() {
        return this.genNodeCompletenessMag;
    }

    public void calc_GenNodeCompletenessMag() {
        this.genNodeCompletenessMag = RegionDefaults.minForecastMag;
    }

    public double[] getRateForecastGrid() {
        return this.rateForecastGrid;
    }

    public Location getLocInGrid(int ithLocation) {
        return this.getRegion().locationForIndex(ithLocation);
    }
}

