/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.griddedForecast;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.opensha.commons.calc.RelativeLocation;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.WC1994_MagLengthRelationship;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.data.region.GriddedRegion;
import org.opensha.commons.data.region.Region;
import org.opensha.sha.cybershake.openshaAPIs.CyberShakeEvenlyGriddedSurface;
import org.opensha.sha.earthquake.griddedForecast.AfterShockHypoMagFreqDistForecast;
import org.opensha.sha.earthquake.griddedForecast.GenericAfterHypoMagFreqDistForecast;
import org.opensha.sha.earthquake.griddedForecast.HypoMagFreqDistAtLoc;
import org.opensha.sha.earthquake.griddedForecast.NewGenericAfterHypoMagFreqDistForecast;
import org.opensha.sha.earthquake.griddedForecast.STEP_AftershockForecast;
import org.opensha.sha.earthquake.griddedForecast.SequenceAfterHypoMagFreqDistForecast;
import org.opensha.sha.earthquake.griddedForecast.SpatialAfterHypoMagFreqDistForecast;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.SimpleFaultData;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.step.calc.AkaikeInformationCriterion;
import org.opensha.step.calc.BackGroundRatesGrid;
import org.opensha.step.calc.CalcAIC_Weights;
import org.opensha.step.calc.CompletenessMagCalc;
import org.opensha.step.calc.CountObsInGrid;
import org.opensha.step.calc.DistDecayFromRupCalc;
import org.opensha.step.calc.OgataLogLike_Calc;
import org.opensha.step.calc.RegionDefaults;
import org.opensha.step.calc.STEP_TypeIIAftershockZone_Calc;

public class STEP_CombineForecastModels
extends AfterShockHypoMagFreqDistForecast {
    public double minForecastMag;
    private double maxForecastMag;
    private double deltaMag;
    private SimpleFaultData mainshockFault;
    public boolean useFixed_cValue = true;
    private boolean useCircularRegion = false;
    private boolean useSausageRegion = false;
    private boolean hasExternalFaultModel = false;
    public double addToMc;
    private double zoneRadius;
    private double gridSpacing;
    public double[] gridDistanceFromFault;
    private GregorianCalendar forecastEndTime;
    private GregorianCalendar currentTime;
    private boolean isStatic = false;
    private boolean isPrimary = true;
    private boolean isSecondary = false;
    private boolean useSeqAndSpatial = false;
    private ArrayList griddedMagFreqDistForecast;
    private TimeSpan timeSpan;
    private double daysSinceMainshockStart;
    private double daysSinceMainshockEnd;
    private BackGroundRatesGrid backgroundRatesGrid;
    private double[] kScaler;
    private GenericAfterHypoMagFreqDistForecast genElement;
    private SequenceAfterHypoMagFreqDistForecast seqElement = null;
    private SpatialAfterHypoMagFreqDistForecast spaElement = null;
    private HypoMagFreqDistAtLoc[] combinedForecast;
    private GriddedRegion aftershockZone;
    private boolean existSeqElement = false;
    private boolean existSpaElement = false;
    private boolean usedInForecast = false;
    private boolean gridIsUpdated = false;
    private static Logger logger = Logger.getLogger(STEP_CombineForecastModels.class);

    public STEP_CombineForecastModels(ObsEqkRupture mainshock, BackGroundRatesGrid backgroundRatesGrid, GregorianCalendar currentTime) {
        this.mainShock = mainshock;
        this.backgroundRatesGrid = backgroundRatesGrid;
        this.currentTime = currentTime;
        this.gridSpacing = backgroundRatesGrid.getRegion().getSpacing();
        this.calcTimeSpan(this.getCurrentTime());
        this.setDaysSinceMainshock();
        this.set_AftershockZoneRadius();
        this.calcTypeI_AftershockZone();
        ObsEqkRupList emptyAftershocks = new ObsEqkRupList();
        this.setAfterShocks(emptyAftershocks);
        double[] kScaler = DistDecayFromRupCalc.getDensity(this.mainShock, this.aftershockZone);
        this.setGridDistanceFromFault(DistDecayFromRupCalc.getRupDistList());
        GenericAfterHypoMagFreqDistForecast genElement = null;
        genElement = RegionDefaults.GENERIC_MODEL_TYPE == 0 ? new GenericAfterHypoMagFreqDistForecast(this.mainShock, this.aftershockZone, kScaler) : new NewGenericAfterHypoMagFreqDistForecast(this.mainShock, this.aftershockZone, kScaler);
        this.genElement = genElement;
        this.setChildParms(genElement);
    }

    private void setChildParms(STEP_AftershockForecast model) {
        model.setTimeSpan(this.timeSpan);
        model.setMinForecastMag(RegionDefaults.minForecastMag);
        model.setMaxForecastMag(RegionDefaults.maxForecastMag);
        model.setDeltaForecastMag(RegionDefaults.deltaForecastMag);
        model.setUseFixed_cValue(RegionDefaults.useFixed_cValue);
        model.dayStart = this.daysSinceMainshockStart;
        model.dayEnd = this.daysSinceMainshockEnd;
    }

    public void createSequenceElement() {
        this.existSeqElement = true;
        SequenceAfterHypoMagFreqDistForecast seqElement = new SequenceAfterHypoMagFreqDistForecast(this.mainShock, this.getAfterShockZone(), this.getAfterShocks());
        seqElement.set_kScaler(this.kScaler);
        this.setChildParms(seqElement);
        this.seqElement = seqElement;
    }

    public void createSpatialElement() {
        this.existSpaElement = true;
        SpatialAfterHypoMagFreqDistForecast spaElement = new SpatialAfterHypoMagFreqDistForecast(this.mainShock, this.getAfterShockZone(), this.getAfterShocks());
        this.setChildParms(spaElement);
        this.spaElement = spaElement;
    }

    public void createCombinedForecast() {
        double[] genOmoriVals = new double[3];
        double[] seqOmoriVals = new double[3];
        double[] spaOmoriVals = new double[3];
        if (this.useSeqAndSpatial) {
            int numGridNodes = this.getAfterShockZone().getNodeCount();
            this.combinedForecast = new HypoMagFreqDistAtLoc[numGridNodes];
            CountObsInGrid numInGridCalc = new CountObsInGrid(this.afterShocks, this.aftershockZone);
            int[] griddedNumObs = numInGridCalc.getNumObsInGridList();
            genOmoriVals[2] = this.genElement.get_p_valueGeneric();
            genOmoriVals[1] = this.genElement.get_c_valueGeneric();
            seqOmoriVals[2] = this.seqElement.get_pValSequence();
            seqOmoriVals[1] = this.seqElement.get_cVal_Sequence();
            for (int gLoop = 0; gLoop < numGridNodes; ++gLoop) {
                HypoMagFreqDistAtLoc combHypoMagFreqDist;
                double radius = this.spaElement.getGridSearchRadius();
                Region nodeRegion = new Region(this.getRegion().locationForIndex(gLoop), radius);
                ObsEqkRupList gridEvents = this.afterShocks.getObsEqkRupsInside(nodeRegion);
                gridEvents.addObsEqkEventAt(this.mainShock, 0);
                genOmoriVals[0] = this.genElement.get_k_valueGenericAtLoc(gLoop);
                OgataLogLike_Calc genOgataCalc = new OgataLogLike_Calc(genOmoriVals, gridEvents);
                double genLikelihood = genOgataCalc.get_OgataLogLikelihood();
                AkaikeInformationCriterion genAIC_Calc = new AkaikeInformationCriterion(griddedNumObs[gLoop], RegionDefaults.genNumFreeParams, genLikelihood);
                double genAIC = genAIC_Calc.getAIC_Score();
                seqOmoriVals[0] = this.seqElement.get_kVal_SequenceAtLoc(gLoop);
                OgataLogLike_Calc seqOgataCalc = new OgataLogLike_Calc(seqOmoriVals, gridEvents);
                double seqLikelihood = seqOgataCalc.get_OgataLogLikelihood();
                AkaikeInformationCriterion seqAIC_Calc = new AkaikeInformationCriterion(griddedNumObs[gLoop], RegionDefaults.seqNumFreeParams, seqLikelihood);
                double seqAIC = seqAIC_Calc.getAIC_Score();
                spaOmoriVals[0] = this.spaElement.get_Spa_kValueAtLoc(gLoop);
                spaOmoriVals[1] = this.spaElement.get_Spa_cValueAtLoc(gLoop);
                spaOmoriVals[2] = this.spaElement.get_Spa_pValueAtLoc(gLoop);
                OgataLogLike_Calc spaOgataCalc = new OgataLogLike_Calc(spaOmoriVals, gridEvents);
                double spaLikelihood = spaOgataCalc.get_OgataLogLikelihood();
                AkaikeInformationCriterion spaAIC_Calc = new AkaikeInformationCriterion(griddedNumObs[gLoop], RegionDefaults.spaNumFreeParams, spaLikelihood);
                double spaAIC = spaAIC_Calc.getAIC_Score();
                CalcAIC_Weights calcAIC = new CalcAIC_Weights(genAIC, seqAIC, spaAIC);
                double genWeight = calcAIC.getGenWeight();
                double seqWeight = calcAIC.getSeqWeight();
                double spaWeight = calcAIC.getSpaWeight();
                IncrementalMagFreqDist genDist = this.genElement.getHypoMagFreqDistAtLoc(gLoop).getFirstMagFreqDist();
                IncrementalMagFreqDist seqDist = this.seqElement.getHypoMagFreqDistAtLoc(gLoop).getFirstMagFreqDist();
                IncrementalMagFreqDist spaDist = this.spaElement.getHypoMagFreqDistAtLoc(gLoop).getFirstMagFreqDist();
                int numMags = (int)((genDist.getMaxX() - genDist.getMinX()) / genDist.getDelta()) + 1;
                IncrementalMagFreqDist combDist = new IncrementalMagFreqDist(RegionDefaults.minForecastMag, RegionDefaults.maxForecastMag, numMags);
                for (int mLoop = 0; mLoop < numMags; ++mLoop) {
                    double distValue = 0.0;
                    double genRates = genDist.getIncrRate(mLoop) * genWeight;
                    double seqnRates = seqDist.getIncrRate(mLoop) * seqWeight;
                    double spaRates = spaDist.getIncrRate(mLoop) * spaWeight;
                    if (!Double.isNaN(genRates)) {
                        distValue += genRates;
                    }
                    if (!Double.isNaN(seqnRates)) {
                        distValue += seqnRates;
                    }
                    if (!Double.isNaN(spaRates)) {
                        distValue += spaRates;
                    }
                    combDist.set(mLoop, distValue);
                }
                this.combinedForecast[gLoop] = combHypoMagFreqDist = new HypoMagFreqDistAtLoc(combDist, this.genElement.getLocInGrid(gLoop));
            }
        } else {
            this.combinedForecast = this.genElement.griddedMagFreqDistForecast;
        }
    }

    public void set_minForecastMag(double min_forecastMag) {
        this.minForecastMag = min_forecastMag;
    }

    public void set_maxForecastMag(double max_forecastMag) {
        this.maxForecastMag = max_forecastMag;
    }

    public void set_deltaMag(double delta_mag) {
        this.deltaMag = delta_mag;
    }

    public void set_GridSpacing(double grid_spacing) {
        this.gridSpacing = grid_spacing;
    }

    public void setUseFixed_cVal(boolean fix_cVal) {
        this.useFixed_cValue = fix_cVal;
    }

    public void set_UsedInForecast(boolean used) {
        this.usedInForecast = used;
    }

    public void set_addToMcConstant(double mcConst) {
        this.addToMc = mcConst;
    }

    public void set_isStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public void set_isPrimary(boolean isPrimary) {
        this.isPrimary = isPrimary;
        if (isPrimary) {
            this.set_isSecondary(false);
        } else {
            this.set_isSecondary(true);
        }
    }

    private void set_isSecondary(boolean isSecondary) {
        this.isSecondary = isSecondary;
    }

    public void set_PreviousAftershocks(ObsEqkRupList previousAftershockList) {
    }

    public void set_AftershockZoneRadius() {
        ObsEqkRupture mainshock = this.getMainShock();
        double mainshockMag = mainshock.getMag();
        WC1994_MagLengthRelationship WCRel = new WC1994_MagLengthRelationship();
        this.zoneRadius = WCRel.getMedianLength(mainshockMag);
        if (this.zoneRadius < RegionDefaults.Min_Aftershock_R) {
            this.zoneRadius = RegionDefaults.Min_Aftershock_R;
        }
    }

    public void calcTypeI_AftershockZone() {
        if (!this.getHasExternalFaultModel()) {
            ObsEqkRupture mainshock = this.getMainShock();
            Location mainshockLocation = mainshock.getHypocenterLocation();
            Region asZoneGR = new Region(mainshockLocation, this.zoneRadius);
            this.aftershockZone = this.backgroundRatesGrid.getRegion().subRegion(asZoneGR);
            int n = 1;
            while (this.aftershockZone.isEmpty()) {
                double closestGrid2CentreDistance = RelativeLocation.getHorzDistance(mainshockLocation, this.aftershockZone.getAnchor());
                this.zoneRadius = closestGrid2CentreDistance + 0.01 * (double)n;
                asZoneGR = new Region(mainshockLocation, this.zoneRadius);
                this.aftershockZone = this.backgroundRatesGrid.getRegion().subRegion(asZoneGR);
                ++n;
            }
            this.aftershockZone.setName("circlarAFZ");
            this.setRegion(this.aftershockZone);
            this.useCircularRegion = true;
        }
    }

    public void calcTypeII_AfterShockZone(ObsEqkRupList aftershockList, GriddedRegion backGroundRatesGrid) {
        logger.info((Object)">>000 calcTypeII_AfterShockZone ");
        if (this.hasExternalFaultModel) {
            STEP_TypeIIAftershockZone_Calc typeIIcalc = new STEP_TypeIIAftershockZone_Calc(aftershockList, this);
            typeIIcalc.CreateAftershockZoneDef();
            GriddedRegion typeII_AS_Zone = typeIIcalc.get_TypeIIAftershockZone();
            GriddedRegion typeII_Zone = backGroundRatesGrid.subRegion(typeII_AS_Zone);
            typeII_Zone.setName("sausageAFZ");
            this.aftershockZone = typeII_Zone;
            this.setRegion(typeII_Zone);
            if (this.seqElement != null) {
                this.seqElement.setAftershockZone(typeII_Zone);
            }
            if (this.genElement != null) {
                this.genElement.setAfterShockZone(typeII_Zone);
            }
            if (this.spaElement != null) {
                this.spaElement.setAftershockZone(typeII_Zone);
            }
            this.useSausageRegion = true;
            String faultName = "external_typeIIfault";
            LocationList extFaultPoints = new LocationList();
            extFaultPoints.addLocation(RegionDefaults.extFaultLat1, RegionDefaults.extFaultLon1, 0.0);
            extFaultPoints.addLocation(RegionDefaults.extFaultLat2, RegionDefaults.extFaultLon2, 0.0);
            extFaultPoints.addLocation(RegionDefaults.extFaultLat3, RegionDefaults.extFaultLon3, 0.0);
            FaultTrace fault_trace = new FaultTrace(faultName);
            fault_trace.addLocation(extFaultPoints.getLocationAt(0));
            fault_trace.addLocation(extFaultPoints.getLocationAt(1));
            fault_trace.addLocation(extFaultPoints.getLocationAt(2));
            System.out.println("EXTERNAL " + this.mainShock.getMag() + " fault_trace " + extFaultPoints.getLocationAt(0) + " " + extFaultPoints.getLocationAt(1) + " " + extFaultPoints.getLocationAt(2));
            this.set_FaultSurface(fault_trace);
        } else {
            STEP_TypeIIAftershockZone_Calc typeIIcalc = new STEP_TypeIIAftershockZone_Calc(aftershockList, this);
            typeIIcalc.CreateAftershockZoneDef();
            GriddedRegion typeII_AS_Zone = typeIIcalc.get_TypeIIAftershockZone();
            GriddedRegion typeII_Zone = backGroundRatesGrid.subRegion(typeII_AS_Zone);
            typeII_Zone.setName("sausageAFZ");
            this.aftershockZone = typeII_Zone;
            this.setRegion(typeII_Zone);
            if (this.seqElement != null) {
                this.seqElement.setAftershockZone(typeII_Zone);
            }
            if (this.genElement != null) {
                this.genElement.setAfterShockZone(typeII_Zone);
            }
            if (this.spaElement != null) {
                this.spaElement.setAftershockZone(typeII_Zone);
            }
            this.useSausageRegion = true;
            LocationList faultPoints = typeIIcalc.getTypeIIFaultModel();
            String faultName = "typeIIfault";
            FaultTrace fault_trace = new FaultTrace(faultName);
            fault_trace.addLocation(faultPoints.getLocationAt(0));
            fault_trace.addLocation(faultPoints.getLocationAt(1));
            fault_trace.addLocation(faultPoints.getLocationAt(2));
            System.out.println("fault_trace " + faultPoints.getLocationAt(0) + " " + faultPoints.getLocationAt(1) + " " + faultPoints.getLocationAt(2));
            this.set_FaultSurface(fault_trace);
        }
    }

    private void set_FaultSurface(FaultTrace fault_trace) {
        CyberShakeEvenlyGriddedSurface griddedSurface = new CyberShakeEvenlyGriddedSurface(1, fault_trace.size(), this.aftershockZone.getSpacing());
        ArrayList<Location> locs = new ArrayList<Location>();
        for (int i = 0; i < fault_trace.getNumLocations(); ++i) {
            Location loc = fault_trace.getLocationAt(i);
            locs.add(loc);
        }
        griddedSurface.setAllLocations(locs);
        this.mainShock.setRuptureSurface(griddedSurface);
    }

    private void set_CurrentTime() {
        GregorianCalendar curTime = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        int year = curTime.get(1);
        int month = curTime.get(2);
        int day = curTime.get(5);
        int hour24 = curTime.get(11);
        int min = curTime.get(12);
        int sec = curTime.get(13);
        this.currentTime = new GregorianCalendar(year, month, day, hour24, min, sec);
    }

    public void set_CurrentTime(GregorianCalendar currentTime) {
        this.currentTime = currentTime;
    }

    public void calcTimeSpan() {
        String durationUnits = "Days";
        String timePrecision = "Seconds";
        this.timeSpan = new TimeSpan(timePrecision, durationUnits);
        this.set_CurrentTime();
        this.timeSpan.setStartTime(this.currentTime);
        this.timeSpan.setDuration(RegionDefaults.forecastLengthDays);
        this.setTimeSpan(this.timeSpan);
    }

    public void setDaysSinceMainshock() {
        String durationUnits = "Days";
        GregorianCalendar startDate = this.timeSpan.getStartTimeCalendar();
        double duration = this.timeSpan.getDuration(durationUnits);
        ObsEqkRupture mainshock = this.getMainShock();
        GregorianCalendar mainshockDate = mainshock.getOriginTime();
        long startInMils = startDate.getTimeInMillis();
        long mainshockInMils = mainshockDate.getTimeInMillis();
        long timeDiffMils = startInMils - mainshockInMils;
        this.daysSinceMainshockStart = (double)timeDiffMils / 1000.0 / 60.0 / 60.0 / 24.0;
        this.daysSinceMainshockEnd = this.daysSinceMainshockStart + duration;
    }

    public void set_useSeqAndSpatial() {
        int size = this.afterShocks.size();
        if (size < 100) {
            this.useSeqAndSpatial = false;
        } else {
            ObsEqkRupList compList;
            CompletenessMagCalc compMagCalc = new CompletenessMagCalc(this.getAfterShocks());
            double mComplete = compMagCalc.getMcBest();
            if (this.mainShock.getMag() >= 7.0) {
                mComplete = 4.0;
                System.out.println("Seq Mc for M>7.0 forced to = " + mComplete);
            }
            this.useSeqAndSpatial = (compList = this.afterShocks.getObsEqkRupsAboveMag(mComplete)).size() > 100;
        }
    }

    public double getDaysSinceMainshockStart() {
        return this.daysSinceMainshockStart;
    }

    public double getDaysSinceMainshockEnd() {
        return this.daysSinceMainshockEnd;
    }

    public boolean get_UsedInForecast() {
        return this.usedInForecast;
    }

    public void setHasExternalFaultModel(boolean hasExternalFaultModel) {
        this.hasExternalFaultModel = hasExternalFaultModel;
    }

    public double get_minForecastMag() {
        return this.minForecastMag;
    }

    public double get_maxForecastMag() {
        return this.maxForecastMag;
    }

    public double get_deltaMag() {
        return this.deltaMag;
    }

    public boolean get_useSeqAndSpatial() {
        return this.useSeqAndSpatial;
    }

    public double get_GridSpacing() {
        return this.gridSpacing;
    }

    public SimpleFaultData get_FaultModel() {
        return this.mainshockFault;
    }

    public double get_addToMcConst() {
        return this.addToMc;
    }

    public boolean get_isStatic() {
        return this.isStatic;
    }

    public boolean get_isPrimary() {
        return this.isPrimary;
    }

    public boolean get_isSecondary() {
        return this.isSecondary;
    }

    public double get_AftershockZoneRadius() {
        return this.zoneRadius;
    }

    public ArrayList get_griddedMagFreqDistForecast() {
        return this.griddedMagFreqDistForecast;
    }

    public boolean getHasExternalFaultModel() {
        return this.hasExternalFaultModel;
    }

    public GenericAfterHypoMagFreqDistForecast getGenElement() {
        return this.genElement;
    }

    public SequenceAfterHypoMagFreqDistForecast getSeqElement() {
        return this.seqElement;
    }

    public SpatialAfterHypoMagFreqDistForecast getSpaElement() {
        return this.spaElement;
    }

    public HypoMagFreqDistAtLoc getHypoMagFreqDistAtLoc(int ithLocation) {
        return this.combinedForecast[ithLocation];
    }

    public HypoMagFreqDistAtLoc[] getGriddedAIC_CombinedForecast() {
        return this.combinedForecast;
    }

    public boolean getExistSeqElement() {
        return this.existSeqElement;
    }

    public boolean getExistSpaElement() {
        return this.existSpaElement;
    }

    public GregorianCalendar getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(GregorianCalendar currentTime) {
        this.currentTime = currentTime;
    }

    public void updateCurrentTime(GregorianCalendar currtTime) {
        this.currentTime = currtTime;
        this.calcTimeSpan(this.getCurrentTime());
        this.setDaysSinceMainshock();
        if (this.genElement != null) {
            this.setChildParms(this.genElement);
        }
        if (this.seqElement != null) {
            this.setChildParms(this.seqElement);
        }
        if (this.spaElement != null) {
            this.setChildParms(this.spaElement);
        }
    }

    public void calcTimeSpan(GregorianCalendar currentTime2) {
        String durationUnits = "Days";
        String timePrecision = "Seconds";
        this.timeSpan = new TimeSpan(timePrecision, durationUnits);
        this.setCurrentTime(currentTime2);
        this.timeSpan.setStartTime(this.currentTime);
        this.timeSpan.setDuration(RegionDefaults.forecastLengthDays);
        this.setTimeSpan(this.timeSpan);
    }

    public BackGroundRatesGrid getBackgroundRatesGrid() {
        return this.backgroundRatesGrid;
    }

    public boolean isUseSausageRegion() {
        return this.useSausageRegion;
    }

    public boolean isGridIsUpdated() {
        return this.gridIsUpdated;
    }

    public void setGridIsUpdated(boolean gridIsUpdated) {
        this.gridIsUpdated = gridIsUpdated;
    }

    public boolean updateAftershockZone() {
        this.gridIsUpdated = false;
        int numAftershocks = this.getAfterShocks().size();
        if (numAftershocks >= 100) {
            this.calcTypeII_AfterShockZone(this.getAfterShocks(), this.getBackgroundRatesGrid().getRegion());
            this.gridIsUpdated = true;
        }
        return this.gridIsUpdated;
    }

    public void setGridDistanceFromFault(double[] gridDist) {
        this.gridDistanceFromFault = gridDist;
    }

    public double[] getGridDistanceFromFault() {
        return this.gridDistanceFromFault;
    }
}

