/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.A_Faults;

import java.awt.Color;
import java.util.ArrayList;
import org.opensha.commons.calc.MomentMagCalc;
import org.opensha.commons.data.function.ArbDiscrEmpiricalDistFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.sha.earthquake.calc.recurInterval.BPT_DistCalc;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.A_Faults.WG02_QkProbCalc;
import org.opensha.sha.gui.infoTools.GraphiWindowAPI_Impl;
import org.opensha.sha.gui.infoTools.PlotCurveCharacterstics;

public class WG02_QkSimulations {
    private static String C = new String("WG02_QkSimulations");
    private static final boolean D = false;
    protected String NAME = "WG02_QkSimulations";
    private double[] eventYear;
    private double[] segRate;
    private int[] eventIndex;
    private int[][] rupInSeg;
    double[] segAlpha;

    public void computeSimulatedEvents(double[] rupRate, double[] segMoRate, double alpha, int[][] rupInSeg, int numEvents) {
        this.segAlpha = new double[segMoRate.length];
        for (int i = 0; i < segMoRate.length; ++i) {
            this.segAlpha[i] = alpha;
        }
        this.computeSimulatedEvents(rupRate, segMoRate, this.segAlpha, rupInSeg, numEvents);
    }

    public void computeSimulatedEvents(double[] rupRate, double[] segMoRate, double[] segAlpha, int[][] rupInSeg, int numEvents) {
        int progressReportIncrement;
        this.rupInSeg = rupInSeg;
        this.segAlpha = segAlpha;
        this.segRate = this.getSegRateFromRupRate(rupRate, rupInSeg);
        this.eventIndex = new int[numEvents];
        this.eventYear = new double[numEvents];
        WG02_QkProbCalc calc = new WG02_QkProbCalc();
        int numSeg = this.segRate.length;
        double deltaYear = 1.0;
        double year = 0.0;
        double[] segTimeOfLast = new double[numSeg];
        double[] segTimeSinceLast = new double[numSeg];
        int numSimEvents = 0;
        int progressReportAt = progressReportIncrement = numEvents / 10;
        while (numSimEvents < numEvents) {
            int s;
            year += deltaYear;
            for (s = 0; s < numSeg; ++s) {
                segTimeSinceLast[s] = year - segTimeOfLast[s];
            }
            double[] rupProbs = WG02_QkProbCalc.getRupProbs(this.segRate, rupRate, segMoRate, segAlpha, segTimeSinceLast, deltaYear, rupInSeg);
            int rupIndex = WG02_QkSimulations.getRandomEvent(rupProbs);
            if (rupIndex <= -1) continue;
            this.eventYear[numSimEvents] = year;
            this.eventIndex[numSimEvents] = rupIndex;
            for (s = 0; s < numSeg; ++s) {
                if (rupInSeg[s][rupIndex] != 1) continue;
                segTimeOfLast[s] = year;
            }
            if (++numSimEvents != progressReportAt) continue;
            int perc = 100 * progressReportAt / numEvents;
            System.out.println(perc + " Percent Done");
            progressReportAt += progressReportIncrement;
        }
    }

    public ArbDiscrEmpiricalDistFunc getCDF_ofSegRecurIntervals(int ithSeg) {
        ArbDiscrEmpiricalDistFunc func = new ArbDiscrEmpiricalDistFunc();
        boolean numRup = false;
        double yearLast = 0.0;
        for (int i = 0; i < this.eventIndex.length; ++i) {
            if (this.rupInSeg[ithSeg][this.eventIndex[i]] != 1) continue;
            func.set(this.eventYear[i] - yearLast, 1.0);
            yearLast = this.eventYear[i];
        }
        return func;
    }

    public EvenlyDiscretizedFunc getPDF_ofSegRecurIntervals(int ithSeg, double binWidth) {
        double interval;
        double maxInt = 0.0;
        double yearLast = 0.0;
        int numInts = 0;
        for (int i = 0; i < this.eventIndex.length; ++i) {
            if (this.rupInSeg[ithSeg][this.eventIndex[i]] != 1) continue;
            interval = this.eventYear[i] - yearLast;
            if (interval > maxInt) {
                maxInt = interval;
            }
            ++numInts;
            yearLast = this.eventYear[i];
        }
        double min = binWidth / 2.0;
        int num = Math.round((float)((maxInt - min) / binWidth)) + 1;
        EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc(min, num, binWidth);
        func.setTolerance(1.1 * binWidth);
        yearLast = 0.0;
        double yAddOn = 1.0 / ((double)numInts * binWidth);
        for (int i = 0; i < this.eventIndex.length; ++i) {
            if (this.rupInSeg[ithSeg][this.eventIndex[i]] != 1) continue;
            interval = this.eventYear[i] - yearLast;
            func.set(interval, func.getY(interval) + yAddOn);
            yearLast = this.eventYear[i];
        }
        return func;
    }

    public double getSimAveRupRate(int ithRup) {
        int numRup = 0;
        double yearFirst = -1.0;
        double yearLast = -1.0;
        for (int i = 0; i < this.eventIndex.length; ++i) {
            if (this.eventIndex[i] != ithRup) continue;
            if (++numRup == 1) {
                yearFirst = this.eventYear[i];
            }
            yearLast = this.eventYear[i];
        }
        if (numRup == 0) {
            return 0.0;
        }
        return (double)(numRup - 1) / (yearLast - yearFirst);
    }

    public double getSimAveSegRate(int ithSeg) {
        int numRup = 0;
        double yearFirst = 0.0;
        double yearLast = -1.0;
        for (int i = 0; i < this.eventIndex.length; ++i) {
            if (this.rupInSeg[ithSeg][this.eventIndex[i]] != 1) continue;
            ++numRup;
            yearLast = this.eventYear[i];
        }
        if (numRup == 0) {
            return 0.0;
        }
        return (double)numRup / (yearLast - yearFirst);
    }

    public double getSimMoRate(double[] rupMag) {
        double totMoment = 0.0;
        for (int i = 0; i < this.eventIndex.length; ++i) {
            totMoment += MomentMagCalc.getMoment(rupMag[this.eventIndex[i]]);
        }
        double moRate = totMoment / this.eventYear[this.eventYear.length - 1];
        totMoment = 0.0;
        for (int i = 0; i < this.eventIndex.length - 1; ++i) {
            totMoment += MomentMagCalc.getMoment(rupMag[this.eventIndex[i]]);
        }
        double moRate2 = totMoment / this.eventYear[this.eventYear.length - 1];
        System.out.println("MoRateRange:" + (float)moRate2 + "   " + (float)moRate);
        return moRate;
    }

    public static int getRandomEvent(double[] prob) {
        double prandProb = Math.random();
        double sum = 0.0;
        for (int i = 0; i < prob.length; ++i) {
            if (prandProb >= sum && prandProb < sum + prob[i]) {
                return i;
            }
            sum += prob[i];
        }
        return -1;
    }

    private double[] getSegRateFromRupRate(double[] rupRate, int[][] rupInSeg) {
        double[] segRate = new double[rupInSeg.length];
        for (int i = 0; i < segRate.length; ++i) {
            for (int j = 0; j < rupRate.length; ++j) {
                int n = i;
                segRate[n] = segRate[n] + (double)rupInSeg[i][j] * rupRate[j];
            }
        }
        return segRate;
    }

    public void testWithWG02_SingleSegRups() {
        int i;
        double[] segMoRate = new double[]{4.74714853E24, 5.62020641E24, 1.51106804E25, 1.06885024E25};
        double[] segAlpha = new double[]{0.2, 0.5, 0.8, 0.5};
        double[] segMag = new double[]{7.16886, 7.24218, 7.52195, 7.37158};
        double[] segRate = new double[segMoRate.length];
        for (int i2 = 0; i2 < segRate.length; ++i2) {
            segRate[i2] = segMoRate[i2] / (MomentMagCalc.getMoment(segMag[i2]) * 1.0E7);
        }
        double[] rupRate = new double[]{segRate[0], segRate[1], segRate[2], segRate[3], 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] rupMag = new double[]{7.16886, 7.24218, 7.52195, 7.37158, 7.5081, 7.70524, 7.75427, 7.81611, 7.87073, 7.94943};
        int[][] rupInSeg = new int[][]{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 0, 0, 0, 0}};
        System.out.println("Starting Simulation Test");
        long startTime = System.currentTimeMillis();
        int numSim = 1000;
        this.computeSimulatedEvents(rupRate, segMoRate, segAlpha, (int[][])rupInSeg, numSim);
        double timeTaken = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        System.out.println("Done w/ " + numSim + " events in " + (float)timeTaken + " seconds");
        System.out.println("Segment Rate From Recur. Int. CDF:");
        for (i = 0; i < segRate.length; ++i) {
            ArbDiscrEmpiricalDistFunc cdf = this.getCDF_ofSegRecurIntervals(i);
            System.out.println("ratio=" + (float)(this.getSimAveSegRate(i) * cdf.getMean()) + ";  cdfRate=" + (float)(1.0 / cdf.getMean()) + "; simSegRate=" + (float)this.getSimAveSegRate(i) + "; numEvents=" + cdf.getSumOfAllY_Values());
        }
        System.out.println("Rup rates: orig, sim, and sim/orig");
        for (i = 0; i < rupRate.length; ++i) {
            double simRate = this.getSimAveRupRate(i);
            System.out.println((float)rupRate[i] + "   " + (float)simRate + "   " + (float)(simRate / rupRate[i]));
        }
        System.out.println("Seg rates: orig, sim, and sim/orig");
        for (i = 0; i < segRate.length; ++i) {
            double simRate = this.getSimAveSegRate(i);
            System.out.println((float)segRate[i] + "   " + (float)simRate + "   " + (float)(simRate / segRate[i]));
        }
        double totMoRate = 0.0;
        for (int i3 = 0; i3 < rupRate.length; ++i3) {
            totMoRate += rupRate[i3] * MomentMagCalc.getMoment(rupMag[i3]);
        }
        System.out.println("Tot Moment rates: orig, sim, and sim/orig");
        double simMoRate = this.getSimMoRate(rupMag);
        System.out.println((float)totMoRate + "   " + (float)simMoRate + "   " + (float)(simMoRate / totMoRate));
        this.plotSegmentRecurIntPDFs();
    }

    public void plotSegmentRecurIntPDFs() {
        BPT_DistCalc calc = new BPT_DistCalc();
        for (int i = 0; i < this.rupInSeg.length; ++i) {
            ArrayList<EvenlyDiscretizedFunc> funcList = new ArrayList<EvenlyDiscretizedFunc>();
            double mri = 1.0 / this.segRate[i];
            int num = (int)(this.segAlpha[i] * 10.0 / 0.05);
            calc.setAll(mri, this.segAlpha[i], 0.05 * mri, num);
            funcList.add(calc.getPDF());
            double binWidth = Math.round(mri / 10.0);
            funcList.add(this.getPDF_ofSegRecurIntervals(i, binWidth));
            String title = "Simulated and Expected BPT Dist for seg " + i;
            ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
            plotChars.add(new PlotCurveCharacterstics("Solid Line", Color.RED, 2.0));
            plotChars.add(new PlotCurveCharacterstics("Histograms", Color.GRAY, 2.0));
            GraphiWindowAPI_Impl graph = new GraphiWindowAPI_Impl(funcList, title, plotChars);
            graph.setPlottingFeatures(plotChars);
            graph.setPlotLabelFontSize(24);
            graph.setY_AxisLabel("");
            graph.setX_AxisLabel("Segment Recurrence Interval");
            graph.setAxisAndTickLabelFontSize(20);
            graph.setAxisRange(0.0, mri * 5.0, 0.0, 1.1 * calc.getPDF().getMaxY());
        }
    }

    public void plotSegmentRecurIntPDFs(String[] segName) {
        BPT_DistCalc calc = new BPT_DistCalc();
        for (int i = 0; i < this.rupInSeg.length; ++i) {
            ArrayList<EvenlyDiscretizedFunc> funcList = new ArrayList<EvenlyDiscretizedFunc>();
            double mri = 1.0 / this.segRate[i];
            int num = (int)(this.segAlpha[i] * 10.0 / 0.05);
            calc.setAll(mri, this.segAlpha[i], 0.05 * mri, num);
            funcList.add(calc.getPDF());
            double binWidth = Math.round(mri / 10.0);
            funcList.add(this.getPDF_ofSegRecurIntervals(i, binWidth));
            String title = "PDF for " + segName[i];
            ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
            plotChars.add(new PlotCurveCharacterstics("Solid Line", Color.RED, 4.0));
            plotChars.add(new PlotCurveCharacterstics("Histograms", Color.GRAY, 2.0));
            GraphiWindowAPI_Impl graph = new GraphiWindowAPI_Impl(funcList, title, plotChars);
            graph.setPlotLabelFontSize(24);
            graph.setY_AxisLabel("");
            graph.setX_AxisLabel("Segment Recurrence Interval");
            graph.setAxisAndTickLabelFontSize(20);
            graph.setAxisRange(0.0, mri * 5.0, 0.0, 1.1 * calc.getPDF().getMaxY());
        }
    }

    public void wg02_haywardRC_simulation() {
        double simRate;
        int i;
        String[] segName = new String[]{"HS", "HN", "RC"};
        double[] segMoRate = new double[]{52.54, 34.89, 62.55};
        double alpha = 0.5;
        double[] rupRate = new double[]{0.00128, 0.00102, 0.00332, 0.00216, 3.2E-4, 4.4E-4};
        double[] rupMag = new double[]{7.0, 6.82, 7.07, 7.22, 7.27, 7.46};
        int[][] rupInSeg = new int[][]{{1, 0, 0, 1, 0, 1}, {0, 1, 0, 1, 1, 1}, {0, 0, 1, 0, 1, 1}};
        double[] segRate = this.getSegRateFromRupRate(rupRate, rupInSeg);
        System.out.println("Starting Simulation Test");
        long startTime = System.currentTimeMillis();
        int numSim = 20000;
        this.computeSimulatedEvents(rupRate, segMoRate, alpha, (int[][])rupInSeg, numSim);
        double timeTaken = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        System.out.println("Done w/ " + numSim + " events in " + (float)timeTaken + " seconds");
        System.out.println("Rup rates: orig, sim, and sim/orig");
        for (i = 0; i < rupRate.length; ++i) {
            simRate = this.getSimAveRupRate(i);
            System.out.println((float)rupRate[i] + "   " + (float)simRate + "   " + (float)(simRate / rupRate[i]));
        }
        System.out.println("Seg rates: orig, sim, and sim/orig");
        for (i = 0; i < segRate.length; ++i) {
            simRate = this.getSimAveSegRate(i);
            System.out.println((float)segRate[i] + "   " + (float)simRate + "   " + (float)(simRate / segRate[i]));
        }
        double totMoRate = 0.0;
        for (int i2 = 0; i2 < rupRate.length; ++i2) {
            totMoRate += rupRate[i2] * MomentMagCalc.getMoment(rupMag[i2]);
        }
        System.out.println("Tot Moment rates: orig, sim, and sim/orig");
        double simMoRate = this.getSimMoRate(rupMag);
        System.out.println((float)totMoRate + "   " + (float)simMoRate + "   " + (float)(simMoRate / totMoRate));
        this.plotSegmentRecurIntPDFs(segName);
    }

    public void testWithWG02_values() {
        double simRate;
        int i;
        double[] segMoRate = new double[]{4.74714853E24, 5.62020641E24, 1.51106804E25, 1.06885024E25};
        double[] segAlpha = new double[]{0.2, 0.5, 0.8, 0.5};
        double[] segT_Last = new double[]{96.0, 96.0, 96.0, 96.0};
        double duration = 30.0;
        double[] segRate = new double[]{0.00466746464, 0.00432087015, 0.004199435, 0.004199435};
        double[] rupRate = new double[]{0.00145604357, 7.06832856E-4, 0.0, 0.0, 5.05269971E-4, 0.0, 0.00109066791, 0.0, 4.02616395E-4, 0.00270615076};
        double[] rupMag = new double[]{7.16886, 7.24218, 7.52195, 7.37158, 7.5081, 7.70524, 7.75427, 7.81611, 7.87073, 7.94943};
        int[][] rupInSeg = new int[][]{{1, 0, 0, 0, 1, 0, 0, 1, 0, 1}, {0, 1, 0, 0, 1, 1, 0, 1, 1, 1}, {0, 0, 1, 0, 0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0, 0, 1, 0, 1, 1}};
        System.out.println("Testing segment rates:");
        double[] testSegRate = this.getSegRateFromRupRate(rupRate, rupInSeg);
        for (int i2 = 0; i2 < segRate.length; ++i2) {
            System.out.println(segRate[i2] + "  " + testSegRate[i2] + "  " + segRate[i2] / testSegRate[i2]);
        }
        System.out.println("Starting Simulation Test");
        long startTime = System.currentTimeMillis();
        int numSim = 1000;
        this.computeSimulatedEvents(rupRate, segMoRate, segAlpha, (int[][])rupInSeg, numSim);
        double timeTaken = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        System.out.println("Done w/ " + numSim + " events in " + (float)timeTaken + " seconds");
        System.out.println("Rup rates: orig, sim, and sim/orig");
        for (i = 0; i < rupRate.length; ++i) {
            simRate = this.getSimAveRupRate(i);
            System.out.println((float)rupRate[i] + "   " + (float)simRate + "   " + (float)(simRate / rupRate[i]));
        }
        System.out.println("Seg rates: orig, sim, and sim/orig");
        for (i = 0; i < segRate.length; ++i) {
            simRate = this.getSimAveSegRate(i);
            System.out.println((float)segRate[i] + "   " + (float)simRate + "   " + (float)(simRate / segRate[i]));
        }
        double totMoRate = 0.0;
        for (int i3 = 0; i3 < rupRate.length; ++i3) {
            totMoRate += rupRate[i3] * MomentMagCalc.getMoment(rupMag[i3]);
        }
        System.out.println("Tot Moment rates: orig, sim, and sim/orig");
        double simMoRate = this.getSimMoRate(rupMag);
        System.out.println((float)totMoRate + "   " + (float)simMoRate + "   " + (float)(simMoRate / totMoRate));
        this.plotSegmentRecurIntPDFs();
    }

    public static void main(String[] args) {
        WG02_QkSimulations qkSim = new WG02_QkSimulations();
        qkSim.wg02_haywardRC_simulation();
    }
}

