/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.region.BorderType;
import org.opensha.commons.data.region.Region;
import org.opensha.commons.util.FileUtils;

public class EmpiricalModelDataFetcher
implements Serializable {
    public static String FILE_NAME = "org/opensha/sha/earthquake/rupForecastImpl/WGCEP_UCERF_2_3/data/EmpiricalModelData.txt";
    private ArrayList<Region> geographicRegionList = new ArrayList();
    private ArrayList<Double> rates = new ArrayList();
    private ArrayList<Double> stdDevs = new ArrayList();

    public EmpiricalModelDataFetcher() {
        try {
            ArrayList<String> fileLines = FileUtils.loadJarFile(FILE_NAME);
            int numLines = fileLines.size();
            for (int i = 0; i < numLines; ++i) {
                String line = fileLines.get(i);
                if (line.startsWith("#") || !line.startsWith("-")) continue;
                String regionName = line.substring(1).trim();
                StringTokenizer rateTokenizer = new StringTokenizer(fileLines.get(++i), ",");
                this.rates.add(Double.parseDouble(rateTokenizer.nextToken()));
                this.stdDevs.add(Double.parseDouble(rateTokenizer.nextToken()));
                int numLocPoints = Integer.parseInt(fileLines.get(++i));
                LocationList locList = new LocationList();
                for (int locIndex = 0; locIndex < numLocPoints; ++locIndex) {
                    StringTokenizer locTokenizer = new StringTokenizer(fileLines.get(++i), ",");
                    double latitude = Double.parseDouble(locTokenizer.nextToken());
                    double longitude = Double.parseDouble(locTokenizer.nextToken());
                    locList.addLocation(new Location(latitude, longitude));
                }
                if (locList.size() == 0) continue;
                Region region = new Region(locList, BorderType.MERCATOR_LINEAR);
                region.setName(regionName);
                this.geographicRegionList.add(region);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getNumRegions() {
        return this.geographicRegionList.size();
    }

    public Region getRegion(int index) {
        return this.geographicRegionList.get(index);
    }

    public double getRate(int index) {
        return this.rates.get(index);
    }

    public double getStdDev(int index) {
        return this.stdDevs.get(index);
    }

    public static void main(String[] args) {
        EmpiricalModelDataFetcher empModelDataFetcher = new EmpiricalModelDataFetcher();
        int numRegions = empModelDataFetcher.getNumRegions();
        System.out.println(numRegions);
        for (int i = 0; i < numRegions; ++i) {
            System.out.println(empModelDataFetcher.getRegion(i).getName());
            System.out.println(empModelDataFetcher.getRate(i));
            System.out.println(empModelDataFetcher.getStdDev(i));
        }
    }
}

