/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.MeanUCERF2;

import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.data.ValueWeight;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.param.BooleanParameter;
import org.opensha.commons.param.DoubleParameter;
import org.opensha.commons.param.ParameterAPI;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.StringParameter;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.refFaultParamDb.vo.DeformationModelSummary;
import org.opensha.sha.earthquake.EqkRupForecast;
import org.opensha.sha.earthquake.EqkSourceAPI;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.FaultRuptureSource;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.A_Faults.A_FaultSegmentedSourceGenerator;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.EmpiricalModel;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.FaultSegmentData;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.MeanUCERF2.B_FaultsFetcherForMeanUCERF;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UnsegmentedSource;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis.ParamOptions;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.A_FaultsFetcher;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.NonCA_FaultsFetcher;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.finalReferenceFaultParamDb.DeformationModelSummaryFinal;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.griddedSeis.NSHMP_GridSourceGenerator;
import org.opensha.sha.earthquake.util.EqkSourceNameComparator;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeanUCERF2
extends EqkRupForecast {
    protected static String C = new String("MeanUCERF2");
    protected boolean D = true;
    public static final String NAME = new String("WGCEP (2007) UCERF2 - Single Branch");
    protected SummedMagFreqDist bFaultSummedMFD;
    protected SummedMagFreqDist aFaultSummedMFD;
    protected IncrementalMagFreqDist totBackgroundMFD;
    protected IncrementalMagFreqDist cZoneSummedMFD;
    protected IncrementalMagFreqDist nonCA_B_FaultsSummedMFD;
    public static final String BACK_SEIS_INFO = new String("Background includes C Zones here");
    protected StringParameter backSeisParam;
    protected StringParameter backSeisRupParam;
    public static final String RUP_OFFSET_PARAM_NAME = "Rupture Offset";
    protected Double DEFAULT_RUP_OFFSET_VAL = new Double(5.0);
    protected static final String RUP_OFFSET_PARAM_UNITS = "km";
    protected static final String RUP_OFFSET_PARAM_INFO = "Length of offset for floating ruptures";
    public static final double RUP_OFFSET_PARAM_MIN = 1.0;
    public static final double RUP_OFFSET_PARAM_MAX = 100.0;
    protected DoubleParameter rupOffsetParam;
    protected StringParameter floaterTypeParam;
    public static final String CYBERSHAKE_DDW_CORR_PARAM_NAME = "Apply CyberShake DDW Corr";
    public static final Boolean CYBERSHAKE_DDW_CORR_PARAM_DEFAULT = new Boolean(false);
    protected static final String CYBERSHAKE_DDW_CORR_PARAM_INFO = "Apply Down Dip Width Correction";
    protected BooleanParameter cybershakeDDW_CorrParam;
    public static final String PROB_MODEL_WGCEP_PREF_BLEND = "WGCEP Preferred Blend";
    public static final String PROB_MODEL_DEFAULT = "WGCEP Preferred Blend";
    protected StringParameter probModelParam;
    protected static final double DURATION_DEFAULT = 30.0;
    protected static final double DURATION_MIN = 1.0;
    protected static final double DURATION_MAX = 100.0;
    protected static final int START_TIME_DEFAULT = 2007;
    protected static final int START_TIME_MIN = 2007;
    protected static final int START_TIME_MAX = 2107;
    protected CaliforniaRegions.RELM_GRIDDED region = new CaliforniaRegions.RELM_GRIDDED();
    protected EmpiricalModel empiricalModel = new EmpiricalModel();
    protected ArrayList<UnsegmentedSource> bFaultSources;
    protected ArrayList<UnsegmentedSource> aFaultUnsegmentedSources;
    protected ArrayList<FaultRuptureSource> aFaultSegmentedSources;
    protected ArrayList<ProbEqkSource> nonCA_bFaultSources;
    protected ArrayList<ProbEqkSource> allSources;
    protected ArrayList<String> aFaultsBranchParamNames;
    protected ArrayList<ParamOptions> aFaultsBranchParamValues;
    protected int lastParamIndex;
    protected HashMap<String, SummedMagFreqDist> sourceMFDMapping;
    protected HashMap<String, Double> sourceRakeMapping;
    protected HashMap<String, StirlingGriddedSurface> sourceGriddedSurfaceMapping;
    protected NSHMP_GridSourceGenerator nshmp_gridSrcGen = new NSHMP_GridSourceGenerator();
    protected UCERF2 ucerf2 = new UCERF2();
    protected DeformationModelSummaryFinal defModelSummaryFinal = new DeformationModelSummaryFinal();
    protected NonCA_FaultsFetcher nonCA_B_Faultsfetcher = new NonCA_FaultsFetcher();
    protected boolean calcSummedMFDs = false;
    protected static final String A_FAULTS_POISS_FILENAME = "org/opensha/sha/earthquake/rupForecastImpl/WGCEP_UCERF_2_Final/MeanUCERF2/Segmented_5km_Poiss.txt";
    protected static final String A_FAULTS_EMPIRICAL_FILENAME = "org/opensha/sha/earthquake/rupForecastImpl/WGCEP_UCERF_2_Final/MeanUCERF2/Segmented_5km_Emp.txt";

    public MeanUCERF2() {
        this.initAdjParams();
        this.setParamDefaults();
        this.createParamList();
        this.setTimespanParameter();
        this.rupOffsetParam.addParameterChangeListener(this);
        this.backSeisParam.addParameterChangeListener(this);
        this.backSeisRupParam.addParameterChangeListener(this);
        this.cybershakeDDW_CorrParam.addParameterChangeListener(this);
        this.probModelParam.addParameterChangeListener(this);
        this.floaterTypeParam.addParameterChangeListener(this);
        this.parameterChangeFlag = true;
    }

    private void initAdjParams() {
        ArrayList<String> backSeisOptionsStrings = new ArrayList<String>();
        backSeisOptionsStrings.add(UCERF2.BACK_SEIS_EXCLUDE);
        backSeisOptionsStrings.add(UCERF2.BACK_SEIS_INCLUDE);
        backSeisOptionsStrings.add(UCERF2.BACK_SEIS_ONLY);
        this.backSeisParam = new StringParameter(UCERF2.BACK_SEIS_NAME, backSeisOptionsStrings, UCERF2.BACK_SEIS_DEFAULT);
        this.backSeisParam.setInfo(BACK_SEIS_INFO);
        ArrayList<String> backSeisRupStrings = new ArrayList<String>();
        backSeisRupStrings.add(UCERF2.BACK_SEIS_RUP_POINT);
        backSeisRupStrings.add(UCERF2.BACK_SEIS_RUP_FINITE);
        backSeisRupStrings.add(UCERF2.BACK_SEIS_RUP_CROSSHAIR);
        this.backSeisRupParam = new StringParameter(UCERF2.BACK_SEIS_RUP_NAME, backSeisRupStrings, UCERF2.BACK_SEIS_RUP_DEFAULT);
        this.rupOffsetParam = new DoubleParameter(RUP_OFFSET_PARAM_NAME, 1.0, 100.0, RUP_OFFSET_PARAM_UNITS, this.DEFAULT_RUP_OFFSET_VAL);
        this.rupOffsetParam.setInfo(RUP_OFFSET_PARAM_INFO);
        this.cybershakeDDW_CorrParam = new BooleanParameter(CYBERSHAKE_DDW_CORR_PARAM_NAME, CYBERSHAKE_DDW_CORR_PARAM_DEFAULT);
        this.cybershakeDDW_CorrParam.setInfo(CYBERSHAKE_DDW_CORR_PARAM_INFO);
        ArrayList<String> floaterTypes = new ArrayList<String>();
        floaterTypes.add("Only along strike ( rupture full DDW)");
        floaterTypes.add("Along strike and down dip");
        floaterTypes.add("Along strike & centered down dip");
        this.floaterTypeParam = new StringParameter("Floater Type", floaterTypes, "Along strike & centered down dip");
        ArrayList<String> probModelOptions = new ArrayList<String>();
        probModelOptions.add("WGCEP Preferred Blend");
        probModelOptions.add("Poisson");
        probModelOptions.add("BPT");
        probModelOptions.add("Empirical");
        this.probModelParam = new StringParameter("Probability Model", probModelOptions, "WGCEP Preferred Blend");
        this.probModelParam.setInfo("Probability Model for Time Dependence");
    }

    public void setParamDefaults() {
        this.backSeisParam.setValue(UCERF2.BACK_SEIS_DEFAULT);
        this.backSeisRupParam.setValue(UCERF2.BACK_SEIS_RUP_DEFAULT);
        this.rupOffsetParam.setValue(this.DEFAULT_RUP_OFFSET_VAL);
        this.floaterTypeParam.setValue("Along strike & centered down dip");
        this.cybershakeDDW_CorrParam.setValue(CYBERSHAKE_DDW_CORR_PARAM_DEFAULT);
        this.probModelParam.setValue("WGCEP Preferred Blend");
    }

    private void createParamList() {
        this.adjustableParams = new ParameterList();
        this.adjustableParams.addParameter(this.rupOffsetParam);
        this.adjustableParams.addParameter(this.floaterTypeParam);
        this.adjustableParams.addParameter(this.backSeisParam);
        if (!((String)this.backSeisParam.getValue()).equals(UCERF2.BACK_SEIS_EXCLUDE)) {
            this.adjustableParams.addParameter(this.backSeisRupParam);
        }
        this.adjustableParams.addParameter(this.cybershakeDDW_CorrParam);
        this.adjustableParams.addParameter(this.probModelParam);
    }

    @Override
    public ProbEqkSource getSource(int iSource) {
        if (iSource < this.allSources.size()) {
            return this.allSources.get(iSource);
        }
        if (((String)this.backSeisRupParam.getValue()).equals(UCERF2.BACK_SEIS_RUP_CROSSHAIR)) {
            return this.nshmp_gridSrcGen.getCrosshairGriddedSource(iSource - this.allSources.size(), this.timeSpan.getDuration());
        }
        return this.nshmp_gridSrcGen.getRandomStrikeGriddedSource(iSource - this.allSources.size(), this.timeSpan.getDuration());
    }

    @Override
    public int getNumSources() {
        if (((String)this.backSeisParam.getValue()).equals(UCERF2.BACK_SEIS_INCLUDE) || ((String)this.backSeisParam.getValue()).equals(UCERF2.BACK_SEIS_ONLY)) {
            return this.allSources.size() + this.nshmp_gridSrcGen.getNumSources();
        }
        return this.allSources.size();
    }

    @Override
    public ArrayList getSourceList() {
        boolean isBackground;
        ArrayList<ProbEqkSource> sourceList = new ArrayList<ProbEqkSource>();
        sourceList.addAll(this.allSources);
        boolean bl = isBackground = ((String)this.backSeisParam.getValue()).equals(UCERF2.BACK_SEIS_INCLUDE) || ((String)this.backSeisParam.getValue()).equals(UCERF2.BACK_SEIS_ONLY);
        if (isBackground && ((String)this.backSeisRupParam.getValue()).equals(UCERF2.BACK_SEIS_RUP_CROSSHAIR)) {
            sourceList.addAll(this.nshmp_gridSrcGen.getAllCrosshairGriddedSources(this.timeSpan.getDuration()));
        } else if (isBackground) {
            sourceList.addAll(this.nshmp_gridSrcGen.getAllRandomStrikeGriddedSources(this.timeSpan.getDuration()));
        }
        return sourceList;
    }

    @Override
    public String getName() {
        return NAME;
    }

    private IncrementalMagFreqDist getTotal_B_FaultsMFD() {
        return this.bFaultSummedMFD;
    }

    private IncrementalMagFreqDist getTotal_NonCA_B_FaultsMFD() {
        return this.nonCA_B_FaultsSummedMFD;
    }

    private IncrementalMagFreqDist getTotal_A_FaultsMFD() {
        return this.aFaultSummedMFD;
    }

    private IncrementalMagFreqDist getTotal_BackgroundMFD() {
        return this.totBackgroundMFD;
    }

    private IncrementalMagFreqDist getTotal_C_ZoneMFD() {
        return this.cZoneSummedMFD;
    }

    public IncrementalMagFreqDist getTotalMFD() {
        SummedMagFreqDist totalMFD = new SummedMagFreqDist(5.05, 8.95, UCERF2.NUM_MAG);
        totalMFD.addIncrementalMagFreqDist(this.bFaultSummedMFD);
        totalMFD.addIncrementalMagFreqDist(this.aFaultSummedMFD);
        totalMFD.addIncrementalMagFreqDist(this.totBackgroundMFD);
        totalMFD.addIncrementalMagFreqDist(this.cZoneSummedMFD);
        totalMFD.addIncrementalMagFreqDist(this.nonCA_B_FaultsSummedMFD);
        return totalMFD;
    }

    @Override
    public void updateForecast() {
        if (this.parameterChangeFlag) {
            String backSeis = (String)this.backSeisParam.getValue();
            this.allSources = new ArrayList();
            if (this.calcSummedMFDs) {
                this.ucerf2.setTimeSpan(this.timeSpan);
                this.ucerf2.updateForecast();
                this.cZoneSummedMFD = this.ucerf2.getTotal_C_ZoneMFD();
                this.totBackgroundMFD = this.ucerf2.getTotal_BackgroundMFD();
                this.nonCA_B_FaultsSummedMFD = this.ucerf2.getTotal_NonCA_B_FaultsMFD();
            }
            if (!backSeis.equalsIgnoreCase(UCERF2.BACK_SEIS_ONLY)) {
                this.mkA_FaultSources();
                this.mkB_FaultSources();
                this.mkNonCA_B_FaultSources();
                Collections.sort(this.aFaultSegmentedSources, new EqkSourceNameComparator());
                Collections.sort(this.aFaultUnsegmentedSources, new EqkSourceNameComparator());
                Collections.sort(this.bFaultSources, new EqkSourceNameComparator());
                Collections.sort(this.nonCA_bFaultSources, new EqkSourceNameComparator());
                this.allSources.addAll(this.aFaultSegmentedSources);
                this.allSources.addAll(this.aFaultUnsegmentedSources);
                this.allSources.addAll(this.bFaultSources);
                this.allSources.addAll(this.nonCA_bFaultSources);
            }
            if (backSeis.equalsIgnoreCase(UCERF2.BACK_SEIS_INCLUDE) || backSeis.equalsIgnoreCase(UCERF2.BACK_SEIS_ONLY)) {
                String backSeisRup = (String)this.backSeisRupParam.getValue();
                if (backSeisRup.equalsIgnoreCase(UCERF2.BACK_SEIS_RUP_POINT)) {
                    this.nshmp_gridSrcGen.setAsPointSources(true);
                } else if (backSeisRup.equalsIgnoreCase(UCERF2.BACK_SEIS_RUP_FINITE)) {
                    this.nshmp_gridSrcGen.setAsPointSources(false);
                } else {
                    this.nshmp_gridSrcGen.setAsPointSources(false);
                }
                this.allSources.addAll(this.nshmp_gridSrcGen.getAllFixedStrikeSources(this.timeSpan.getDuration()));
            }
        }
        this.parameterChangeFlag = false;
    }

    private void mkA_FaultSources() {
        String probModel = (String)this.probModelParam.getValue();
        double duration = this.timeSpan.getDuration();
        double rupOffset = (Double)this.rupOffsetParam.getValue();
        boolean cybershakeDDW_Corr = (Boolean)this.cybershakeDDW_CorrParam.getValue();
        this.fillAdjustableParamsForA_Faults();
        this.sourceMFDMapping = new HashMap();
        this.sourceRakeMapping = new HashMap();
        this.sourceGriddedSurfaceMapping = new HashMap();
        this.findBranches(0, 1.0);
        this.aFaultSegmentedSources = new ArrayList();
        if (this.calcSummedMFDs) {
            this.aFaultSummedMFD = new SummedMagFreqDist(5.05, 8.95, UCERF2.NUM_MAG);
        }
        for (String name : this.sourceMFDMapping.keySet()) {
            if (this.calcSummedMFDs) {
                this.aFaultSummedMFD.addIncrementalMagFreqDist(this.sourceMFDMapping.get(name));
            }
            FaultRuptureSource faultRupSrc = new FaultRuptureSource(this.sourceMFDMapping.get(name), (EvenlyGriddedSurface)this.sourceGriddedSurfaceMapping.get(name), (double)this.sourceRakeMapping.get(name), duration);
            faultRupSrc.setName(name);
            this.aFaultSegmentedSources.add(faultRupSrc);
        }
        this.mkUnsegmentedA_FaultSources();
    }

    private void mkUnsegmentedA_FaultSources() {
        int i;
        double rupOffset = (Double)this.rupOffsetParam.getValue();
        double empiricalModelWt = 0.0;
        double duration = this.timeSpan.getDuration();
        String probModel = (String)this.probModelParam.getValue();
        if (probModel.equals("BPT") || probModel.equals("Poisson")) {
            empiricalModelWt = 0.0;
        } else if (probModel.equals("Empirical")) {
            empiricalModelWt = 1.0;
        } else if (probModel.equals("WGCEP Preferred Blend")) {
            empiricalModelWt = 0.3;
        }
        this.aFaultUnsegmentedSources = new ArrayList();
        A_FaultsFetcher aFaultsFetcher = this.ucerf2.getA_FaultsFetcher();
        DeformationModelSummary defModelSummary2_1 = this.defModelSummaryFinal.getDeformationModel("D2.1");
        DeformationModelSummary defModelSummary2_2 = this.defModelSummaryFinal.getDeformationModel("D2.2");
        DeformationModelSummary defModelSummary2_3 = this.defModelSummaryFinal.getDeformationModel("D2.3");
        double wt = 0.5;
        aFaultsFetcher.setDeformationModel(defModelSummary2_1, true);
        ArrayList faultSegmentList = aFaultsFetcher.getFaultSegmentDataList(true);
        ArrayList<Double> moRateList = new ArrayList<Double>();
        for (i = 0; i < faultSegmentList.size(); ++i) {
            moRateList.add(wt * ((FaultSegmentData)faultSegmentList.get(i)).getTotalMomentRate());
        }
        wt = 0.2;
        aFaultsFetcher.setDeformationModel(defModelSummary2_2, true);
        faultSegmentList = aFaultsFetcher.getFaultSegmentDataList(true);
        for (i = 0; i < faultSegmentList.size(); ++i) {
            double newMoRate = (Double)moRateList.get(i) + wt * ((FaultSegmentData)faultSegmentList.get(i)).getTotalMomentRate();
            moRateList.set(i, newMoRate);
        }
        wt = 0.3;
        aFaultsFetcher.setDeformationModel(defModelSummary2_3, true);
        faultSegmentList = aFaultsFetcher.getFaultSegmentDataList(true);
        boolean ddwCorr = (Boolean)this.cybershakeDDW_CorrParam.getValue();
        int floaterType = this.getFloaterType();
        for (int i2 = 0; i2 < faultSegmentList.size(); ++i2) {
            double newMoRate = (Double)moRateList.get(i2) + wt * ((FaultSegmentData)faultSegmentList.get(i2)).getTotalMomentRate();
            moRateList.set(i2, newMoRate);
            UnsegmentedSource unsegmentedSource = new UnsegmentedSource((FaultSegmentData)faultSegmentList.get(i2), this.empiricalModel, rupOffset, 0.0, 0.0, 0.1, empiricalModelWt, duration, (Double)moRateList.get(i2), 0.0, ddwCorr, floaterType, Double.NaN);
            this.aFaultUnsegmentedSources.add(unsegmentedSource);
            if (!this.calcSummedMFDs) continue;
            int numRups = unsegmentedSource.getNumRuptures();
            for (int rupIndex = 0; rupIndex < numRups; ++rupIndex) {
                ProbEqkRupture rup = unsegmentedSource.getRupture(rupIndex);
                double mag = rup.getMag();
                double rate = rup.getMeanAnnualRate(duration);
                this.aFaultSummedMFD.add(mag, rate);
            }
        }
    }

    protected int getFloaterType() {
        String floaterType = (String)this.floaterTypeParam.getValue();
        if (floaterType.equalsIgnoreCase("Only along strike ( rupture full DDW)")) {
            return 0;
        }
        if (floaterType.equalsIgnoreCase("Along strike and down dip")) {
            return 1;
        }
        if (floaterType.equalsIgnoreCase("Along strike & centered down dip")) {
            return 2;
        }
        throw new RuntimeException("Unsupported Floating ruptures option");
    }

    private void findBranches(int paramIndex, double weight) {
        ParamOptions options = this.aFaultsBranchParamValues.get(paramIndex);
        String paramName = this.aFaultsBranchParamNames.get(paramIndex);
        int numValues = options.getNumValues();
        for (int i = 0; i < numValues; ++i) {
            double newWt;
            if (this.ucerf2.getAdjustableParameterList().containsParameter(paramName)) {
                this.ucerf2.getParameter(paramName).setValue(options.getValue(i));
                newWt = weight * options.getWeight(i);
            } else if (i == 0) {
                newWt = weight;
            } else {
                return;
            }
            if (paramIndex == this.lastParamIndex) {
                this.mkA_FaultSegmentedSourceGenerators(newWt);
                continue;
            }
            this.findBranches(paramIndex + 1, newWt);
        }
    }

    private void mkA_FaultSegmentedSourceGenerators(double weight) {
        double minA_FaultRate2;
        double minA_FaultRate1;
        ParameterAPI param;
        double relativeA_PrioriWeight = (Double)this.ucerf2.getParameter("Wt On A-Priori Rates").getValue();
        double relativeSegRateWeight = UCERF2.REL_SEG_RATE_WT_PARAM_DEFAULT;
        double magSigma = UCERF2.MAG_SIGMA_DEFAULT;
        double magTruncLevel = UCERF2.TRUNC_LEVEL_DEFAULT;
        boolean isAseisReducesArea = true;
        double meanMagCorrection = UCERF2.MEAN_MAG_CORRECTION_DEFAULT;
        boolean wtedInversion = true;
        ParameterList rupModels = (ParameterList)this.ucerf2.getParameter("Segmented A-Fault Solution Types").getValue();
        boolean ddwCorr = (Boolean)this.cybershakeDDW_CorrParam.getValue();
        A_FaultsFetcher aFaultsFetcher = this.ucerf2.getA_FaultsFetcher();
        DeformationModelSummary defModelSummary = this.defModelSummaryFinal.getDeformationModel((String)this.ucerf2.getParameter("Deformation Model").getValue());
        aFaultsFetcher.setDeformationModel(defModelSummary, false);
        ArrayList aFaultSegmentData = aFaultsFetcher.getFaultSegmentDataList(isAseisReducesArea);
        double duration = this.timeSpan.getDuration();
        double startYear = Double.NaN;
        double aperiodicity = Double.NaN;
        boolean isSegDependentAperiodicity = false;
        String probModel = (String)this.ucerf2.getParameter("Probability Model").getValue();
        if (probModel.equals("BPT")) {
            startYear = this.timeSpan.getStartTimeYear();
            isSegDependentAperiodicity = false;
            aperiodicity = (Double)this.ucerf2.getParameter("Aperiodicity").getValue();
        }
        if ((Double)(param = this.ucerf2.getParameter("Wt On A-Priori Rates")).getValue() == 1.0E10) {
            minA_FaultRate1 = 0.0;
            minA_FaultRate2 = 0.0;
        } else {
            minA_FaultRate1 = UCERF2.MIN_A_FAULT_RATE_1_DEFAULT;
            minA_FaultRate2 = UCERF2.MIN_A_FAULT_RATE_2_DEFAULT;
        }
        String slipModel = "Tapered Ends ([Sin(x)]^0.5)";
        double totMoRateReduction = 0.1;
        for (int i = 0; i < aFaultSegmentData.size(); ++i) {
            int rup;
            FaultSegmentData segmentData = (FaultSegmentData)aFaultSegmentData.get(i);
            ValueWeight[] aPrioriRates = aFaultsFetcher.getAprioriRupRates(segmentData.getFaultName(), (String)rupModels.getValue(segmentData.getFaultName()));
            double[] minRates = new double[aPrioriRates.length];
            double minRateFrac1 = minA_FaultRate1;
            double minRateFrac2 = minA_FaultRate2;
            double minRate = Double.MAX_VALUE;
            for (rup = 0; rup < aPrioriRates.length; ++rup) {
                if (!(aPrioriRates[rup].getValue() < minRate) || !(aPrioriRates[rup].getValue() >= 0.0)) continue;
                minRate = aPrioriRates[rup].getValue();
            }
            for (rup = 0; rup < aPrioriRates.length; ++rup) {
                double rate = aPrioriRates[rup].getValue();
                if (rate >= 0.0) {
                    minRates[rup] = minRate * minRateFrac1;
                    continue;
                }
                if (rate == -1.0) {
                    minRates[rup] = minRate * minRateFrac1;
                    aPrioriRates[rup].setValue(0.0);
                    continue;
                }
                if (rate == -2.0) {
                    minRates[rup] = minRate * minRateFrac2;
                    aPrioriRates[rup].setValue(0.0);
                    continue;
                }
                throw new RuntimeException("Problem with a-priori rates for fault " + segmentData.getFaultName());
            }
            A_FaultSegmentedSourceGenerator aFaultSourceGenerator = new A_FaultSegmentedSourceGenerator(segmentData, this.ucerf2.getMagAreaRelationship(), slipModel, aPrioriRates, magSigma, magTruncLevel, totMoRateReduction, meanMagCorrection, minRates, wtedInversion, relativeSegRateWeight, relativeA_PrioriWeight);
            ArrayList<FaultRuptureSource> sources = new ArrayList<FaultRuptureSource>();
            if (probModel.equals("Poisson")) {
                sources.addAll(aFaultSourceGenerator.getTimeIndependentSources(duration));
            } else if (probModel.equals("BPT")) {
                sources.addAll(aFaultSourceGenerator.getTimeDependentSources(duration, startYear, aperiodicity, isSegDependentAperiodicity));
            } else {
                sources.addAll(aFaultSourceGenerator.getTimeDepEmpiricalSources(duration, this.empiricalModel));
            }
            String faultName = segmentData.getFaultName();
            for (int srcIndex = 0; srcIndex < sources.size(); ++srcIndex) {
                FaultRuptureSource source = (FaultRuptureSource)sources.get(srcIndex);
                String key = faultName + ";" + source.getName();
                if (!this.sourceMFDMapping.containsKey(key)) {
                    this.sourceMFDMapping.put(key, new SummedMagFreqDist(5.05, 8.95, UCERF2.NUM_MAG));
                    this.sourceRakeMapping.put(key, aFaultSourceGenerator.getAveRakeForSource(srcIndex));
                    this.sourceGriddedSurfaceMapping.put(key, aFaultSourceGenerator.getCombinedGriddedSurfaceForSource(srcIndex, ddwCorr));
                }
                SummedMagFreqDist mfd = this.sourceMFDMapping.get(key);
                int numRups = source.getNumRuptures();
                for (int rupIndex = 0; rupIndex < numRups; ++rupIndex) {
                    ProbEqkRupture rupture = source.getRupture(rupIndex);
                    mfd.add(rupture.getMag(), rupture.getMeanAnnualRate(duration) * weight);
                }
            }
        }
    }

    private void fillAdjustableParamsForA_Faults() {
        if (this.ucerf2.getAdjustableParameterList().containsParameter("Seg Dependent Aperiodicity")) {
            this.ucerf2.getParameter("Seg Dependent Aperiodicity").setValue(new Boolean(false));
        }
        this.aFaultsBranchParamNames = new ArrayList();
        this.aFaultsBranchParamValues = new ArrayList();
        this.aFaultsBranchParamNames.add("Deformation Model");
        ParamOptions options = new ParamOptions();
        options.addValueWeight("D2.1", 0.5);
        options.addValueWeight("D2.2", 0.2);
        options.addValueWeight("D2.3", 0.3);
        this.aFaultsBranchParamValues.add(options);
        this.aFaultsBranchParamNames.add("Mag-Area Relationship");
        options = new ParamOptions();
        options.addValueWeight("Ellsworth-B (WGCEP, 2002, Eq 4.5b)", 0.5);
        options.addValueWeight("Hanks & Bakun (2002)", 0.5);
        this.aFaultsBranchParamValues.add(options);
        this.aFaultsBranchParamNames.add("A-Fault Solution Type");
        options = new ParamOptions();
        options.addValueWeight("Segmented Model", 0.9);
        this.aFaultsBranchParamValues.add(options);
        this.aFaultsBranchParamNames.add("Wt On A-Priori Rates");
        options = new ParamOptions();
        options.addValueWeight(new Double(1.0E-4), 0.5);
        options.addValueWeight(new Double(1.0E10), 0.5);
        this.aFaultsBranchParamValues.add(options);
        this.aFaultsBranchParamNames.add("Probability Model");
        options = new ParamOptions();
        String probModel = (String)this.probModelParam.getValue();
        if (probModel.equals("BPT")) {
            options.addValueWeight("BPT", 1.0);
        } else if (probModel.equals("Poisson")) {
            options.addValueWeight("Poisson", 1.0);
        } else if (probModel.equals("Empirical")) {
            options.addValueWeight("Empirical", 1.0);
        } else if (probModel.equals("WGCEP Preferred Blend")) {
            options.addValueWeight("BPT", 0.7);
            options.addValueWeight("Empirical", 0.3);
        }
        this.aFaultsBranchParamValues.add(options);
        this.aFaultsBranchParamNames.add("Aperiodicity");
        options = new ParamOptions();
        options.addValueWeight(new Double(0.3), 0.2);
        options.addValueWeight(new Double(0.5), 0.5);
        options.addValueWeight(new Double(0.7), 0.3);
        this.aFaultsBranchParamValues.add(options);
        this.lastParamIndex = this.aFaultsBranchParamNames.size() - 1;
    }

    private void mkB_FaultSources() {
        A_FaultsFetcher aFaultsFetcher = this.ucerf2.getA_FaultsFetcher();
        B_FaultsFetcherForMeanUCERF bFaultsFetcher = new B_FaultsFetcherForMeanUCERF(aFaultsFetcher, true);
        this.bFaultSources = new ArrayList();
        double rupOffset = (Double)this.rupOffsetParam.getValue();
        double empiricalModelWt = 0.0;
        String probModel = (String)this.probModelParam.getValue();
        if (probModel.equals("BPT") || probModel.equals("Poisson")) {
            empiricalModelWt = 0.0;
        } else if (probModel.equals("Empirical")) {
            empiricalModelWt = 1.0;
        } else if (probModel.equals("WGCEP Preferred Blend")) {
            empiricalModelWt = 0.3;
        }
        double duration = this.timeSpan.getDuration();
        double wt = 0.5;
        boolean ddwCorr = (Boolean)this.cybershakeDDW_CorrParam.getValue();
        int floaterType = this.getFloaterType();
        ArrayList<FaultSegmentData> faultSegDataList = bFaultsFetcher.getB_FaultsCommonConnOpts();
        this.addToB_FaultSources(rupOffset, empiricalModelWt, duration, wt, faultSegDataList, ddwCorr, floaterType);
        wt = 1.0;
        faultSegDataList = bFaultsFetcher.getB_FaultsCommonNoConnOpts();
        this.addToB_FaultSources(rupOffset, empiricalModelWt, duration, wt, faultSegDataList, ddwCorr, floaterType);
        wt = 0.25;
        faultSegDataList = bFaultsFetcher.getB_FaultsUniqueToF2_1ConnOpts();
        this.addToB_FaultSources(rupOffset, empiricalModelWt, duration, wt, faultSegDataList, ddwCorr, floaterType);
        wt = 0.5;
        faultSegDataList = bFaultsFetcher.getB_FaultsUniqueToF2_1NoConnOpts();
        this.addToB_FaultSources(rupOffset, empiricalModelWt, duration, wt, faultSegDataList, ddwCorr, floaterType);
        wt = 0.25;
        faultSegDataList = bFaultsFetcher.getB_FaultsUniqueToF2_2ConnOpts();
        this.addToB_FaultSources(rupOffset, empiricalModelWt, duration, wt, faultSegDataList, ddwCorr, floaterType);
        wt = 0.5;
        faultSegDataList = bFaultsFetcher.getB_FaultsUniqueToF2_2NoConnOpts();
        this.addToB_FaultSources(rupOffset, empiricalModelWt, duration, wt, faultSegDataList, ddwCorr, floaterType);
        wt = 0.75;
        faultSegDataList = bFaultsFetcher.getB_FaultsCommonWithUniqueConnOpts();
        this.addToB_FaultSources(rupOffset, empiricalModelWt, duration, wt, faultSegDataList, ddwCorr, floaterType);
        if (this.calcSummedMFDs) {
            this.bFaultSummedMFD = new SummedMagFreqDist(5.05, 8.95, UCERF2.NUM_MAG);
        }
        for (int srcIndex = 0; srcIndex < this.bFaultSources.size(); ++srcIndex) {
            UnsegmentedSource source = this.bFaultSources.get(srcIndex);
            if (!this.calcSummedMFDs) continue;
            int numRups = source.getNumRuptures();
            for (int rupIndex = 0; rupIndex < numRups; ++rupIndex) {
                ProbEqkRupture rup = source.getRupture(rupIndex);
                double mag = rup.getMag();
                double rate = rup.getMeanAnnualRate(duration);
                this.bFaultSummedMFD.add(mag, rate);
            }
        }
    }

    private void addToB_FaultSources(double rupOffset, double empiricalModelWt, double duration, double wt, ArrayList<FaultSegmentData> faultSegDataList, boolean ddwCorr, int floaterType) {
        for (int i = 0; i < faultSegDataList.size(); ++i) {
            if (faultSegDataList.get(i).getFaultName().equalsIgnoreCase("Mendocino")) continue;
            this.bFaultSources.add(new UnsegmentedSource(faultSegDataList.get(i), this.empiricalModel, rupOffset, wt, empiricalModelWt, duration, ddwCorr, floaterType, Double.NaN));
        }
    }

    private void mkNonCA_B_FaultSources() {
        double magSigma = UCERF2.MAG_SIGMA_DEFAULT;
        double magTruncLevel = UCERF2.TRUNC_LEVEL_DEFAULT;
        double duration = this.timeSpan.getDuration();
        double rupOffset = (Double)this.rupOffsetParam.getValue();
        EmpiricalModel empiricalModel = null;
        if (((String)this.probModelParam.getValue()).equals("Empirical")) {
            empiricalModel = this.empiricalModel;
        }
        this.nonCA_bFaultSources = this.nonCA_B_Faultsfetcher.getSources("org/opensha/sha/earthquake/rupForecastImpl/WGCEP_UCERF_2_Final/data/NearCA_NSHMP/NonCA_Faults.txt", duration, magSigma, magTruncLevel, rupOffset, empiricalModel);
    }

    private void setTimespanParameter() {
        if (((String)this.probModelParam.getValue()).equals("BPT") || ((String)this.probModelParam.getValue()).equals("WGCEP Preferred Blend")) {
            this.timeSpan = new TimeSpan("Years", "Years");
            this.timeSpan.setDuractionConstraint(1.0, 100.0);
            this.timeSpan.setDuration(30.0);
            this.timeSpan.setStartTimeConstraint("Start Year", 2007, 2107);
            this.timeSpan.setStartTime(2007);
            this.timeSpan.addParameterChangeListener(this);
        } else {
            this.timeSpan = new TimeSpan("None", "Years");
            this.timeSpan.setDuration(30.0);
            this.timeSpan.addParameterChangeListener(this);
        }
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        super.parameterChange(event);
        String paramName = event.getParameterName();
        if (!paramName.equalsIgnoreCase(RUP_OFFSET_PARAM_NAME)) {
            if (paramName.equalsIgnoreCase("Probability Model")) {
                this.createParamList();
                this.setTimespanParameter();
                this.timeSpanChange(new EventObject(this.timeSpan));
            } else if (paramName.equalsIgnoreCase(UCERF2.BACK_SEIS_NAME)) {
                this.createParamList();
            } else if (paramName.equalsIgnoreCase(UCERF2.BACK_SEIS_RUP_NAME)) {
                // empty if block
            }
        }
        this.parameterChangeFlag = true;
    }

    @Override
    public void timeSpanChange(EventObject event) {
        this.parameterChangeFlag = true;
    }

    public void writeB_FaultMgt67probs() {
        for (int isrc = 0; isrc < this.bFaultSources.size(); ++isrc) {
            UnsegmentedSource source = this.bFaultSources.get(isrc);
            System.out.println(source.getName() + "\t" + source.computeTotalProbAbove(6.7));
        }
    }

    public void writeFaultSourceSurfaceOutlines() {
        ArrayList<ProbEqkSource> allFltSources = new ArrayList<ProbEqkSource>();
        allFltSources.addAll(this.aFaultSegmentedSources);
        allFltSources.addAll(this.aFaultUnsegmentedSources);
        allFltSources.addAll(this.bFaultSources);
        allFltSources.addAll(this.nonCA_bFaultSources);
        try {
            FileWriter fw = new FileWriter("meanUCERF2_FltSrcSurfOutln.txt");
            for (int isrc = 0; isrc < allFltSources.size(); ++isrc) {
                EqkSourceAPI source = (EqkSourceAPI)allFltSources.get(isrc);
                LocationList locList = source.getSourceSurface().getSurfacePerimeterLocsList();
                System.out.println("# " + source.getName());
                fw.write("# " + source.getName() + "\n");
                for (int i = 0; i < locList.size(); ++i) {
                    Location loc = locList.getLocationAt(i);
                    fw.write((float)loc.getLatitude() + "\t" + (float)loc.getLongitude() + "\t" + (float)loc.getDepth() + "\n");
                }
            }
            fw.close();
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testFinalMeanUCERF2() {
        MeanUCERF2 meanFinalUCERF2 = new MeanUCERF2();
        meanFinalUCERF2.calcSummedMFDs = false;
        meanFinalUCERF2.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_EXCLUDE);
        meanFinalUCERF2.updateForecast();
        org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.MeanUCERF2.MeanUCERF2 oldMeanUCERF2 = new org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.MeanUCERF2.MeanUCERF2();
        oldMeanUCERF2.calcSummedMFDs = false;
        oldMeanUCERF2.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_EXCLUDE);
        oldMeanUCERF2.updateForecast();
        System.out.println("OLD numSrc =" + oldMeanUCERF2.getNumSources());
        System.out.println("NEW numSrc =" + meanFinalUCERF2.getNumSources());
        int numSrc = oldMeanUCERF2.getNumSources();
        for (int i = 0; i < numSrc; ++i) {
            System.out.println("src " + i);
            int numRup = oldMeanUCERF2.getNumRuptures(i);
            if (numRup != meanFinalUCERF2.getNumRuptures(i)) {
                System.out.println("Error: Number of ruptures differs for source " + i);
            }
            for (int r = 0; r < numRup; ++r) {
                ProbEqkRupture oldRup = oldMeanUCERF2.getRupture(i, r);
                ProbEqkRupture newRup = meanFinalUCERF2.getRupture(i, r);
                double fractDiff = Math.abs((oldRup.getProbability() - newRup.getProbability()) / newRup.getProbability());
                if (!(fractDiff > 0.01)) continue;
                System.out.println("DIFFERENCE: " + fractDiff + " at src " + i + " and rup " + r);
            }
        }
    }

    public void testResortedSources() {
        MeanUCERF2 meanFinalUCERF2 = new MeanUCERF2();
        meanFinalUCERF2.calcSummedMFDs = false;
        meanFinalUCERF2.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_EXCLUDE);
        meanFinalUCERF2.updateForecast();
        org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.MeanUCERF2.MeanUCERF2 oldMeanUCERF2 = new org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.MeanUCERF2.MeanUCERF2();
        oldMeanUCERF2.calcSummedMFDs = false;
        oldMeanUCERF2.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_EXCLUDE);
        oldMeanUCERF2.updateForecast();
        System.out.println("OLD numSrc =" + oldMeanUCERF2.getNumSources());
        System.out.println("NEW numSrc =" + meanFinalUCERF2.getNumSources());
        int numSrc = oldMeanUCERF2.getNumSources();
        double totRateOld = 0.0;
        double totRateNew = 0.0;
        for (int i = 0; i < numSrc; ++i) {
            int r;
            System.out.println("src " + i);
            for (r = 0; r < oldMeanUCERF2.getNumRuptures(i); ++r) {
                totRateOld += oldMeanUCERF2.getRupture(i, r).getMeanAnnualRate(30.0);
            }
            for (r = 0; r < meanFinalUCERF2.getNumRuptures(i); ++r) {
                totRateNew += meanFinalUCERF2.getRupture(i, r).getMeanAnnualRate(30.0);
            }
        }
        System.out.println("OLD tot rate =" + totRateOld);
        System.out.println("NEW tot rate =" + totRateNew);
    }

    public static void main(String[] args) {
        MeanUCERF2 meanFinalUCERF2 = new MeanUCERF2();
        meanFinalUCERF2.calcSummedMFDs = false;
        meanFinalUCERF2.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_EXCLUDE);
        meanFinalUCERF2.updateForecast();
    }
}

