/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.opensha.commons.calc.RelativeLocation;
import org.opensha.commons.data.Direction;
import org.opensha.commons.data.Location;
import org.opensha.commons.exceptions.FaultException;
import org.opensha.sha.faultSurface.EvenlyGriddedSurfFromSimpleFaultData;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.SimpleFaultData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StirlingGriddedSurface
extends EvenlyGriddedSurfFromSimpleFaultData {
    protected static final String C = "StirlingGriddedSurface";
    protected static final boolean D = false;
    protected double aveDipDir = Double.NaN;
    protected static final double PI_RADIANS = Math.PI / 180;
    protected static final String ERR = " is null, unable to process.";

    public StirlingGriddedSurface(SimpleFaultData simpleFaultData, double gridSpacing) throws FaultException {
        super(simpleFaultData, gridSpacing);
        this.createEvenlyGriddedSurface();
    }

    public StirlingGriddedSurface(ArrayList<SimpleFaultData> simpleFaultData, double gridSpacing) throws FaultException {
        super(simpleFaultData, gridSpacing);
        this.createEvenlyGriddedSurface();
    }

    public StirlingGriddedSurface(FaultTrace faultTrace, double aveDip, double upperSeismogenicDepth, double lowerSeismogenicDepth, double gridSpacing) throws FaultException {
        super(faultTrace, aveDip, upperSeismogenicDepth, lowerSeismogenicDepth, gridSpacing);
        this.createEvenlyGriddedSurface();
    }

    public StirlingGriddedSurface(SimpleFaultData simpleFaultData, double gridSpacing, double aveDipDir) throws FaultException {
        super(simpleFaultData, gridSpacing);
        this.aveDipDir = aveDipDir;
        this.createEvenlyGriddedSurface();
    }

    public StirlingGriddedSurface(FaultTrace faultTrace, double aveDip, double upperSeismogenicDepth, double lowerSeismogenicDepth, double gridSpacing, double aveDipDir) throws FaultException {
        super(faultTrace, aveDip, upperSeismogenicDepth, lowerSeismogenicDepth, gridSpacing);
        this.aveDipDir = aveDipDir;
        this.createEvenlyGriddedSurface();
    }

    private void createEvenlyGriddedSurface() throws FaultException {
        double aveDipDirection;
        Location lastLoc;
        Location firstLoc;
        String S = "StirlingGriddedSurface: createEvenlyGriddedSurface():";
        this.assertValidData();
        int numSegments = this.faultTrace.getNumLocations() - 1;
        double avDipRadians = this.aveDip * (Math.PI / 180);
        double gridSpacingCosAveDipRadians = this.gridSpacing * Math.cos(avDipRadians);
        double gridSpacingSinAveDipRadians = this.gridSpacing * Math.sin(avDipRadians);
        double[] segmentLenth = new double[numSegments];
        double[] segmentAzimuth = new double[numSegments];
        double[] segmentCumLenth = new double[numSegments];
        double cumDistance = 0.0;
        int i = 0;
        if (Double.isNaN(this.aveDipDir)) {
            firstLoc = this.faultTrace.getLocationAt(0);
            lastLoc = this.faultTrace.getLocationAt(this.faultTrace.getNumLocations() - 1);
            Direction aveDir = RelativeLocation.getDirection(firstLoc, lastLoc);
            aveDipDirection = aveDir.getAzimuth() + 90.0;
        } else {
            aveDipDirection = this.aveDipDir;
        }
        Iterator<Location> it = this.faultTrace.iterator();
        lastLoc = firstLoc = it.next();
        Location loc = null;
        Direction dir = null;
        while (it.hasNext()) {
            loc = it.next();
            dir = RelativeLocation.getDirection(lastLoc, loc);
            double azimuth = dir.getAzimuth();
            double distance = dir.getHorzDistance();
            segmentLenth[i] = distance;
            segmentAzimuth[i] = azimuth;
            segmentCumLenth[i] = cumDistance += distance;
            ++i;
            lastLoc = loc;
        }
        double downDipWidth = (this.lowerSeismogenicDepth - this.upperSeismogenicDepth) / Math.sin(avDipRadians);
        int rows = 1 + Math.round((float)(downDipWidth / this.gridSpacing));
        int cols = 1 + Math.round((float)(segmentCumLenth[numSegments - 1] / this.gridSpacing));
        this.setNumRowsAndNumCols(rows, cols);
        for (int ith_col = 0; ith_col < cols; ++ith_col) {
            Location topLocation;
            double hDistance;
            double vDistance;
            int segmentNumber;
            double distanceAlong = (double)ith_col * this.gridSpacing;
            for (segmentNumber = 1; segmentNumber <= numSegments && distanceAlong > segmentCumLenth[segmentNumber - 1]; ++segmentNumber) {
            }
            if (segmentNumber == numSegments + 1) {
                --segmentNumber;
            }
            double distance = segmentNumber > 1 ? distanceAlong - segmentCumLenth[segmentNumber - 2] : distanceAlong;
            Location location1 = this.faultTrace.getLocationAt(segmentNumber - 1);
            Location traceLocation = RelativeLocation.getLocation(location1, dir = new Direction(0.0, distance, segmentAzimuth[segmentNumber - 1], 0.0));
            if (traceLocation.getDepth() < this.upperSeismogenicDepth) {
                vDistance = this.upperSeismogenicDepth - traceLocation.getDepth();
                hDistance = vDistance / Math.tan(avDipRadians);
                dir = new Direction(vDistance, hDistance, aveDipDirection, 0.0);
                topLocation = RelativeLocation.getLocation(traceLocation, dir);
            } else {
                topLocation = traceLocation;
            }
            this.setLocation(0, ith_col, topLocation.copy());
            for (int ith_row = 1; ith_row < rows; ++ith_row) {
                hDistance = (double)ith_row * gridSpacingCosAveDipRadians;
                vDistance = (double)ith_row * gridSpacingSinAveDipRadians;
                dir = new Direction(vDistance, hDistance, aveDipDirection, 0.0);
                Location depthLocation = RelativeLocation.getLocation(topLocation, dir);
                this.setLocation(ith_row, ith_col, depthLocation.copy());
            }
        }
    }

    public static void main(String[] args) {
        double aveDip = 30.0;
        double upperSeismogenicDepth = 5.0;
        double lowerSeismogenicDepth = 15.0;
        double gridSpacing = 5.0;
        FaultTrace faultTrace = new FaultTrace("Test");
        faultTrace.addLocation(new Location(20.0, -120.0, 0.0));
        faultTrace.addLocation(new Location(20.2, -120.0, 0.0));
        StirlingGriddedSurface griddedSurface = new StirlingGriddedSurface(faultTrace, aveDip, upperSeismogenicDepth, lowerSeismogenicDepth, gridSpacing);
        System.out.println("******Fault Trace*********");
        System.out.println(faultTrace);
        ListIterator it = griddedSurface.getLocationsIterator();
        System.out.println("*******Evenly Gridded Surface************");
        while (it.hasNext()) {
            Location loc = (Location)it.next();
            System.out.println(loc.getLatitude() + "," + loc.getLongitude() + "," + loc.getDepth());
        }
    }
}

