/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.opensha.commons.calc.GaussianDistCalc;
import org.opensha.commons.data.DataPoint2D;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFuncAPI;
import org.opensha.commons.exceptions.IMRException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.DependentParameter;
import org.opensha.commons.param.ParameterAPI;
import org.opensha.commons.param.ParameterList;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.rupForecastImpl.PointEqkSource;
import org.opensha.sha.imr.IntensityMeasureRelationship;
import org.opensha.sha.imr.ScalarIntensityMeasureRelationshipAPI;
import org.opensha.sha.imr.param.EqkRuptureParams.AftershockParam;
import org.opensha.sha.imr.param.EqkRuptureParams.DipParam;
import org.opensha.sha.imr.param.EqkRuptureParams.FaultTypeParam;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.EqkRuptureParams.RakeParam;
import org.opensha.sha.imr.param.EqkRuptureParams.RupTopDepthParam;
import org.opensha.sha.imr.param.EqkRuptureParams.RupWidthParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGD_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGV_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.OtherParams.SigmaTruncLevelParam;
import org.opensha.sha.imr.param.OtherParams.SigmaTruncTypeParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;
import org.opensha.sha.imr.param.OtherParams.TectonicRegionTypeParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistRupMinusDistX_OverRupParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistRupMinusJB_OverRupParameter;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceJBParameter;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceRupParameter;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceSeisParameter;
import org.opensha.sha.imr.param.PropagationEffectParams.HangingWallFlagParam;
import org.opensha.sha.imr.param.SiteParams.DepthTo1pt0kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.DepthTo2pt5kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;
import org.opensha.sha.imr.param.SiteParams.Vs30_TypeParam;

public abstract class AttenuationRelationship
extends IntensityMeasureRelationship
implements ScalarIntensityMeasureRelationshipAPI {
    public static final String C = "AttenuationRelationship";
    protected static final boolean D = false;
    protected PGA_Param pgaParam = null;
    protected PGV_Param pgvParam = null;
    protected PGD_Param pgdParam = null;
    protected SA_Param saParam = null;
    protected PeriodParam saPeriodParam = null;
    protected DampingParam saDampingParam = null;
    protected StdDevTypeParam stdDevTypeParam = null;
    protected SigmaTruncTypeParam sigmaTruncTypeParam = null;
    protected SigmaTruncLevelParam sigmaTruncLevelParam = null;
    protected ComponentParam componentParam = null;
    protected TectonicRegionTypeParam tectonicRegionTypeParam = null;
    protected MagParam magParam = null;
    protected FaultTypeParam fltTypeParam = null;
    protected AftershockParam aftershockParam = null;
    protected RakeParam rakeParam = null;
    protected DipParam dipParam = null;
    protected RupTopDepthParam rupTopDepthParam = null;
    protected RupWidthParam rupWidthParam;
    protected DistanceRupParameter distanceRupParam = null;
    protected DistanceJBParameter distanceJBParam = null;
    protected DistanceSeisParameter distanceSeisParam = null;
    protected DistRupMinusJB_OverRupParameter distRupMinusJB_OverRupParam = null;
    protected DistRupMinusDistX_OverRupParam distRupMinusDistX_OverRupParam = null;
    protected HangingWallFlagParam hangingWallFlagParam = null;
    protected Vs30_Param vs30Param = null;
    protected Vs30_TypeParam vs30_TypeParam;
    protected DepthTo2pt5kmPerSecParam depthTo2pt5kmPerSecParam = null;
    protected DepthTo1pt0kmPerSecParam depthTo1pt0kmPerSecParam;
    protected double USER_MAX_DISTANCE = Double.MAX_VALUE;
    protected static final double VERY_SMALL_MEAN = -35.0;
    protected static final String ERR = "Not all parameters have been set";
    protected ParameterList meanIndependentParams = new ParameterList();
    protected ParameterList stdDevIndependentParams = new ParameterList();
    protected ParameterList exceedProbIndependentParams = new ParameterList();
    protected ParameterList imlAtExceedProbIndependentParams = new ParameterList();

    public void setUserMaxDistance(double maxDist) {
        this.USER_MAX_DISTANCE = maxDist;
    }

    public void setIntensityMeasureLevel(Object iml) throws ParameterException {
        if (!(iml instanceof Double)) {
            throw new ParameterException("AttenuationRelationship: setIntensityMeasureLevel(): Object not a DoubleParameter, unable to set.");
        }
        this.setIntensityMeasureLevel((Double)iml);
    }

    public void setIntensityMeasureLevel(Double iml) throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("AttenuationRelationship: setIntensityMeasureLevel(): Intensity Measure is null, unable to set.");
        }
        this.im.setValue(iml);
    }

    public void setSiteLocation(Location loc) {
        if (this.site == null) {
            this.site = new Site();
        }
        this.site.setLocation(loc);
        this.setPropagationEffectParams();
    }

    protected abstract void setPropagationEffectParams();

    public double getExceedProbability() throws ParameterException, IMRException {
        double iml = (Double)this.im.getValue();
        double stdDev = this.getStdDev();
        double mean = this.getMean();
        return this.getExceedProbability(mean, stdDev, iml);
    }

    public double getExceedProbability(double iml) throws ParameterException, IMRException {
        this.im.setValue(new Double(iml));
        return this.getExceedProbability();
    }

    public DiscretizedFuncAPI getSA_ExceedProbSpectrum(double iml) throws ParameterException, IMRException {
        this.setIntensityMeasure("SA");
        this.im.setValue(new Double(iml));
        ArbitrarilyDiscretizedFunc exeedProbFunction = new ArbitrarilyDiscretizedFunc();
        ArrayList allowedSA_Periods = this.saPeriodParam.getAllowedDoubles();
        int size = allowedSA_Periods.size();
        for (int i = 0; i < size; ++i) {
            Double saPeriod = (Double)allowedSA_Periods.get(i);
            this.getParameter("SA Period").setValue(saPeriod);
            exeedProbFunction.set(saPeriod, this.getExceedProbability());
        }
        return exeedProbFunction;
    }

    public DiscretizedFuncAPI getSA_IML_AtExceedProbSpectrum(double exceedProb) throws ParameterException, IMRException {
        this.setIntensityMeasure("SA");
        this.exceedProbParam.setValue(exceedProb);
        ArbitrarilyDiscretizedFunc imlFunction = new ArbitrarilyDiscretizedFunc();
        ArrayList allowedSA_Periods = this.saPeriodParam.getAllowedDoubles();
        int size = allowedSA_Periods.size();
        for (int i = 0; i < size; ++i) {
            Double saPeriod = (Double)allowedSA_Periods.get(i);
            this.getParameter("SA Period").setValue(saPeriod);
            imlFunction.set(saPeriod, this.getIML_AtExceedProb());
        }
        return imlFunction;
    }

    public double getEpsilon() {
        double iml = (Double)this.im.getValue();
        return (iml - this.getMean()) / this.getStdDev();
    }

    public double getEpsilon(double iml) {
        this.im.setValue(new Double(iml));
        return this.getEpsilon();
    }

    protected double getExceedProbability(double mean, double stdDev, double iml) throws ParameterException, IMRException {
        if (stdDev != 0.0) {
            double stRndVar = (iml - mean) / stdDev;
            if (((String)this.sigmaTruncTypeParam.getValue()).equals("None")) {
                return GaussianDistCalc.getExceedProb(stRndVar);
            }
            double numSig = (Double)this.sigmaTruncLevelParam.getValue();
            if (((String)this.sigmaTruncTypeParam.getValue()).equals("1 Sided")) {
                return GaussianDistCalc.getExceedProb(stRndVar, 1, numSig);
            }
            return GaussianDistCalc.getExceedProb(stRndVar, 2, numSig);
        }
        if (iml > mean) {
            return 0.0;
        }
        return 1.0;
    }

    public DiscretizedFuncAPI getExceedProbabilities(DiscretizedFuncAPI intensityMeasureLevels) throws ParameterException {
        double stdDev = this.getStdDev();
        double mean = this.getMean();
        Iterator<DataPoint2D> it = intensityMeasureLevels.getPointsIterator();
        while (it.hasNext()) {
            DataPoint2D point = it.next();
            point.setY(this.getExceedProbability(mean, stdDev, point.getX()));
        }
        return intensityMeasureLevels;
    }

    public double getTotExceedProbability(PointEqkSource ptSrc, double iml) {
        double totProb = 1.0;
        this.im.setValue(new Double(iml));
        this.setEqkRupture(ptSrc.getRupture(0));
        for (int i = 0; i < ptSrc.getNumRuptures(); ++i) {
            ProbEqkRupture tempRup = ptSrc.getRupture(i);
            this.magParam.setValueIgnoreWarning(new Double(tempRup.getMag()));
            double qkProb = tempRup.getProbability();
            totProb *= Math.pow(1.0 - qkProb, this.getExceedProbability());
            double tt = this.getExceedProbability();
        }
        return 1.0 - totProb;
    }

    public double getIML_AtExceedProb() throws ParameterException {
        double stRndVar;
        if (this.exceedProbParam.getValue() == null) {
            throw new ParameterException("AttenuationRelationship: getExceedProbability(): exceedProbParam or its value is null, unable to run this calculation.");
        }
        double exceedProb = (Double)this.exceedProbParam.getValue();
        String sigTrType = (String)this.sigmaTruncTypeParam.getValue();
        if (!sigTrType.equals("1 Sided") && exceedProb == 0.5) {
            return this.getMean();
        }
        if (sigTrType.equals("None")) {
            stRndVar = GaussianDistCalc.getStandRandVar(exceedProb, 0, 0.0, 1.0E-6);
        } else {
            double numSig = (Double)this.sigmaTruncLevelParam.getValue();
            stRndVar = sigTrType.equals("1 Sided") ? GaussianDistCalc.getStandRandVar(exceedProb, 1, numSig, 1.0E-6) : GaussianDistCalc.getStandRandVar(exceedProb, 2, numSig, 1.0E-6);
        }
        return this.getMean() + stRndVar * this.getStdDev();
    }

    public double getIML_AtExceedProb(double exceedProb) throws ParameterException {
        this.exceedProbParam.setValue(exceedProb);
        return this.getIML_AtExceedProb();
    }

    public ListIterator getMeanIndependentParamsIterator() {
        return this.meanIndependentParams.getParametersIterator();
    }

    public ListIterator getStdDevIndependentParamsIterator() {
        return this.stdDevIndependentParams.getParametersIterator();
    }

    public ListIterator getExceedProbIndependentParamsIterator() {
        return this.exceedProbIndependentParams.getParametersIterator();
    }

    public ListIterator getIML_AtExceedProbIndependentParamsIterator() {
        return this.imlAtExceedProbIndependentParams.getParametersIterator();
    }

    public String getAllParamMetadata() {
        String metadata = this.imlAtExceedProbIndependentParams.getParameterListMetadataString();
        metadata = metadata + "; " + this.im.getMetadataString() + " [ ";
        ListIterator<ParameterAPI> it = ((DependentParameter)this.im).getIndependentParametersIterator();
        while (it.hasNext()) {
            metadata = metadata + ((ParameterAPI)it.next()).getMetadataString() + "; ";
        }
        metadata = metadata.substring(0, metadata.length() - 2);
        metadata = metadata + " ]";
        return metadata;
    }

    protected abstract void initSupportedIntensityMeasureParams();

    protected abstract void initSiteParams();

    protected abstract void initEqkRuptureParams();

    protected abstract void initPropagationEffectParams();

    protected void initOtherParams() {
        this.sigmaTruncTypeParam = new SigmaTruncTypeParam();
        this.sigmaTruncLevelParam = new SigmaTruncLevelParam();
        this.tectonicRegionTypeParam = new TectonicRegionTypeParam();
        this.otherParams.clear();
        this.otherParams.addParameter(this.sigmaTruncTypeParam);
        this.otherParams.addParameter(this.sigmaTruncLevelParam);
        this.otherParams.addParameter(this.tectonicRegionTypeParam);
    }

    protected void initParameterEventListeners() {
    }

    public void resetParameterEventListeners() {
    }

    public boolean isTectonicRegionSupported(String tectRegionName) {
        return this.tectonicRegionTypeParam.isAllowed(tectRegionName);
    }
}

