/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.magdist;

import org.opensha.commons.data.DataPoint2D;
import org.opensha.commons.exceptions.DataPoint2DException;
import org.opensha.commons.exceptions.DiscretizedFuncException;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.MagFreqDistException;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class TaperedGR_MagFreqDist
extends IncrementalMagFreqDist {
    public static String NAME = new String("Tapered GR Dist");
    private boolean D = false;
    private double magLower;
    private double magCorner;
    private double bValue;

    public TaperedGR_MagFreqDist(double min, int num, double delta) throws InvalidRangeException {
        super(min, num, delta);
        this.magLower = min;
    }

    public TaperedGR_MagFreqDist(double min, double max, int num) throws DiscretizedFuncException, InvalidRangeException {
        super(min, max, num);
    }

    public TaperedGR_MagFreqDist(double bValue, double totCumRate, double min, double max, int num) throws DiscretizedFuncException, InvalidRangeException {
        super(min, max, num);
        this.setAllButTotMoRate(min, max, totCumRate, bValue);
    }

    public TaperedGR_MagFreqDist(double min, int num, double delta, double magLower, double magCorner, double totMoRate, double bValue) throws InvalidRangeException, DataPoint2DException {
        super(min, num, delta);
        this.setAllButTotCumRate(magLower, magCorner, totMoRate, bValue);
    }

    public void setAllButTotCumRate(double magLower, double magCorner, double totMoRate, double bValue) throws DataPoint2DException {
        this.magLower = magLower;
        this.magCorner = magCorner;
        this.bValue = bValue;
        this.calculateRelativeRates();
        this.scaleToTotalMomentRate(totMoRate);
    }

    public void setAllButTotMoRate(double magLower, double magCorner, double totCumRate, double bValue) throws DataPoint2DException {
        this.magLower = magLower;
        this.magCorner = magCorner;
        this.bValue = bValue;
        this.calculateRelativeRates();
        this.scaleToCumRate(magLower, totCumRate);
    }

    public void setAllButCornerMag(double magLower, double totMoRate, double totCumRate, double bValue) throws MagFreqDistException, DiscretizedFuncException, DataPoint2DException {
        boolean success;
        this.magLower = magLower;
        this.bValue = bValue;
        double deltaMag = 1.0;
        double magStart = magLower;
        block0: for (int loop = 0; loop < 5; ++loop) {
            for (double mag = magStart; mag <= this.maxX + deltaMag; mag += deltaMag) {
                this.setAllButTotMoRate(magLower, mag, totCumRate, bValue);
                if (!(this.getTotalMomentRate() > totMoRate)) continue;
                magStart = mag - deltaMag;
                if (magStart < magLower) {
                    throw new RuntimeException(NAME + ": Error - could not find corner magnitude that satisfies the moment rate (magLower too high?).");
                }
                deltaMag /= 10.0;
                continue block0;
            }
        }
        this.magCorner = magStart;
        this.setAllButTotMoRate(magLower, this.magCorner, totCumRate, bValue);
        double moRateBelow = this.getTotalMomentRate();
        this.magCorner = magStart + 1.0E-4;
        this.setAllButTotMoRate(magLower, this.magCorner, totCumRate, bValue);
        boolean bl = success = this.getTotalMomentRate() >= totMoRate && moRateBelow < totMoRate;
        if (!success) {
            throw new RuntimeException(NAME + ": Error - could not find corner magnitude that satisfies the moment rate (maxX too low?).");
        }
        if (this.D) {
            System.out.println("magLower = " + magLower);
            System.out.println("magCorner = " + this.magCorner);
            System.out.println("Orig totMoRate = " + totMoRate);
            System.out.println("Final totMoRate = " + this.getTotalMomentRate());
            System.out.println("Final/Orig totMoRate = " + this.getTotalMomentRate() / totMoRate + " (should be just greater than one)");
            System.out.println("totCumRate = " + this.getTotCumRate());
            System.out.println("bValue = " + bValue);
        }
    }

    public static void main(String[] args) {
        TaperedGR_MagFreqDist tgr = new TaperedGR_MagFreqDist(0.0, 201, 0.05);
        tgr.setAllButCornerMag(5.0, 1.0E19, 5.0, 1.0);
    }

    public void set(DataPoint2D point) throws MagFreqDistException {
        throw new MagFreqDistException("Cannot Access the set function of the GutenbergRichterMagFreqDist from outside this class");
    }

    public void set(double x, double y) throws MagFreqDistException {
        throw new MagFreqDistException("Cannot Access the set function of the GutenbergRichterMagFreqDist from outside this class");
    }

    public void set(int index, double y) throws MagFreqDistException {
        throw new MagFreqDistException("Cannot Access the set function of the GutenbergRichterMagFreqDist from outside this class");
    }

    private void calculateRelativeRates() throws DataPoint2DException {
        int i;
        if (this.magLower < this.minX || this.magLower > this.maxX) {
            throw new DataPoint2DException("magLower should lie between minX and maxX");
        }
        if (this.magLower > this.magCorner) {
            throw new InvalidRangeException("magLower must be < magCorner");
        }
        int indexLow = this.getXIndex(this.magLower);
        double[] cumRate = new double[this.num + 1];
        for (i = 0; i < cumRate.length; ++i) {
            double mag = (double)i * this.delta + this.minX - this.delta / 2.0;
            cumRate[i] = Math.pow(10.0, -this.bValue * mag) * Math.exp(-Math.pow(10.0, 1.5 * (mag - this.magCorner)));
        }
        for (i = 0; i < cumRate.length - 1; ++i) {
            super.set(i, cumRate[i] - cumRate[i + 1]);
        }
        for (i = 0; i < indexLow; ++i) {
            super.set(i, 0.0);
        }
    }

    public double getTotCumRate() throws DataPoint2DException {
        return this.getCumRate(this.magLower);
    }

    public double get_bValue() {
        return this.bValue;
    }

    public double getMagLower() {
        return this.magLower;
    }

    public double getmagCorner() {
        return this.magCorner;
    }

    public String getDefaultName() {
        return NAME;
    }

    public String getDefaultInfo() throws DataPoint2DException {
        return "minMag=" + this.minX + "; maxMag=" + this.maxX + "; numMag=" + this.num + "; bValue=" + this.bValue + "; magLower=" + this.magLower + "; magCorner=" + (float)this.magCorner + "; totMoRate=" + (float)this.getTotalMomentRate() + "; totCumRate=" + (float)this.getCumRate(this.magLower);
    }
}

