/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TectonicRegionType {
    ACTIVE_SHALLOW("Active Shallow Crust"),
    STABLE_SHALLOW("Stable Shallow Crust"),
    SUBDUCTION_INTERFACE("Subduction Interface"),
    SUBDUCTION_SLAB("Subduction IntraSlab"),
    VOLCANIC("Volcanic");

    private String name;

    private TectonicRegionType(String name) {
        this.name = name;
    }

    public static TectonicRegionType getTypeForName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        for (TectonicRegionType trt : TectonicRegionType.values()) {
            if (!trt.name.equals(name)) continue;
            return trt;
        }
        throw new IllegalArgumentException("TectonicRegionType name does not exist");
    }

    public static boolean isValidType(String name) {
        boolean answer = false;
        for (TectonicRegionType trt : TectonicRegionType.values()) {
            if (!trt.name.equals(name)) continue;
            answer = true;
        }
        return answer;
    }

    public String toString() {
        return this.name;
    }

    public static void main(String[] args) {
        System.out.println(TectonicRegionType.isValidType("Active Shallow Crust"));
    }
}

