/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.step.calc;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.earthquake.griddedForecast.HypoMagFreqDistAtLoc;
import org.opensha.sha.earthquake.griddedForecast.STEP_CombineForecastModels;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.step.calc.BackGroundRatesGrid;
import org.opensha.step.calc.RegionDefaults;
import org.opensha.step.calc.UpdateSTEP_Forecast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyCoulombFilter {
    public void applyFilter(BackGroundRatesGrid bggrid, UpdateSTEP_Forecast updateModel, ArrayList<STEP_CombineForecastModels> STEP_AftershockForecastList) {
        int numForecastMags;
        HypoMagFreqDistAtLoc bgDistAtLoc;
        DecimalFormat locFormat = new DecimalFormat("0.0000");
        DecimalFormat magFormat = new DecimalFormat("0.00");
        double DEPTH = 0.0;
        double sumRatesBlue = 0.0;
        double sumRatesRed = 0.0;
        double totalR = 0.0;
        ArrayList<String> coulombFileLines = null;
        LocationList bgLocList = bggrid.getRegion().getNodeList();
        int bgRegionSize = bgLocList.size();
        double[] cumBGList = new double[bgRegionSize];
        int[] cfs = new int[bgRegionSize];
        int numAftershockModels = STEP_AftershockForecastList.size();
        for (int modelLoop = 0; modelLoop < numAftershockModels; ++modelLoop) {
            STEP_CombineForecastModels forecastModel = STEP_AftershockForecastList.get(modelLoop);
            if (!(forecastModel.getMainShock().getMag() > RegionDefaults.minCoulombMS_Mag)) continue;
            LocationList gridLocs = forecastModel.getAfterShockZone().getNodeList();
            double[] distanceFromFault = forecastModel.getGridDistanceFromFault();
            double numAS_Locs = forecastModel.getAfterShockZone().getNodeCount();
            for (int k = 0; k < bgRegionSize; ++k) {
                bgDistAtLoc = bggrid.getHypoMagFreqDistAtLoc(k);
                cumBGList[k] = bgDistAtLoc.getFirstMagFreqDist().getCumRate(RegionDefaults.minForecastMag);
            }
            try {
                System.out.println("load Coulomb fileName " + new File(RegionDefaults.coulombFilterPath).getAbsolutePath());
                coulombFileLines = FileUtils.loadFile(RegionDefaults.coulombFilterPath);
            }
            catch (Exception e) {
                throw new RuntimeException("Coulomb filter file could not be loaded");
            }
            ListIterator<String> it = coulombFileLines.listIterator();
            while (it.hasNext()) {
                String line = it.next().toString();
                StringTokenizer st = new StringTokenizer(line);
                double lon = Double.parseDouble(st.nextToken());
                double lat = Double.parseDouble(st.nextToken());
                double cfScaler = Double.parseDouble(st.nextToken());
                Location cfLoc = new Location(lat, lon, DEPTH);
                for (int k = 0; k < bgRegionSize; ++k) {
                    bgDistAtLoc = bggrid.getHypoMagFreqDistAtLoc(k);
                    boolean isLoc = cfLoc.equalsLocation(bgLocList.getLocationAt(k));
                    if (!isLoc) continue;
                    if ((int)cfScaler == 0) {
                        cfs[k] = 1;
                    }
                    if ((int)cfScaler == 1) {
                        cfs[k] = 2;
                    }
                    int as = 0;
                    while ((double)as < numAS_Locs) {
                        boolean isAS_Loc = cfLoc.equalsLocation(gridLocs.getLocationAt(as));
                        if (isAS_Loc && distanceFromFault[as] <= RegionDefaults.coulombFaultRadius) {
                            cfs[k] = 0;
                            System.out.println("Coul in Aftershock Zone");
                        }
                        ++as;
                    }
                    if (cfs[k] == 1) {
                        sumRatesBlue += bgDistAtLoc.getFirstMagFreqDist().getCumRate(RegionDefaults.minForecastMag);
                        continue;
                    }
                    if (cfs[k] != 2) continue;
                    sumRatesRed += bgDistAtLoc.getFirstMagFreqDist().getCumRate(RegionDefaults.minForecastMag);
                }
            }
        }
        totalR = sumRatesBlue + sumRatesRed;
        double scalerBlue = totalR * RegionDefaults.bluePercent / sumRatesBlue;
        double scalerRed = totalR * RegionDefaults.redPercent / sumRatesRed;
        for (int k = 0; k < bgRegionSize; ++k) {
            double grid_scaler = 1.0;
            if (cfs[k] == 1) {
                grid_scaler = scalerBlue;
            } else if (cfs[k] == 2) {
                grid_scaler = scalerRed;
            }
            HypoMagFreqDistAtLoc fmd = bggrid.getHypoMagFreqDistAtLoc(k);
            numForecastMags = 1 + (int)((RegionDefaults.maxForecastMag - RegionDefaults.minForecastMag) / RegionDefaults.deltaForecastMag);
            IncrementalMagFreqDist magFreqDist = new IncrementalMagFreqDist(RegionDefaults.minForecastMag, RegionDefaults.maxForecastMag, numForecastMags);
            IncrementalMagFreqDist scaled_fmd = new IncrementalMagFreqDist(RegionDefaults.minForecastMag, RegionDefaults.maxForecastMag, numForecastMags);
            magFreqDist = fmd.getFirstMagFreqDist();
            EvenlyDiscretizedFunc rates = magFreqDist.getCumRateDist();
            int nr = rates.getNum();
            for (int i = 0; i < nr; ++i) {
                double scaled_rate = i < nr - 1 ? (rates.getY(i) - rates.getY(i + 1)) * grid_scaler : rates.getY(i) * grid_scaler;
                scaled_fmd.add(i, scaled_rate);
            }
            bggrid.setMagFreqDistAtLoc(scaled_fmd, k);
        }
        try {
            FileWriter fr = new FileWriter(RegionDefaults.outputCoulombRatePath);
            bgRegionSize = bgLocList.size();
            for (int k = 0; k < bgRegionSize; ++k) {
                Location bgLoc = bgLocList.getLocationAt(k);
                bgDistAtLoc = bggrid.getHypoMagFreqDistAtLoc(k);
                if (bgDistAtLoc == null) continue;
                numForecastMags = 1 + (int)((RegionDefaults.maxForecastMag - RegionDefaults.minForecastMag) / RegionDefaults.deltaForecastMag);
                for (int index = 0; index < numForecastMags; ++index) {
                    double mag = RegionDefaults.minForecastMag + (double)index * RegionDefaults.deltaForecastMag;
                    double wrate = bgDistAtLoc.getFirstMagFreqDist().getIncrRate(mag);
                    if (wrate == 0.0) {
                        wrate = 1.0E-11;
                    }
                    fr.write(locFormat.format(bgLoc.getLongitude() - RegionDefaults.gridSpacing / 2.0) + "    " + locFormat.format(bgLoc.getLongitude() + RegionDefaults.gridSpacing / 2.0) + "    " + locFormat.format(bgLoc.getLatitude() - RegionDefaults.gridSpacing / 2.0) + "    " + locFormat.format(bgLoc.getLatitude() + RegionDefaults.gridSpacing / 2.0) + "    " + RegionDefaults.MIN_Z + "    " + RegionDefaults.MAX_Z + "    " + magFormat.format(mag - RegionDefaults.deltaForecastMag / 2.0) + "    " + magFormat.format(mag + RegionDefaults.deltaForecastMag / 2.0) + "    " + wrate + "     1\n");
                }
            }
            fr.close();
        }
        catch (IOException ee) {
            ee.printStackTrace();
        }
    }
}

