/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.step.calc;

public class CalcAIC_Weights {
    private double genWeight;
    private double seqWeight;
    private double spaWeight;

    public CalcAIC_Weights() {
    }

    public CalcAIC_Weights(double genAIC, double seqAIC, double spaAIC) {
        this.calcWeights(genAIC, seqAIC, spaAIC);
    }

    public void calcWeights(double genAIC, double seqAIC, double spaAIC) {
        double[] eDi = new double[3];
        double minAIC = genAIC;
        if (seqAIC < minAIC) {
            minAIC = seqAIC;
        }
        if (spaAIC < minAIC) {
            minAIC = spaAIC;
        }
        eDi[0] = Double.isNaN(genAIC) ? 0.0 : Math.exp(-0.5 * (genAIC - minAIC));
        eDi[1] = Double.isNaN(seqAIC) ? 0.0 : Math.exp(-0.5 * (seqAIC - minAIC));
        eDi[2] = Double.isNaN(spaAIC) ? 0.0 : Math.exp(-0.5 * (spaAIC - minAIC));
        double sum_eDi = eDi[0] + eDi[1] + eDi[2];
        this.genWeight = eDi[0] / sum_eDi;
        this.seqWeight = eDi[1] / sum_eDi;
        this.spaWeight = eDi[2] / sum_eDi;
    }

    public double getGenWeight() {
        return this.genWeight;
    }

    public double getSeqWeight() {
        return this.seqWeight;
    }

    public double getSpaWeight() {
        return this.spaWeight;
    }
}

