/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.step.calc;

import java.util.ListIterator;
import org.apache.log4j.Logger;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.step.calc.ListSortingTools;
import org.opensha.step.calc.MagHist;
import org.opensha.step.calc.MaxLikeGR_Calc;
import org.opensha.step.calc.NoValsFoundException;

public class CompletenessMagCalc {
    private static Logger logger = Logger.getLogger(CompletenessMagCalc.class);
    public double mcBest;
    public double mcSynth;
    public double mcMaxCurv;
    public int numInBin;
    private double deltaBin = 0.1;
    private double GR_MMax = 10.0;

    public CompletenessMagCalc() {
    }

    public CompletenessMagCalc(ObsEqkRupList afterShocks) {
        this.setMcMaxCurv(afterShocks);
        this.setMcBest(afterShocks);
    }

    public void setMcBest(ObsEqkRupList eventList) {
        ListIterator eventIt = eventList.listIterator();
        int numEvents = eventList.size();
        int ind = 0;
        double[] magList = new double[numEvents];
        while (eventIt.hasNext()) {
            ObsEqkRupture event = (ObsEqkRupture)eventIt.next();
            magList[ind++] = event.getMag();
        }
        this.calcMcSynth(magList);
    }

    public void setMcMaxCurv(ObsEqkRupList eventList) {
        ListIterator eventIt = eventList.listIterator();
        int numEvents = eventList.size();
        int ind = 0;
        double[] magList = new double[numEvents];
        while (eventIt.hasNext()) {
            ObsEqkRupture event = (ObsEqkRupture)eventIt.next();
            magList[ind++] = event.getMag();
        }
        this.calcMcMaxCurv(magList);
    }

    public double getMcBest() {
        this.mcBest = this.mcSynth != Double.NaN ? this.mcSynth : this.mcMaxCurv;
        this.mcBest = 4.0;
        return this.mcBest;
    }

    public double getMcMaxCurv() {
        return this.mcMaxCurv;
    }

    public double getMcSynth() {
        return this.mcSynth;
    }

    private void calcMcMaxCurv(double[] magList) {
        double minMag = ListSortingTools.getMinVal(magList);
        double maxMag = ListSortingTools.getMaxVal(magList);
        if (minMag > 0.0) {
            minMag = 0.0;
        }
        int numMags = (int)(maxMag * 10.0) + 1;
        MagHist hist = new MagHist(magList, minMag, maxMag, this.deltaBin);
        int[] numInBin = hist.getNumInBins();
        double maxCurv = ListSortingTools.getMaxVal(numInBin);
        double[] magRange = ListSortingTools.getEvenlyDiscrVals(minMag, maxMag, this.deltaBin);
        int maxCurvInd = ListSortingTools.findIndex((double)((int)maxCurv), numInBin);
        this.mcMaxCurv = magRange[maxCurvInd];
    }

    private void calcMcSynth(double[] magList) {
        this.mcMaxCurv = this.getMcMaxCurv();
        int aSize = (int)((this.mcMaxCurv + 1.5 - (this.mcMaxCurv - 0.9)) / this.deltaBin + 1.0);
        double[] fitProb = new double[aSize];
        double mcLoop = this.mcMaxCurv - 0.9;
        for (int ct = 0; ct < aSize; ++ct) {
            mcLoop += this.deltaBin;
            double[] cutCat = null;
            int sizeCutCat = 0;
            try {
                cutCat = ListSortingTools.getValsAbove(magList, mcLoop);
                sizeCutCat = cutCat.length;
            }
            catch (NoValsFoundException err1) {
                // empty catch block
            }
            if (sizeCutCat < 25) continue;
            MaxLikeGR_Calc maxLikeGR_Calc = new MaxLikeGR_Calc();
            maxLikeGR_Calc.setMags(cutCat);
            double bvalMaxLike = maxLikeGR_Calc.get_bValueMaxLike();
            int numBins = (int)Math.round((this.GR_MMax - mcLoop) / this.deltaBin) + 1;
            GutenbergRichterMagFreqDist GR_FMD = new GutenbergRichterMagFreqDist(mcLoop, this.GR_MMax, numBins);
            GR_FMD.setAllButTotMoRate(mcLoop, this.GR_MMax, sizeCutCat, bvalMaxLike);
            int mIndex = 0;
            double[] mbinRates = new double[numBins];
            for (double mbinLoop = mcLoop; mbinLoop <= this.GR_MMax; mbinLoop += this.deltaBin) {
                mbinRates[mIndex] = GR_FMD.getIncrRate(mIndex++);
            }
            boolean flip = true;
            MagHist hist = new MagHist(magList, mcLoop, this.GR_MMax, this.deltaBin);
            int[] numObsInBin = hist.getNumInBins();
            double[] obsCumSum = ListSortingTools.calcCumSum(numObsInBin, flip);
            double sumObs = ListSortingTools.getListSum(obsCumSum);
            double numer = 0.0;
            for (int sLoop = 0; sLoop < obsCumSum.length; ++sLoop) {
                numer += Math.abs(obsCumSum[sLoop] - mbinRates[sLoop]);
            }
            fitProb[ct] = (sumObs - numer) / sumObs * 100.0;
        }
        try {
            double[] mc95List = ListSortingTools.getValsAbove(fitProb, 95.0);
            this.mcSynth = ListSortingTools.getMinVal(mc95List);
        }
        catch (NoValsFoundException err1) {
            try {
                double[] mc90List = ListSortingTools.getValsAbove(fitProb, 90.0);
                this.mcSynth = ListSortingTools.getMinVal(mc90List);
            }
            catch (NoValsFoundException err2) {
                this.mcSynth = Double.NaN;
            }
        }
    }
}

