/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.step.calc;

import java.util.Iterator;
import java.util.ListIterator;
import org.opensha.commons.calc.RelativeLocation;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.region.GriddedRegion;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.faultSurface.EvenlyGriddedSurfaceAPI;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.step.calc.RegionDefaults;

public final class DistDecayFromRupCalc {
    private static double decayParam = 2.0;
    public static double[] rupDistList;

    public static double[] getDensity(FaultTrace faultTrace, GriddedRegion aftershockZone) {
        int indLoop;
        double[] nodePerc = null;
        double sumInvDist = 0.0;
        int numLocs = aftershockZone.getNodeCount();
        double[] nodeDistFromFault = new double[numLocs];
        double[] invDist = new double[numLocs];
        nodePerc = new double[numLocs];
        Iterator<Location> zoneIT = aftershockZone.getNodeList().iterator();
        int ind = 0;
        double totDistFromFault = 0.0;
        while (zoneIT.hasNext()) {
            nodeDistFromFault[ind++] = faultTrace.getHorzDistToClosestLocation(zoneIT.next());
            totDistFromFault += Math.pow(nodeDistFromFault[ind - 1], decayParam);
        }
        for (indLoop = 0; indLoop < numLocs; ++indLoop) {
            invDist[indLoop] = totDistFromFault / Math.pow(nodeDistFromFault[indLoop], decayParam);
            sumInvDist += invDist[indLoop];
        }
        for (indLoop = 0; indLoop < ind - 1; ++indLoop) {
            nodePerc[indLoop] = invDist[indLoop] / sumInvDist;
        }
        return nodePerc;
    }

    public static double[] getDensity(ObsEqkRupture mainshock, GriddedRegion aftershockZone) {
        int indLoop;
        double[] nodePerc = null;
        Iterator<Location> zoneIT = aftershockZone.getNodeList().iterator();
        int ind = 0;
        double totDistFromFault = 0.0;
        double sumInvDist = 0.0;
        int numLocs = aftershockZone.getNodeCount();
        double[] nodeDistFromFault = new double[numLocs];
        double[] invDist = new double[numLocs];
        nodePerc = new double[numLocs];
        if (mainshock.getRuptureSurface() == null) {
            Location pointRupture = mainshock.getHypocenterLocation();
            while (zoneIT.hasNext()) {
                nodeDistFromFault[ind++] = RelativeLocation.getApproxHorzDistance(pointRupture, zoneIT.next());
                totDistFromFault += Math.pow(nodeDistFromFault[ind - 1], decayParam);
            }
        } else {
            EvenlyGriddedSurfaceAPI ruptureSurface = mainshock.getRuptureSurface();
            while (zoneIT.hasNext()) {
                Location gLoc = zoneIT.next();
                if (gLoc != null) {
                    nodeDistFromFault[ind++] = DistDecayFromRupCalc.calcRupDist(ruptureSurface, gLoc, aftershockZone.getSpacing());
                    totDistFromFault += Math.pow(nodeDistFromFault[ind - 1], decayParam);
                    continue;
                }
                nodeDistFromFault[ind++] = -1.0;
            }
            DistDecayFromRupCalc.setRupDistList(nodeDistFromFault);
        }
        for (indLoop = 0; indLoop < numLocs; ++indLoop) {
            if (!(nodeDistFromFault[indLoop] > 0.0)) continue;
            invDist[indLoop] = totDistFromFault / Math.pow(nodeDistFromFault[indLoop], decayParam);
            sumInvDist += invDist[indLoop];
        }
        for (indLoop = 0; indLoop < ind; ++indLoop) {
            nodePerc[indLoop] = nodeDistFromFault[indLoop] > 0.0 ? invDist[indLoop] / sumInvDist : 0.0;
        }
        return nodePerc;
    }

    private static double calcRupDist(EvenlyGriddedSurfaceAPI ruptureSurface, Location gridLoc, double gridSpacing) {
        double cutOffDist = RelativeLocation.getApproxHorzDistance(new Location(gridLoc.getLatitude() + RegionDefaults.CUTOFF_DISTANCE * gridSpacing, gridLoc.getLongitude()), gridLoc);
        int numRupGrids = ruptureSurface.getLocationList().size();
        double minDistFromRup = 0.0;
        if (numRupGrids > 1) {
            Location loc0 = ruptureSurface.getLocationList().getLocationAt(0);
            Location loc1 = ruptureSurface.getLocationList().getLocationAt(1);
            Location loc2 = ruptureSurface.getLocationList().getLocationAt(2);
            double dist0 = minDistFromRup = RelativeLocation.getApproxHorzDistToLine(loc0, loc1, gridLoc);
            minDistFromRup = RelativeLocation.getApproxHorzDistToLine(loc2, loc1, gridLoc);
            double dist1 = minDistFromRup;
            minDistFromRup = dist1 < dist0 ? dist1 : dist0;
        } else {
            int ind = 0;
            ListIterator rupIT = ruptureSurface.listIterator();
            while (rupIT.hasNext()) {
                double nodeDistFromRup = RelativeLocation.getApproxHorzDistance((Location)rupIT.next(), gridLoc);
                if (ind == 0) {
                    minDistFromRup = nodeDistFromRup;
                    ++ind;
                    continue;
                }
                if (!(nodeDistFromRup < minDistFromRup)) continue;
                minDistFromRup = nodeDistFromRup;
            }
        }
        if (minDistFromRup < cutOffDist) {
            minDistFromRup = cutOffDist;
        }
        return minDistFromRup;
    }

    public void setDecayParam(double decayParam) {
        DistDecayFromRupCalc.decayParam = decayParam;
    }

    public double getDecayParam() {
        return decayParam;
    }

    private static void setRupDistList(double[] nodeDistFromFault) {
        rupDistList = nodeDistFromFault;
    }

    public static double[] getRupDistList() {
        return rupDistList;
    }
}

