/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.step.calc;

import java.util.Iterator;
import java.util.ListIterator;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.region.GriddedRegion;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;

public class MaxLikeGR_Calc {
    private double aVal;
    private double bVal;
    private double[] grid_aVal;
    private double[] grid_bVal;
    private double binning = 0.1;

    public double get_aValueMaxLike() {
        return this.aVal;
    }

    public double get_bValueMaxLike() {
        return this.bVal;
    }

    public double[] getGridded_aValMaxLike() {
        return this.grid_aVal;
    }

    public double[] getGridded_bValMaxLike() {
        return this.grid_bVal;
    }

    public void setMags(double[] magList) {
        this.calcGR_MaxLike(magList);
    }

    public void setMags(ObsEqkRupList obsEventList) {
        ListIterator eventIt = obsEventList.listIterator();
        int numEvents = obsEventList.size();
        int ind = 0;
        double[] magList = new double[numEvents];
        while (eventIt.hasNext()) {
            ObsEqkRupture event = (ObsEqkRupture)eventIt.next();
            magList[ind++] = event.getMag();
        }
        this.calcGR_MaxLike(magList);
    }

    public void setGriddedMags(GriddedRegion gridNodes, ObsEqkRupList eventList) {
        this.calc_GROnGrid(gridNodes, eventList);
    }

    private double getMinMag(double[] magList) {
        double minMag = magList[0];
        int size = magList.length;
        for (int magLoop = 1; magLoop < size; ++magLoop) {
            if (!(magList[magLoop] < minMag)) continue;
            minMag = magList[magLoop];
        }
        return minMag;
    }

    private double getMeanMag(double[] magList) {
        double sum = 0.0;
        int size = magList.length;
        for (int magLoop = 0; magLoop < size; ++magLoop) {
            sum += magList[magLoop];
        }
        return sum / (double)size;
    }

    private void calcGR_MaxLike(double[] magList) {
        double minMag = this.getMinMag(magList);
        double meanMag = this.getMeanMag(magList);
        int size = magList.length;
        this.bVal = 1.0 / (meanMag - (minMag - this.binning / 2.0)) * 0.43429;
        this.aVal = Math.log(size) * 0.43429 + this.bVal * minMag;
    }

    private void calc_GROnGrid(GriddedRegion gridNodes, ObsEqkRupList eventList) {
        Iterator<Location> gridIt = gridNodes.getNodeList().iterator();
        int numNodes = gridNodes.getNodeCount();
        double[] grid_aVal = new double[numNodes];
        double[] grid_bVal = new double[numNodes];
        ListIterator eventIt = eventList.listIterator();
        int numEvents = eventList.size();
        double[] eventDist = new double[numEvents];
        boolean ind = false;
        if (numEvents < 1000) {
            double searchRadius = 15.0;
        } else if (numEvents < 1500) {
            double searchRadius = 12.0;
        } else if (numEvents < 2000) {
            double searchRadius = 10.0;
        } else {
            double searchRadius = 7.5;
        }
    }

    public static void main(String[] args) {
        double[] magList = new double[10];
        double startMag = 3.0;
        for (int synMag = 0; synMag < 10; ++synMag) {
            magList[synMag] = startMag;
            startMag += 1.0;
        }
        MaxLikeGR_Calc calc = new MaxLikeGR_Calc();
        calc.setMags(magList);
        System.out.println("aVal is: " + calc.get_aValueMaxLike());
        System.out.println("bVal is: " + calc.get_bValueMaxLike());
    }
}

