/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.step.calc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.region.SitesInGriddedRegion;
import org.opensha.commons.param.ParameterAPI;
import org.opensha.commons.param.WarningParameterAPI;
import org.opensha.commons.param.event.ParameterChangeWarningEvent;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.PointEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.step.STEP_BackSiesDataAdditionObject;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.attenRelImpl.depricated.BA_2006_AttenRel;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.util.SiteTranslator;
import org.opensha.step.calc.BackGroundRatesGrid;
import org.opensha.step.calc.RegionDefaults;
import org.opensha.step.calc.STEP_main;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STEP_HazardDataSet
implements ParameterChangeWarningListener {
    private static Logger logger = Logger.getLogger(STEP_HazardDataSet.class);
    private boolean calcProbBySourceFile = false;
    private boolean willSiteClass = false;
    protected AttenuationRelationship attenRel;
    public static final double IML_VALUE = Math.log(0.38);
    private static final double SA_PERIOD = 1.0;
    private static final double VS30 = 200.0;
    public static final String STEP_AFTERSHOCK_OBJECT_FILE = RegionDefaults.STEP_AftershockObjectFile;
    private DecimalFormat locFormat = new DecimalFormat("0.0000");
    protected STEP_main stepMain;
    private double[] bgProbVals;
    private double[] probVals;
    private boolean scheduledOperation = false;
    private boolean USE_MAG_WEIGHTING = true;
    private boolean USE_STRESSDROP_SCALAR = true;

    public STEP_HazardDataSet(boolean includeWillsSiteClass) {
        this.willSiteClass = includeWillsSiteClass;
    }

    public static void main(String[] args) {
        STEP_HazardDataSet step = new STEP_HazardDataSet(false);
        if (args.length > 1 && "c".equalsIgnoreCase(args[1])) {
            if (args.length > 2) {
                try {
                    int runs = Integer.parseInt(args[2]);
                    int interval = Integer.parseInt(args[3]);
                    step.continuesTest(runs, interval);
                }
                catch (Exception e) {
                    logger.error((Object)("Please specify number of runs and time interval!!!!" + e));
                    System.exit(1);
                }
            } else {
                step.defaultContinuesTest();
            }
        } else if (args.length > 1 && "s".equalsIgnoreCase(args[1])) {
            step.runScheduledOperation();
        } else {
            step.runSTEP(null, null);
        }
        logger.info((Object)"STEP is finito!");
    }

    private void runScheduledOperation() {
        RegionDefaults.startForecastAtCurrentTime = true;
        this.stepMain = new STEP_main();
        this.scheduledOperation = true;
        this.stepMain.setScheduledOperation(true);
        GregorianCalendar startTime = STEP_main.getCurrentGregorianTime();
        startTime.setTimeInMillis(RegionDefaults.EVENT_START_TIME.getTimeInMillis());
        this.runSTEP(startTime, STEP_main.getCurrentGregorianTime());
    }

    private void defaultContinuesTest() {
        String[] conTestTimesArr;
        RegionDefaults.startForecastAtCurrentTime = true;
        if (RegionDefaults.EVENT_START_TIME == null) {
            logger.error((Object)"event start time must be specified in config file!!");
            System.exit(1);
        }
        String conTestTimes = RegionDefaults.DEFAULT_TEST_TIMES;
        logger.info((Object)("-------------- defaultContinuesTest ----------------conTestTimes = " + conTestTimes));
        if (conTestTimes == null) {
            logger.error((Object)"Please specify default.test.times!!!");
            System.exit(1);
        }
        if ((conTestTimesArr = conTestTimes.split("}")).length != 3) {
            logger.error((Object)"Please specify default.test.times correctly!!!");
            System.exit(1);
        }
        int[] minutes = this.string2Array(conTestTimesArr[0].replace("{", ""));
        int[] hours = this.string2Array(conTestTimesArr[1].replace("{", ""));
        int[] days = this.string2Array(conTestTimesArr[2].replace("{", ""));
        GregorianCalendar startTime = STEP_main.getCurrentGregorianTime();
        startTime.setTimeInMillis(RegionDefaults.EVENT_START_TIME.getTimeInMillis() - (long)RegionDefaults.DEFAULT_TEST_READ_BACK * 24L * 60L * 60L * 1000L);
        GregorianCalendar forecastTime = STEP_main.getCurrentGregorianTime();
        forecastTime.setTimeInMillis(RegionDefaults.EVENT_START_TIME.getTimeInMillis());
        if (minutes.length > 0) {
            this.runContinueousTest(startTime, forecastTime, minutes, 60000L, 'm');
        }
        if (hours.length > 0) {
            this.runContinueousTest(startTime, forecastTime, hours, 3600000L, 'h');
        }
        if (days.length > 0) {
            this.runContinueousTest(startTime, forecastTime, days, 86400000L, 'd');
        }
    }

    private int[] string2Array(String timeStr) {
        String[] timeArr = timeStr.split(",");
        int[] timeArrInt = new int[timeArr.length];
        for (int index = 0; index < timeArr.length; ++index) {
            timeArrInt[index] = Integer.parseInt(timeArr[index]);
        }
        return timeArrInt;
    }

    private void runContinueousTest(GregorianCalendar startTime, GregorianCalendar forecastTime, int[] times, long timeMultiplier, char timeIndicator) {
        RegionDefaults.startForecastAtCurrentTime = true;
        for (int time : times) {
            logger.info((Object)("-------------- " + time + " " + timeIndicator + "  ----------------"));
            forecastTime.setTimeInMillis(RegionDefaults.EVENT_START_TIME.getTimeInMillis() + (long)time * timeMultiplier);
            RegionDefaults.outputAftershockRatePath = RegionDefaults.OUTPUT_DIR + "/TimeDepRates_con_" + time + timeIndicator + ".txt";
            RegionDefaults.outputSTEP_Rates = RegionDefaults.OUTPUT_DIR + "/STEP_Rates_con_" + time + timeIndicator + ".txt";
            RegionDefaults.outputHazardPath = RegionDefaults.OUTPUT_DIR + "/STEP_Probs_con_" + time + timeIndicator + ".txt";
            this.runSTEP(startTime, forecastTime);
            if (startTime == null) {
                startTime = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            }
            startTime.setTimeInMillis(forecastTime.getTimeInMillis());
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                logger.error((Object)e);
            }
        }
    }

    private void continuesTest(int runs, int interval) {
        if (RegionDefaults.EVENT_START_TIME == null) {
            logger.error((Object)"event start time must be specified in config file!!");
            System.exit(1);
        }
        GregorianCalendar forecastTime = STEP_main.getCurrentGregorianTime();
        forecastTime.setTimeInMillis(RegionDefaults.EVENT_START_TIME.getTimeInMillis());
        Calendar startTime = null;
        for (int numRun = 0; numRun < runs; ++numRun) {
            logger.info((Object)("-------------- " + numRun + " ----------------"));
            forecastTime.setTimeInMillis(forecastTime.getTimeInMillis() + (long)(interval * 60) * 1000L);
            RegionDefaults.outputAftershockRatePath = RegionDefaults.OUTPUT_DIR + "/TimeDepRates_con_" + numRun * interval + "m.txt";
            RegionDefaults.outputSTEP_Rates = RegionDefaults.OUTPUT_DIR + "/STEP_Rates_con_" + numRun * interval + "m.txt";
            RegionDefaults.outputHazardPath = RegionDefaults.OUTPUT_DIR + "/STEP_Probs_con_" + numRun * interval + "m.txt";
            this.runSTEP((GregorianCalendar)startTime, forecastTime);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                logger.error((Object)e);
            }
            if (startTime == null) {
                startTime = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            }
            startTime.setTimeInMillis(forecastTime.getTimeInMillis());
        }
    }

    public void runSTEP(GregorianCalendar start, GregorianCalendar forecastTime) {
        if (!this.calcProbBySourceFile) {
            this.runStepmain(start, forecastTime);
            logger.info((Object)"STEP earthquake rates are done.");
        } else {
            if (this.stepMain == null) {
                this.stepMain = new STEP_main();
            }
            this.stepMain.loadBgGrid();
        }
        this.createShakeMapAttenRelInstance();
        SitesInGriddedRegion regionSites = this.getDefaultRegion();
        logger.info((Object)("getNumGridLocs=" + regionSites.getRegion().getNodeCount()));
        double[] stepBothProbVals = this.calcStepProbValues(regionSites);
        this.saveProbValues2File(stepBothProbVals, regionSites);
        if (RegionDefaults.SAVE_MODELS) {
            this.stepMain.saveModels();
        }
    }

    public void runStepmain(GregorianCalendar startTime, GregorianCalendar forecastTime) {
        if (this.stepMain == null) {
            this.stepMain = new STEP_main();
        }
        this.stepMain.calc_STEP(startTime, forecastTime);
    }

    public SitesInGriddedRegion getDefaultRegion() {
        return new SitesInGriddedRegion(this.stepMain.getBgGrid().getDefaultRegion());
    }

    public double[] calcStepProbValues(SitesInGriddedRegion region) {
        region.addSiteParams(this.attenRel.getSiteParamsIterator());
        ListIterator<ParameterAPI> it = this.attenRel.getSiteParamsIterator();
        ArrayList defaultSiteParams = new ArrayList();
        SiteTranslator siteTrans = new SiteTranslator();
        while (it.hasNext()) {
            ParameterAPI tempParam = (ParameterAPI)it.next().clone();
        }
        if (this.willSiteClass) {
            region.setDefaultSiteParams(defaultSiteParams);
            region.setSiteParamsForRegionFromServlet(true);
        }
        this.bgProbVals = this.loadBgProbValues(region, RegionDefaults.backgroundHazardPath);
        ArrayList<PointEqkSource> sourceList = this.calcProbBySourceFile ? this.createStepSourcesFromFile() : this.stepMain.getSourceList();
        this.probVals = this.clacProbVals(this.attenRel, region, sourceList);
        STEP_BackSiesDataAdditionObject addStepData = new STEP_BackSiesDataAdditionObject();
        return addStepData.addDataSet(this.bgProbVals, this.probVals);
    }

    public void createShakeMapAttenRelInstance() {
        System.out.println("Warning: using BA Attenuation!!");
        this.attenRel = new BA_2006_AttenRel(this);
        this.attenRel.setParamDefaults();
        this.attenRel.setIntensityMeasure("SA");
        this.attenRel.getParameter("SA Period").setValue(1.0);
        this.attenRel.getParameter("Vs30").setValue(200.0);
    }

    private void saveProbValues2File(double[] probVals, SitesInGriddedRegion sites) {
        LocationList locList = sites.getRegion().getNodeList();
        int numLocations = locList.size();
        File existingFile = new File(RegionDefaults.outputHazardPath);
        if (this.scheduledOperation && existingFile.exists()) {
            this.stepMain.backupFile(existingFile, this.stepMain.getLastCurrTime());
        }
        logger.info((Object)("saveProbValues2File " + new File(RegionDefaults.outputHazardPath).getAbsolutePath()));
        try {
            FileWriter fr = new FileWriter(RegionDefaults.outputHazardPath);
            for (int i = 0; i < numLocations; ++i) {
                Location loc = locList.getLocationAt(i);
                fr.write(this.locFormat.format(loc.getLatitude()) + "    " + this.locFormat.format(loc.getLongitude()) + "      " + this.convertToProb(probVals[i]) + "\n");
            }
            fr.close();
        }
        catch (IOException ee) {
            ee.printStackTrace();
        }
    }

    private double convertToProb(double rate) {
        return 1.0 - Math.exp(-1.0 * rate * RegionDefaults.forecastLengthDays);
    }

    public double[] loadBgProbValues(SitesInGriddedRegion sites, String fileName) {
        BackGroundRatesGrid bgGrid = this.stepMain.getBgGrid();
        logger.info((Object)("loadBgProbValues numSites =" + sites.getRegion().getNodeCount() + " fileName=" + fileName));
        double[] vals = new double[sites.getRegion().getNodeCount()];
        HashMap<String, Double> valuesMap = new HashMap<String, Double>();
        try {
            ArrayList<String> fileLines = FileUtils.loadFile(fileName);
            ListIterator<String> it = fileLines.listIterator();
            STEP_main.log("fileLines.size() =" + fileLines.size());
            while (it.hasNext()) {
                StringTokenizer st = new StringTokenizer(it.next());
                String latstr = st.nextToken().trim();
                String lonstr = st.nextToken().trim();
                String val = st.nextToken().trim();
                double lon = Double.parseDouble(lonstr);
                double lat = Double.parseDouble(latstr);
                Location loc = new Location(lat, lon, 0.0);
                double temp = 0.0;
                temp = !val.equalsIgnoreCase("NaN") ? new Double(val).doubleValue() : new Double(Double.NaN).doubleValue();
                valuesMap.put(bgGrid.getKey4Location(loc), temp);
            }
            for (int i = 0; i < sites.getRegion().getNodeCount(); ++i) {
                Location loc = sites.getRegion().locationForIndex(i);
                Double val = (Double)valuesMap.get(bgGrid.getKey4Location(loc));
                vals[i] = val == null ? 0.0 : val;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return vals;
    }

    private double convertToRate(double prob) {
        return -1.0 * Math.log(1.0 - prob) / RegionDefaults.forecastLengthDays;
    }

    public double[] clacProbVals(AttenuationRelationship imr, SitesInGriddedRegion sites, ArrayList sourceList) {
        double[] probVals = new double[sites.getRegion().getNodeCount()];
        double MAX_DISTANCE = 500.0;
        try {
            int numSources = sourceList.size();
            boolean sourceUsed = false;
            int numSites = sites.getRegion().getNodeCount();
            int numSourcesSkipped = 0;
            logger.info((Object)("--- clacProbVals numSites " + numSites + " numSources " + numSources));
            for (int j = 0; j < numSites; ++j) {
                sourceUsed = false;
                double hazVal = 1.0;
                double condProb = 0.0;
                Site site = sites.getSite(j);
                System.out.println("Warning: No McVerry Site Class Set!");
                for (int i = 0; i < numSources; ++i) {
                    ProbEqkSource source = (ProbEqkSource)sourceList.get(i);
                    double distance = source.getMinDistance(sites.getSite(j));
                    if (distance > MAX_DISTANCE) {
                        ++numSourcesSkipped;
                        continue;
                    }
                    sourceUsed = true;
                    hazVal *= 1.0 - imr.getTotExceedProbability((PointEqkSource)source, IML_VALUE);
                }
                hazVal = sourceUsed ? 1.0 - hazVal : 0.0;
                probVals[j] = this.convertToRate(hazVal);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.info((Object)"<<< clacProbVals");
        return probVals;
    }

    public double[] getBgProbVals() {
        return this.bgProbVals;
    }

    public double[] getProbVals() {
        return this.probVals;
    }

    @Override
    public void parameterChangeWarning(ParameterChangeWarningEvent e) {
        String S = " : parameterChangeWarning(): ";
        WarningParameterAPI param = e.getWarningParameter();
        param.setValueIgnoreWarning(e.getNewValue());
    }

    public STEP_main getStepMain() {
        return this.stepMain;
    }

    public void setStepMain(STEP_main stepMain) {
        this.stepMain = stepMain;
    }

    public AttenuationRelationship getAttenRel() {
        return this.attenRel;
    }

    public ArrayList<PointEqkSource> createStepSourcesFromFile() {
        System.out.println("createStepSourcesFromFile");
        BackGroundRatesGrid bgGrid = this.stepMain.getBgGrid();
        ArrayList<PointEqkSource> sourceList = new ArrayList<PointEqkSource>();
        ArrayList<Location> locList = new ArrayList<Location>();
        HashMap<String, IncrementalMagFreqDist> magFreqMap = new HashMap<String, IncrementalMagFreqDist>();
        try {
            ArrayList<String> fileLines = FileUtils.loadFile(RegionDefaults.STEP_SORCE_FILE);
            for (String line : fileLines) {
                IncrementalMagFreqDist magDist;
                double mag;
                line = line.trim();
                String[] sourceElements = line.split("[ \t]+");
                double lat = Double.parseDouble(sourceElements[1].trim());
                double lon = Double.parseDouble(sourceElements[0].trim());
                if (lat < RegionDefaults.searchLatMin || lat > RegionDefaults.searchLatMax || lon < RegionDefaults.searchLongMin || lon > RegionDefaults.searchLongMax || (mag = Double.parseDouble(sourceElements[2].trim())) < 5.0) continue;
                double prob = Double.parseDouble(sourceElements[3].trim());
                Location loc = new Location(lat, lon);
                loc.setDepth(5.0);
                String locKey = bgGrid.getKey4Location(loc);
                if (magFreqMap.get(locKey) == null) {
                    int numForecastMags = 1 + (int)((RegionDefaults.maxForecastMag - 5.0) / RegionDefaults.deltaForecastMag);
                    magDist = new IncrementalMagFreqDist(5.0, RegionDefaults.maxForecastMag, numForecastMags);
                    locList.add(loc);
                } else {
                    magDist = (IncrementalMagFreqDist)magFreqMap.get(locKey);
                }
                int x = magDist.getXIndex(mag);
                magDist.set(x, prob);
                magFreqMap.put(locKey, magDist);
            }
            System.out.println("Warning: Setting rake to -100!");
            for (Location loc : locList) {
                IncrementalMagFreqDist magDist = (IncrementalMagFreqDist)magFreqMap.get(bgGrid.getKey4Location(loc));
                PointEqkSource source = new PointEqkSource(loc, magDist, RegionDefaults.forecastLengthDays, 100.0, 90.0, RegionDefaults.minForecastMag);
                sourceList.add(source);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("createStepSourcesFromFile sourceList " + sourceList.size());
        return sourceList;
    }
}

