/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.step.calc;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.mapping.gmt.GMT_MapGenerator;
import org.opensha.commons.param.ParameterAPI;
import org.opensha.commons.param.WarningParameterAPI;
import org.opensha.sha.calc.disaggregation.DisaggregationCalculatorAPI;
import org.opensha.sha.calc.disaggregation.DisaggregationPlotData;
import org.opensha.sha.calc.disaggregation.DisaggregationSourceRuptureComparator;
import org.opensha.sha.calc.disaggregation.DisaggregationSourceRuptureInfo;
import org.opensha.sha.earthquake.EqkRupForecast;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.PointEqkSource;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIntensityMeasureRelationshipAPI;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceRupParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepDisaggregationCalculator
extends UnicastRemoteObject
implements DisaggregationCalculatorAPI {
    protected static final String C = "StepDisaggregationCalculator";
    protected static final boolean D = true;
    public static final String OPENSHA_SERVLET_URL = "http://opensha.usc.edu:8080/OpenSHA_dev/DisaggregationPlotServlet";
    private double[] mag_center;
    private double[] mag_binEdges;
    private double[] dist_center;
    private double[] dist_binEdges;
    private int NUM_E = 8;
    private double[][][] pdf3D;
    private double maxContrEpsilonForDisaggrPlot;
    private double maxContrEpsilonForGMT_Plot;
    private int iMag;
    private int iDist;
    private int iEpsilon;
    private double mag;
    private double dist;
    private double epsilon;
    private boolean withinBounds;
    private double Mbar;
    private double Dbar;
    private double Ebar;
    private int M_index_mode3D;
    private int D_index_mode3D;
    private String epsilonRangeString;
    private double totalRate;
    private double outOfBoundsRate;
    private int currRuptures = -1;
    private int totRuptures = 0;
    private int numSourcesToShow = 0;
    private String sourceDisaggInfo;
    public static final String DISAGGREGATION_PLOT_NAME = "DisaggregationPlot";
    public static final String DISAGGREGATION_PLOT_IMG_NAME = "DisaggregationPlot.jpg";
    public static final String DISAGGREGATION_PLOT_PDF_NAME = "DisaggregationPlot.pdf";
    private String disaggregationPlotImgWebAddr;
    static String[] epsilonColors = new String[]{"-G215/38/3", "-G252/94/62", "-G252/180/158", "-G254/220/210", "-G217/217/255", "-G151/151/255", "-G0/0/255", "-G0/0/170"};

    public StepDisaggregationCalculator() throws RemoteException {
        this.setMagRange(5.1, 29, 0.1);
        this.setDistanceRange(10.0, 14, 20.0);
    }

    public List<DisaggregationSourceRuptureInfo> disaggregate(double iml, Site site, ScalarIntensityMeasureRelationshipAPI imr, ArrayList<PointEqkSource> sourceList, double maxDist, ArbitrarilyDiscretizedFunc magDistFilter) throws RemoteException {
        DecimalFormat f1 = new DecimalFormat("000000");
        DecimalFormat f2 = new DecimalFormat("00.00");
        this.pdf3D = new double[this.dist_center.length][this.mag_center.length][this.NUM_E];
        DistanceRupParameter distRup = new DistanceRupParameter();
        String S = "StepDisaggregationCalculator: disaggregate(): ";
        System.out.println(S + "STARTING DISAGGREGATION");
        System.out.println(S + "iml = " + iml);
        ArrayList<DisaggregationSourceRuptureInfo> disaggSourceList = null;
        DisaggregationSourceRuptureComparator srcRupComparator = null;
        if (this.numSourcesToShow > 0) {
            disaggSourceList = new ArrayList<DisaggregationSourceRuptureInfo>();
            srcRupComparator = new DisaggregationSourceRuptureComparator();
        }
        ((AttenuationRelationship)imr).resetParameterEventListeners();
        boolean includeMagDistFilter = magDistFilter != null;
        double magThresh = 0.0;
        imr.setUserMaxDistance(maxDist);
        ParameterAPI im = imr.getIntensityMeasure();
        if (im instanceof WarningParameterAPI) {
            WarningParameterAPI warnIM = (WarningParameterAPI)im;
            warnIM.setValueIgnoreWarning(new Double(iml));
        } else {
            im.setValue(new Double(iml));
        }
        int numSources = sourceList.size();
        HashMap sourceDissaggMap = new HashMap();
        this.totRuptures = 0;
        for (int i = 0; i < numSources; ++i) {
            this.totRuptures += sourceList.get(i).getNumRuptures();
        }
        this.currRuptures = 0;
        try {
            imr.setSite(site);
        }
        catch (Exception ex) {
            System.out.println("StepDisaggregationCalculator:Param warning caught" + ex);
            ex.printStackTrace();
        }
        this.Ebar = 0.0;
        this.Mbar = 0.0;
        this.Dbar = 0.0;
        this.totalRate = 0.0;
        this.outOfBoundsRate = 0.0;
        System.out.println("StepDisaggregationCalculator:dist_center.length " + this.dist_center.length);
        System.out.println("StepDisaggregationCalculator:mag_center.length " + this.mag_center.length);
        System.out.println("StepDisaggregationCalculator:NUM_E " + this.NUM_E);
        for (int i = 0; i < this.dist_center.length; ++i) {
            for (int j = 0; j < this.mag_center.length; ++j) {
                for (int k = 0; k < this.NUM_E; ++k) {
                    this.pdf3D[i][j][k] = 0.0;
                }
            }
        }
        boolean testNum = false;
        int numRupRejected = 0;
        for (int i = 0; i < numSources; ++i) {
            double sourceRate = 0.0;
            ProbEqkSource source = sourceList.get(i);
            String sourceName = source.getName();
            int numRuptures = sourceList.get(i).getNumRuptures();
            double distance = source.getMinDistance(site);
            if (distance > maxDist) {
                this.currRuptures += numRuptures;
                continue;
            }
            if (includeMagDistFilter) {
                magThresh = magDistFilter.getInterpolatedY(distance);
            }
            if (this.numSourcesToShow > 0) {
                sourceDissaggMap.put(sourceName, new ArrayList());
            }
            int n = 0;
            while (n < numRuptures) {
                ProbEqkRupture rupture = source.getRupture(n);
                double qkProb = rupture.getProbability();
                if (includeMagDistFilter && rupture.getMag() < magThresh) {
                    ++numRupRejected;
                } else {
                    imr.setEqkRupture(rupture);
                    double condProb = imr.getExceedProbability();
                    if (condProb == 0.0) {
                        System.out.println(S + "Exceedance probability is zero! (thus the NaNs below)");
                    }
                    this.epsilon = imr.getEpsilon();
                    distRup.setValue(rupture, site);
                    this.dist = (Double)distRup.getValue();
                    this.mag = rupture.getMag();
                    double rate = -condProb * Math.log(1.0 - qkProb);
                    if (rate > 1.0) {
                        System.out.println(S + " ------ rate " + rate);
                    }
                    if (rate > 0.0) {
                        this.setIndices();
                        if (this.withinBounds) {
                            double[] dArray = this.pdf3D[this.iDist][this.iMag];
                            int n2 = this.iEpsilon;
                            dArray[n2] = dArray[n2] + rate;
                        } else {
                            System.out.println("disaggregation(): Some bin is out of range");
                            this.outOfBoundsRate += rate;
                        }
                        this.totalRate += rate;
                        this.Mbar += rate * this.mag;
                        this.Dbar += rate * this.dist;
                        this.Ebar += rate * this.epsilon;
                        sourceRate += rate;
                    }
                }
                ++n;
                ++this.currRuptures;
            }
            if (this.numSourcesToShow <= 0) continue;
            DisaggregationSourceRuptureInfo disaggInfo = new DisaggregationSourceRuptureInfo(sourceName, (float)sourceRate, i);
            disaggSourceList.add(disaggInfo);
        }
        if (!(this.totalRate > 0.0)) {
            return null;
        }
        if (this.numSourcesToShow > 0) {
            Collections.sort(disaggSourceList, srcRupComparator);
            this.sourceDisaggInfo = "Source#\t% Contribution\tTotExceedRate\tSourceName\n";
            int size = disaggSourceList.size();
            if (size > this.numSourcesToShow) {
                size = this.numSourcesToShow;
            }
            for (int i = 0; i < size; ++i) {
                DisaggregationSourceRuptureInfo disaggInfo = (DisaggregationSourceRuptureInfo)disaggSourceList.get(i);
                this.sourceDisaggInfo = this.sourceDisaggInfo + f1.format(disaggInfo.getId()) + "\t" + f2.format(100.0 * disaggInfo.getRate() / this.totalRate) + "\t" + (float)disaggInfo.getRate() + "\t" + disaggInfo.getName() + "\n";
            }
        }
        this.Mbar /= this.totalRate;
        this.Dbar /= this.totalRate;
        this.Ebar /= this.totalRate;
        System.out.println(S + "Mbar = " + this.Mbar);
        System.out.println(S + "Dbar = " + this.Dbar);
        System.out.println(S + "Ebar = " + this.Ebar);
        this.maxContrEpsilonForDisaggrPlot = -1.0;
        int modeMagBin = -1;
        int modeDistBin = -1;
        int modeEpsilonBin = -1;
        double maxContrBinRate = -1.0;
        for (int i = 0; i < this.dist_center.length; ++i) {
            for (int j = 0; j < this.mag_center.length; ++j) {
                double contrEpsilonSum = 0.0;
                for (int k = 0; k < this.NUM_E; ++k) {
                    this.pdf3D[i][j][k] = this.pdf3D[i][j][k] / this.totalRate * 100.0;
                    contrEpsilonSum += this.pdf3D[i][j][k];
                    if (!(this.pdf3D[i][j][k] > maxContrBinRate)) continue;
                    maxContrBinRate = this.pdf3D[i][j][k];
                    modeDistBin = i;
                    modeMagBin = j;
                    modeEpsilonBin = k;
                }
                if (!(contrEpsilonSum > this.maxContrEpsilonForDisaggrPlot)) continue;
                this.maxContrEpsilonForDisaggrPlot = contrEpsilonSum;
            }
        }
        this.M_index_mode3D = modeMagBin;
        this.D_index_mode3D = modeDistBin;
        this.epsilonRangeString = this.getEpsilonRange(modeEpsilonBin);
        System.out.println(S + "MagModeIndex = " + this.M_index_mode3D + "; binNum = " + modeMagBin);
        System.out.println(S + "DistModeIndex = " + this.D_index_mode3D + "; binNum = " + modeDistBin);
        System.out.println(S + "EpsMode = " + this.epsilonRangeString + "; binNum = " + modeEpsilonBin);
        System.out.println("numRupRejected=" + numRupRejected);
        return disaggSourceList;
    }

    @Override
    public String getDisaggregationSourceInfo() throws RemoteException {
        if (this.numSourcesToShow > 0) {
            return this.sourceDisaggInfo;
        }
        return "";
    }

    @Override
    public void setMagRange(double minMag, int numMags, double deltaMag) throws RemoteException {
        this.mag_center = new double[numMags];
        this.mag_binEdges = new double[numMags + 1];
        this.mag_binEdges[0] = minMag - deltaMag / 2.0;
        for (int i = 0; i < numMags; ++i) {
            this.mag_center[i] = minMag + (double)i * deltaMag;
            this.mag_binEdges[i + 1] = this.mag_center[i] + deltaMag / 2.0;
        }
    }

    public void setMagRange(double[] magBinEdges) throws RemoteException {
        this.mag_binEdges = magBinEdges;
        this.mag_center = new double[this.mag_binEdges.length - 1];
        for (int i = 0; i < this.mag_center.length; ++i) {
            this.mag_center[i] = (this.mag_binEdges[i] + this.mag_binEdges[i + 1]) / 2.0;
        }
    }

    @Override
    public void setDistanceRange(double minDist, int numDist, double deltaDist) throws RemoteException {
        this.dist_center = new double[numDist];
        this.dist_binEdges = new double[numDist + 1];
        this.dist_binEdges[0] = minDist - deltaDist / 2.0;
        for (int i = 0; i < numDist; ++i) {
            this.dist_center[i] = minDist + (double)i * deltaDist;
            this.dist_binEdges[i + 1] = this.dist_center[i] + deltaDist / 2.0;
        }
    }

    @Override
    public void setDistanceRange(double[] distBinEdges) throws RemoteException {
        this.dist_binEdges = distBinEdges;
        this.dist_center = new double[distBinEdges.length - 1];
        for (int i = 0; i < this.dist_center.length; ++i) {
            this.dist_center[i] = (distBinEdges[i] + distBinEdges[i + 1]) / 2.0;
        }
    }

    @Override
    public void setMaxZAxisForPlot(double zMax) throws RemoteException {
        this.maxContrEpsilonForGMT_Plot = !Double.isNaN(zMax) ? zMax : this.maxContrEpsilonForDisaggrPlot;
    }

    @Override
    public int getCurrRuptures() throws RemoteException {
        return this.currRuptures;
    }

    @Override
    public int getTotRuptures() throws RemoteException {
        return this.totRuptures;
    }

    @Override
    public boolean done() throws RemoteException {
        return this.currRuptures == this.totRuptures;
    }

    @Override
    public String getMeanAndModeInfo() throws RemoteException {
        float mm_l = (float)this.mag_binEdges[this.M_index_mode3D];
        float mm_u = (float)this.mag_binEdges[this.M_index_mode3D + 1];
        float dm_l = (float)this.dist_binEdges[this.D_index_mode3D];
        float dm_u = (float)this.dist_binEdges[this.D_index_mode3D + 1];
        String results = "\n\n  Mbar = " + (float)this.Mbar + "\n  Dbar = " + (float)this.Dbar + "\n  Ebar = " + (float)this.Ebar + "\n" + "\n  " + mm_l + " \u00ef\u00bf\u00bd Mmode < " + mm_u + "\n  " + dm_l + " \u00ef\u00bf\u00bd Dmode < " + dm_u;
        results = results + "\n" + this.epsilonRangeString;
        if (this.totalRate == 0.0) {
            results = results + "\n\nNote:\nThe above NaN values result from the chosen IML\n(or that interpolated from the chosen probability)\nnever being exceeded.";
        }
        return results;
    }

    @Override
    public String getBinData() throws RemoteException {
        DecimalFormat f1 = new DecimalFormat("0.00");
        DecimalFormat f2 = new DecimalFormat("00.00");
        DecimalFormat f3 = new DecimalFormat("000.00");
        String binInfo = "Dist\tMag\tE\u00ef\u00bf\u00bd-2\t-2<E\u00ef\u00bf\u00bd-1\t-1<E\u00ef\u00bf\u00bd-0.5\t -0.5>E\u00ef\u00bf\u00bd0\t 0<E\u00ef\u00bf\u00bd0.5\t 0.5<E\u00ef\u00bf\u00bd1\t 1<E\u00ef\u00bf\u00bd2\t 2>E \n";
        binInfo = binInfo + "-----\t----\t------\t------\t-------\t-------\t-------\t-------\t-------\t------\n";
        for (int i = 0; i < this.dist_center.length; ++i) {
            for (int j = 0; j < this.mag_center.length; ++j) {
                binInfo = binInfo + f3.format(this.dist_center[i]) + " \t " + f1.format(this.mag_center[j]) + " \t ";
                String E_String = "";
                double totPercent = 0.0;
                for (int k = 0; k < this.NUM_E; ++k) {
                    double percent = this.pdf3D[i][j][k];
                    E_String = E_String + f2.format(percent) + " \t ";
                    totPercent += percent;
                }
                binInfo = binInfo + E_String + f2.format(totPercent) + "\n";
            }
        }
        return binInfo;
    }

    private void setIndices() {
        int i;
        this.withinBounds = true;
        this.iMag = -1;
        this.iDist = -1;
        for (i = 0; i < this.mag_center.length; ++i) {
            if (!(this.mag >= this.mag_binEdges[i]) || !(this.mag < this.mag_binEdges[i + 1])) continue;
            this.iMag = i;
            break;
        }
        for (i = 0; i < this.dist_center.length; ++i) {
            if (!(this.dist >= this.dist_binEdges[i]) || !(this.dist < this.dist_binEdges[i + 1])) continue;
            this.iDist = i;
            break;
        }
        if (this.epsilon <= -2.0) {
            this.iEpsilon = 0;
        } else if (this.epsilon > -2.0 && this.epsilon <= -1.0) {
            this.iEpsilon = 1;
        } else if (this.epsilon > -1.0 && this.epsilon <= -0.5) {
            this.iEpsilon = 2;
        } else if (this.epsilon > -0.5 && this.epsilon <= 0.0) {
            this.iEpsilon = 3;
        } else if (this.epsilon > 0.0 && this.epsilon <= 0.5) {
            this.iEpsilon = 4;
        } else if (this.epsilon > 0.5 && this.epsilon <= 1.0) {
            this.iEpsilon = 5;
        } else if (this.epsilon > 1.0 && this.epsilon <= 2.0) {
            this.iEpsilon = 6;
        } else if (this.epsilon > 2.0) {
            this.iEpsilon = 7;
        }
        if (this.iMag == -1) {
            this.withinBounds = false;
        }
        if (this.iDist == -1) {
            this.withinBounds = false;
        }
    }

    private String getEpsilonRange(int iEpsilon) {
        switch (iEpsilon) {
            case 0: {
                return "Emode <= -2";
            }
            case 1: {
                return "-2 < Emode <= -1";
            }
            case 2: {
                return "-1 < Emode <= -0.5";
            }
            case 3: {
                return "-0.5 < Emode <= 0.0";
            }
            case 4: {
                return "0.0 < Emode <= 0.5";
            }
            case 5: {
                return "0.5 < Emode <= 1.0";
            }
            case 6: {
                return "1.0 < Emode <= 2.0";
            }
            case 7: {
                return "2.0 < Emode ";
            }
        }
        return "Incorrect Index";
    }

    public ArrayList<String> createGMTScriptForDisaggregationPlot(String dir) {
        double x_axis_length = 4.5;
        double y_axis_length = 4.0;
        double z_axis_length = 2.5;
        int numTicksToDrawForZAxis = 5;
        this.maxContrEpsilonForGMT_Plot = this.maxContrEpsilonForDisaggrPlot;
        DisaggregationPlotData data = new DisaggregationPlotData(this.mag_center, this.mag_binEdges, this.dist_center, this.dist_binEdges, this.maxContrEpsilonForGMT_Plot, this.NUM_E, this.pdf3D);
        double z_tick = Math.ceil(data.getMaxContrEpsilonForGMT_Plot() / (double)numTicksToDrawForZAxis);
        double maxZVal = z_tick * (double)numTicksToDrawForZAxis;
        ArrayList<String> gmtScriptLines = new ArrayList<String>();
        System.out.println("maxContrEpsilonForDisaggrPlot " + this.maxContrEpsilonForDisaggrPlot + " maxZVal " + maxZVal);
        double[] dist_binEdges = data.getDist_binEdges();
        double[] mag_binEdges = data.getMag_binEdges();
        double[] dist_center = data.getDist_center();
        double[] mag_center = data.getMag_center();
        int numE = data.getNUM_E();
        double[][][] pdf3D = data.getPdf3D();
        float min_dist = (float)dist_binEdges[0];
        float max_dist = (float)dist_binEdges[dist_binEdges.length - 1];
        float min_mag = (float)mag_binEdges[0];
        float max_mag = (float)mag_binEdges[mag_binEdges.length - 1];
        double totDist = dist_binEdges[dist_binEdges.length - 1] - dist_binEdges[0];
        double x_tick = totDist < 115.0 ? 10.0 : (totDist < 225.0 ? 20.0 : (totDist < 335.0 ? 30.0 : (totDist < 445.0 ? 40.0 : 50.0)));
        double distBinWidthToInches = x_axis_length / totDist;
        double totMag = mag_binEdges[mag_binEdges.length - 1] - mag_binEdges[0];
        double y_tick = totMag < 5.0 ? 0.5 : 1.0;
        double magBinWidthToInches = y_axis_length / totMag;
        gmtScriptLines.add("#!/bin/bash");
        gmtScriptLines.add("");
        gmtScriptLines.add("cd " + dir);
        gmtScriptLines.add("");
        gmtScriptLines.addAll(GMT_MapGenerator.getGMTPathEnvLines());
        gmtScriptLines.add("## Plot Script ##");
        gmtScriptLines.add("");
        try {
            String region = "-R" + min_dist + "/" + max_dist + "/" + min_mag + "/" + max_mag + "/" + 0 + "/" + maxZVal;
            String projection = "-JX" + x_axis_length + "i/" + y_axis_length + "i";
            String viewAngle = "-E150/30";
            String boxPenWidth = "-W0.5p";
            String verticalScaling = "-JZ" + z_axis_length + "i";
            gmtScriptLines.add("${GMT_PATH}gmtset PAGE_COLOR 255/255/255");
            gmtScriptLines.add("${GMT_PATH}gmtset X_ORIGIN 1.0i");
            gmtScriptLines.add("${GMT_PATH}gmtset Y_ORIGIN 2.0i");
            gmtScriptLines.add("");
            String img_ps_file = "DisaggregationPlot.ps";
            String axisBoundaryTicksBounds = "-B" + x_tick + ":\"Rupture Distance (km)\":" + "/" + y_tick + ":Magnitude:" + "/" + z_tick + ":%Contribution:" + "wSnEZ";
            gmtScriptLines.add("${COMMAND_PATH}echo \"plotting axis\"");
            gmtScriptLines.add("${COMMAND_PATH}cat << END > temp_segments");
            System.out.println(z_tick + "   " + maxZVal + "   " + this.maxContrEpsilonForDisaggrPlot);
            for (double k = z_tick; k <= maxZVal; k += z_tick) {
                gmtScriptLines.add(">");
                gmtScriptLines.add(min_dist + "  " + min_mag + " " + k);
                gmtScriptLines.add(min_dist + "  " + max_mag + "  " + k);
                gmtScriptLines.add(">");
                gmtScriptLines.add(min_dist + "  " + max_mag + "  " + k);
                gmtScriptLines.add(max_dist + "   " + max_mag + "  " + k);
            }
            gmtScriptLines.add(">");
            gmtScriptLines.add(min_dist + "   " + max_mag + "  " + 0);
            gmtScriptLines.add(min_dist + "  " + max_mag + "  " + maxZVal);
            gmtScriptLines.add(">");
            gmtScriptLines.add(max_dist + "  " + max_mag + " " + 0);
            gmtScriptLines.add(max_dist + "  " + max_mag + " " + maxZVal);
            gmtScriptLines.add("END");
            gmtScriptLines.add("");
            gmtScriptLines.add("${GMT_PATH}psxyz temp_segments -P " + region + " -M  " + projection + "  " + verticalScaling + " -K -G0/0/0 " + viewAngle + "  " + boxPenWidth + "  " + axisBoundaryTicksBounds + " >  " + img_ps_file);
            gmtScriptLines.add("${COMMAND_PATH}echo \"plotting disagg\"");
            for (int i = 0; i < dist_center.length; ++i) {
                gmtScriptLines.add("${COMMAND_PATH}echo \"plotting dist bin " + i + "\"");
                for (int j = mag_center.length - 1; j >= 0; --j) {
                    double box_x_width = (dist_binEdges[i + 1] - dist_binEdges[i]) * distBinWidthToInches - 0.05;
                    double box_y_width = (mag_binEdges[j + 1] - mag_binEdges[j]) * magBinWidthToInches - 0.05;
                    String symbol = " -So" + box_x_width + "i/" + box_y_width + "ib";
                    float base = 0.0f;
                    float top = 0.0f;
                    for (int k = 0; k < numE; ++k) {
                        float contribution = (float)pdf3D[i][j][k];
                        top = base + contribution;
                        if (!((double)contribution > 0.0)) continue;
                        gmtScriptLines.add("${COMMAND_PATH}echo \"" + dist_center[i] + " " + mag_center[j] + " " + top + "\"" + " | ${GMT_PATH}psxyz " + "-P " + region + " " + projection + " " + verticalScaling + symbol + base + " -K -O " + epsilonColors[k] + "  " + viewAngle + "  " + boxPenWidth + " >> " + img_ps_file);
                        base = top;
                    }
                }
            }
            gmtScriptLines.add("");
            gmtScriptLines.add("${COMMAND_PATH}echo \"plotting legend\"");
            gmtScriptLines.add("${COMMAND_PATH}echo \"" + dist_binEdges[dist_binEdges.length - 1] + " " + mag_binEdges[0] + " " + 0.8 * z_tick + "\"" + " | ${GMT_PATH}psxyz " + "-P -Y-1.25i -X-4.2i " + region + " " + projection + " " + verticalScaling + " -So0.3ib0 " + " -K -O " + epsilonColors[0] + "  " + viewAngle + "  " + boxPenWidth + " >> " + img_ps_file);
            for (int k = 1; k < numE; ++k) {
                gmtScriptLines.add("${COMMAND_PATH}echo \"" + dist_binEdges[dist_binEdges.length - 1] + " " + mag_binEdges[0] + " " + 0.8 * z_tick + "\"" + " | ${GMT_PATH}psxyz " + "-P -X0.9i " + region + " " + projection + " " + verticalScaling + " -So0.3ib0 " + " -K -O " + epsilonColors[k] + "  " + viewAngle + "  " + boxPenWidth + " >> " + img_ps_file);
            }
            gmtScriptLines.add("${COMMAND_PATH}echo \"0.0 0.75 13 0.0 12 CB e<-2\" > temp_label");
            gmtScriptLines.add("${COMMAND_PATH}echo \"0.9 0.75 13 0.0 12 CB -2<e<-1\" >> temp_label");
            gmtScriptLines.add("${COMMAND_PATH}echo \"1.8 0.75 13 0.0 12 CB -1<e<-0.5\" >> temp_label");
            gmtScriptLines.add("${COMMAND_PATH}echo \"2.7 0.75 13 0.0 12 CB -0.5<e<0\" >> temp_label");
            gmtScriptLines.add("${COMMAND_PATH}echo \"3.6 0.75 13 0.0 12 CB 0<e<0.5\" >> temp_label");
            gmtScriptLines.add("${COMMAND_PATH}echo \"4.5 0.75 13 0.0 12 CB 0.5<e<1\" >> temp_label");
            gmtScriptLines.add("${COMMAND_PATH}echo \"5.4 0.75 13 0.0 12 CB 1<e<2\" >> temp_label");
            gmtScriptLines.add("${COMMAND_PATH}echo \"6.3 0.75 13 0.0 12 CB 2<e\" >> temp_label");
            gmtScriptLines.add("${GMT_PATH}pstext temp_label -R0/8.5/0/11 -N -Jx1i -X-6.1 -P -O >> " + img_ps_file);
            gmtScriptLines.add("");
            gmtScriptLines.add("${COMMAND_PATH}echo \"converting postscript\"");
            gmtScriptLines.add("${COMMAND_PATH}cat " + img_ps_file + " |" + "gs -sDEVICE=jpeg -sOutputFile=temp.jpg" + " -");
            gmtScriptLines.add("${PS2PDF_PATH} " + img_ps_file + "  " + DISAGGREGATION_PLOT_PDF_NAME);
            gmtScriptLines.add("${CONVERT_PATH} -crop 0x0 temp.jpg DisaggregationPlot.jpg");
            gmtScriptLines.add("${COMMAND_PATH}rm temp.jpg temp_segments");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return gmtScriptLines;
    }

    @Override
    public void setNumSourcestoShow(int numSources) throws RemoteException {
        this.numSourcesToShow = numSources;
    }

    @Override
    public boolean disaggregate(double iml, Site site, ScalarIntensityMeasureRelationshipAPI imr, EqkRupForecast eqkRupForecast, double maxDist, ArbitrarilyDiscretizedFunc magDistFilter) throws RemoteException {
        return false;
    }

    @Override
    public String getDisaggregationPlotUsingServlet(String metadata) throws RemoteException {
        return null;
    }
}

